/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.serialKey;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.serialKey.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.serialKey.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.serialKey.request.CheckImportUserDataByUserIdRequest;
import io.gs2.serialKey.request.CleanUserDataByUserIdRequest;
import io.gs2.serialKey.request.CreateCampaignModelMasterRequest;
import io.gs2.serialKey.request.CreateNamespaceRequest;
import io.gs2.serialKey.request.DeleteCampaignModelMasterRequest;
import io.gs2.serialKey.request.DeleteNamespaceRequest;
import io.gs2.serialKey.request.DescribeCampaignModelMastersRequest;
import io.gs2.serialKey.request.DescribeCampaignModelsRequest;
import io.gs2.serialKey.request.DescribeIssueJobsRequest;
import io.gs2.serialKey.request.DescribeNamespacesRequest;
import io.gs2.serialKey.request.DescribeSerialKeysRequest;
import io.gs2.serialKey.request.DownloadSerialCodesRequest;
import io.gs2.serialKey.request.DumpUserDataByUserIdRequest;
import io.gs2.serialKey.request.ExportMasterRequest;
import io.gs2.serialKey.request.GetCampaignModelMasterRequest;
import io.gs2.serialKey.request.GetCampaignModelRequest;
import io.gs2.serialKey.request.GetCurrentCampaignMasterRequest;
import io.gs2.serialKey.request.GetIssueJobRequest;
import io.gs2.serialKey.request.GetNamespaceRequest;
import io.gs2.serialKey.request.GetNamespaceStatusRequest;
import io.gs2.serialKey.request.GetSerialKeyRequest;
import io.gs2.serialKey.request.ImportUserDataByUserIdRequest;
import io.gs2.serialKey.request.IssueRequest;
import io.gs2.serialKey.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.serialKey.request.RevertUseByStampSheetRequest;
import io.gs2.serialKey.request.RevertUseByUserIdRequest;
import io.gs2.serialKey.request.UpdateCampaignModelMasterRequest;
import io.gs2.serialKey.request.UpdateCurrentCampaignMasterFromGitHubRequest;
import io.gs2.serialKey.request.UpdateCurrentCampaignMasterRequest;
import io.gs2.serialKey.request.UpdateNamespaceRequest;
import io.gs2.serialKey.request.UseByStampTaskRequest;
import io.gs2.serialKey.request.UseByUserIdRequest;
import io.gs2.serialKey.request.UseRequest;
import io.gs2.serialKey.result.CheckCleanUserDataByUserIdResult;
import io.gs2.serialKey.result.CheckDumpUserDataByUserIdResult;
import io.gs2.serialKey.result.CheckImportUserDataByUserIdResult;
import io.gs2.serialKey.result.CleanUserDataByUserIdResult;
import io.gs2.serialKey.result.CreateCampaignModelMasterResult;
import io.gs2.serialKey.result.CreateNamespaceResult;
import io.gs2.serialKey.result.DeleteCampaignModelMasterResult;
import io.gs2.serialKey.result.DeleteNamespaceResult;
import io.gs2.serialKey.result.DescribeCampaignModelMastersResult;
import io.gs2.serialKey.result.DescribeCampaignModelsResult;
import io.gs2.serialKey.result.DescribeIssueJobsResult;
import io.gs2.serialKey.result.DescribeNamespacesResult;
import io.gs2.serialKey.result.DescribeSerialKeysResult;
import io.gs2.serialKey.result.DownloadSerialCodesResult;
import io.gs2.serialKey.result.DumpUserDataByUserIdResult;
import io.gs2.serialKey.result.ExportMasterResult;
import io.gs2.serialKey.result.GetCampaignModelMasterResult;
import io.gs2.serialKey.result.GetCampaignModelResult;
import io.gs2.serialKey.result.GetCurrentCampaignMasterResult;
import io.gs2.serialKey.result.GetIssueJobResult;
import io.gs2.serialKey.result.GetNamespaceResult;
import io.gs2.serialKey.result.GetNamespaceStatusResult;
import io.gs2.serialKey.result.GetSerialKeyResult;
import io.gs2.serialKey.result.ImportUserDataByUserIdResult;
import io.gs2.serialKey.result.IssueResult;
import io.gs2.serialKey.result.PrepareImportUserDataByUserIdResult;
import io.gs2.serialKey.result.RevertUseByStampSheetResult;
import io.gs2.serialKey.result.RevertUseByUserIdResult;
import io.gs2.serialKey.result.UpdateCampaignModelMasterResult;
import io.gs2.serialKey.result.UpdateCurrentCampaignMasterFromGitHubResult;
import io.gs2.serialKey.result.UpdateCurrentCampaignMasterResult;
import io.gs2.serialKey.result.UpdateNamespaceResult;
import io.gs2.serialKey.result.UseByStampTaskResult;
import io.gs2.serialKey.result.UseByUserIdResult;
import io.gs2.serialKey.result.UseResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2SerialKeyRestClient
extends AbstractGs2Client<Gs2SerialKeyRestClient> {
    public Gs2SerialKeyRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeIssueJobsAsync(DescribeIssueJobsRequest request, AsyncAction<AsyncResult<DescribeIssueJobsResult>> callback) {
        DescribeIssueJobsTask task = new DescribeIssueJobsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeIssueJobsResult describeIssueJobs(DescribeIssueJobsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeIssueJobsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeIssueJobsResult)resultAsyncResult[0].getResult();
    }

    public void getIssueJobAsync(GetIssueJobRequest request, AsyncAction<AsyncResult<GetIssueJobResult>> callback) {
        GetIssueJobTask task = new GetIssueJobTask(request, callback);
        this.session.execute(task);
    }

    public GetIssueJobResult getIssueJob(GetIssueJobRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getIssueJobAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetIssueJobResult)resultAsyncResult[0].getResult();
    }

    public void issueAsync(IssueRequest request, AsyncAction<AsyncResult<IssueResult>> callback) {
        IssueTask task = new IssueTask(request, callback);
        this.session.execute(task);
    }

    public IssueResult issue(IssueRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.issueAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (IssueResult)resultAsyncResult[0].getResult();
    }

    public void describeSerialKeysAsync(DescribeSerialKeysRequest request, AsyncAction<AsyncResult<DescribeSerialKeysResult>> callback) {
        DescribeSerialKeysTask task = new DescribeSerialKeysTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSerialKeysResult describeSerialKeys(DescribeSerialKeysRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSerialKeysAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSerialKeysResult)resultAsyncResult[0].getResult();
    }

    public void downloadSerialCodesAsync(DownloadSerialCodesRequest request, AsyncAction<AsyncResult<DownloadSerialCodesResult>> callback) {
        DownloadSerialCodesTask task = new DownloadSerialCodesTask(request, callback);
        this.session.execute(task);
    }

    public DownloadSerialCodesResult downloadSerialCodes(DownloadSerialCodesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.downloadSerialCodesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DownloadSerialCodesResult)resultAsyncResult[0].getResult();
    }

    public void getSerialKeyAsync(GetSerialKeyRequest request, AsyncAction<AsyncResult<GetSerialKeyResult>> callback) {
        GetSerialKeyTask task = new GetSerialKeyTask(request, callback);
        this.session.execute(task);
    }

    public GetSerialKeyResult getSerialKey(GetSerialKeyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSerialKeyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSerialKeyResult)resultAsyncResult[0].getResult();
    }

    public void useAsync(UseRequest request, AsyncAction<AsyncResult<UseResult>> callback) {
        UseTask task = new UseTask(request, callback);
        this.session.execute(task);
    }

    public UseResult use(UseRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.useAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UseResult)resultAsyncResult[0].getResult();
    }

    public void useByUserIdAsync(UseByUserIdRequest request, AsyncAction<AsyncResult<UseByUserIdResult>> callback) {
        UseByUserIdTask task = new UseByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UseByUserIdResult useByUserId(UseByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.useByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UseByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void revertUseByUserIdAsync(RevertUseByUserIdRequest request, AsyncAction<AsyncResult<RevertUseByUserIdResult>> callback) {
        RevertUseByUserIdTask task = new RevertUseByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public RevertUseByUserIdResult revertUseByUserId(RevertUseByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.revertUseByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RevertUseByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void useByStampTaskAsync(UseByStampTaskRequest request, AsyncAction<AsyncResult<UseByStampTaskResult>> callback) {
        UseByStampTaskTask task = new UseByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public UseByStampTaskResult useByStampTask(UseByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.useByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UseByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void revertUseByStampSheetAsync(RevertUseByStampSheetRequest request, AsyncAction<AsyncResult<RevertUseByStampSheetResult>> callback) {
        RevertUseByStampSheetTask task = new RevertUseByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public RevertUseByStampSheetResult revertUseByStampSheet(RevertUseByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.revertUseByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RevertUseByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void describeCampaignModelsAsync(DescribeCampaignModelsRequest request, AsyncAction<AsyncResult<DescribeCampaignModelsResult>> callback) {
        DescribeCampaignModelsTask task = new DescribeCampaignModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCampaignModelsResult describeCampaignModels(DescribeCampaignModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCampaignModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCampaignModelsResult)resultAsyncResult[0].getResult();
    }

    public void getCampaignModelAsync(GetCampaignModelRequest request, AsyncAction<AsyncResult<GetCampaignModelResult>> callback) {
        GetCampaignModelTask task = new GetCampaignModelTask(request, callback);
        this.session.execute(task);
    }

    public GetCampaignModelResult getCampaignModel(GetCampaignModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCampaignModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCampaignModelResult)resultAsyncResult[0].getResult();
    }

    public void describeCampaignModelMastersAsync(DescribeCampaignModelMastersRequest request, AsyncAction<AsyncResult<DescribeCampaignModelMastersResult>> callback) {
        DescribeCampaignModelMastersTask task = new DescribeCampaignModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCampaignModelMastersResult describeCampaignModelMasters(DescribeCampaignModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCampaignModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCampaignModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createCampaignModelMasterAsync(CreateCampaignModelMasterRequest request, AsyncAction<AsyncResult<CreateCampaignModelMasterResult>> callback) {
        CreateCampaignModelMasterTask task = new CreateCampaignModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateCampaignModelMasterResult createCampaignModelMaster(CreateCampaignModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createCampaignModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateCampaignModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCampaignModelMasterAsync(GetCampaignModelMasterRequest request, AsyncAction<AsyncResult<GetCampaignModelMasterResult>> callback) {
        GetCampaignModelMasterTask task = new GetCampaignModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCampaignModelMasterResult getCampaignModelMaster(GetCampaignModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCampaignModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCampaignModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCampaignModelMasterAsync(UpdateCampaignModelMasterRequest request, AsyncAction<AsyncResult<UpdateCampaignModelMasterResult>> callback) {
        UpdateCampaignModelMasterTask task = new UpdateCampaignModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCampaignModelMasterResult updateCampaignModelMaster(UpdateCampaignModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCampaignModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCampaignModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteCampaignModelMasterAsync(DeleteCampaignModelMasterRequest request, AsyncAction<AsyncResult<DeleteCampaignModelMasterResult>> callback) {
        DeleteCampaignModelMasterTask task = new DeleteCampaignModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteCampaignModelMasterResult deleteCampaignModelMaster(DeleteCampaignModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteCampaignModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteCampaignModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentCampaignMasterAsync(GetCurrentCampaignMasterRequest request, AsyncAction<AsyncResult<GetCurrentCampaignMasterResult>> callback) {
        GetCurrentCampaignMasterTask task = new GetCurrentCampaignMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentCampaignMasterResult getCurrentCampaignMaster(GetCurrentCampaignMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentCampaignMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentCampaignMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentCampaignMasterAsync(UpdateCurrentCampaignMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentCampaignMasterResult>> callback) {
        UpdateCurrentCampaignMasterTask task = new UpdateCurrentCampaignMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentCampaignMasterResult updateCurrentCampaignMaster(UpdateCurrentCampaignMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentCampaignMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentCampaignMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentCampaignMasterFromGitHubAsync(UpdateCurrentCampaignMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentCampaignMasterFromGitHubResult>> callback) {
        UpdateCurrentCampaignMasterFromGitHubTask task = new UpdateCurrentCampaignMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentCampaignMasterFromGitHubResult updateCurrentCampaignMasterFromGitHub(UpdateCurrentCampaignMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentCampaignMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentCampaignMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeIssueJobsTask
    extends Gs2RestSessionTask<DescribeIssueJobsResult> {
        private DescribeIssueJobsRequest request;

        public DescribeIssueJobsTask(DescribeIssueJobsRequest request, AsyncAction<AsyncResult<DescribeIssueJobsResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeIssueJobsResult parse(JsonNode data) {
            return DescribeIssueJobsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/campaign/{campaignModelName}/issue";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetIssueJobTask
    extends Gs2RestSessionTask<GetIssueJobResult> {
        private GetIssueJobRequest request;

        public GetIssueJobTask(GetIssueJobRequest request, AsyncAction<AsyncResult<GetIssueJobResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetIssueJobResult parse(JsonNode data) {
            return GetIssueJobResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/campaign/{campaignModelName}/issue/{issueJobName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            url = url.replace("{issueJobName}", this.request.getIssueJobName() == null || this.request.getIssueJobName().length() == 0 ? "null" : String.valueOf(this.request.getIssueJobName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class IssueTask
    extends Gs2RestSessionTask<IssueResult> {
        private IssueRequest request;

        public IssueTask(IssueRequest request, AsyncAction<AsyncResult<IssueResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public IssueResult parse(JsonNode data) {
            return IssueResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/campaign/{campaignModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("metadata", IssueTask.this.request.getMetadata());
                    this.put("issueRequestCount", IssueTask.this.request.getIssueRequestCount());
                    this.put("contextStack", IssueTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSerialKeysTask
    extends Gs2RestSessionTask<DescribeSerialKeysResult> {
        private DescribeSerialKeysRequest request;

        public DescribeSerialKeysTask(DescribeSerialKeysRequest request, AsyncAction<AsyncResult<DescribeSerialKeysResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSerialKeysResult parse(JsonNode data) {
            return DescribeSerialKeysResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/campaign/{campaignModelName}/issue/{issueJobName}/serialKey";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            url = url.replace("{issueJobName}", this.request.getIssueJobName() == null || this.request.getIssueJobName().length() == 0 ? "null" : String.valueOf(this.request.getIssueJobName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DownloadSerialCodesTask
    extends Gs2RestSessionTask<DownloadSerialCodesResult> {
        private DownloadSerialCodesRequest request;

        public DownloadSerialCodesTask(DownloadSerialCodesRequest request, AsyncAction<AsyncResult<DownloadSerialCodesResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DownloadSerialCodesResult parse(JsonNode data) {
            return DownloadSerialCodesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/campaign/{campaignModelName}/issue/{issueJobName}/serialCode/download";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            url = url.replace("{issueJobName}", this.request.getIssueJobName() == null || this.request.getIssueJobName().length() == 0 ? "null" : String.valueOf(this.request.getIssueJobName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetSerialKeyTask
    extends Gs2RestSessionTask<GetSerialKeyResult> {
        private GetSerialKeyRequest request;

        public GetSerialKeyTask(GetSerialKeyRequest request, AsyncAction<AsyncResult<GetSerialKeyResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSerialKeyResult parse(JsonNode data) {
            return GetSerialKeyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/serialKey/{code}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{code}", this.request.getCode() == null || this.request.getCode().length() == 0 ? "null" : String.valueOf(this.request.getCode()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UseTask
    extends Gs2RestSessionTask<UseResult> {
        private UseRequest request;

        public UseTask(UseRequest request, AsyncAction<AsyncResult<UseResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UseResult parse(JsonNode data) {
            return UseResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/serialKey";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("code", UseTask.this.request.getCode());
                    this.put("contextStack", UseTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UseByUserIdTask
    extends Gs2RestSessionTask<UseByUserIdResult> {
        private UseByUserIdRequest request;

        public UseByUserIdTask(UseByUserIdRequest request, AsyncAction<AsyncResult<UseByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UseByUserIdResult parse(JsonNode data) {
            return UseByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/serialKey";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("code", UseByUserIdTask.this.request.getCode());
                    this.put("contextStack", UseByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class RevertUseByUserIdTask
    extends Gs2RestSessionTask<RevertUseByUserIdResult> {
        private RevertUseByUserIdRequest request;

        public RevertUseByUserIdTask(RevertUseByUserIdRequest request, AsyncAction<AsyncResult<RevertUseByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RevertUseByUserIdResult parse(JsonNode data) {
            return RevertUseByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/serialKey/revert";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("code", RevertUseByUserIdTask.this.request.getCode());
                    this.put("contextStack", RevertUseByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UseByStampTaskTask
    extends Gs2RestSessionTask<UseByStampTaskResult> {
        private UseByStampTaskRequest request;

        public UseByStampTaskTask(UseByStampTaskRequest request, AsyncAction<AsyncResult<UseByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UseByStampTaskResult parse(JsonNode data) {
            return UseByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/serialKey/use";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", UseByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", UseByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", UseByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RevertUseByStampSheetTask
    extends Gs2RestSessionTask<RevertUseByStampSheetResult> {
        private RevertUseByStampSheetRequest request;

        public RevertUseByStampSheetTask(RevertUseByStampSheetRequest request, AsyncAction<AsyncResult<RevertUseByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RevertUseByStampSheetResult parse(JsonNode data) {
            return RevertUseByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/serialKey/use";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", RevertUseByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", RevertUseByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", RevertUseByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCampaignModelsTask
    extends Gs2RestSessionTask<DescribeCampaignModelsResult> {
        private DescribeCampaignModelsRequest request;

        public DescribeCampaignModelsTask(DescribeCampaignModelsRequest request, AsyncAction<AsyncResult<DescribeCampaignModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCampaignModelsResult parse(JsonNode data) {
            return DescribeCampaignModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/campaign";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCampaignModelTask
    extends Gs2RestSessionTask<GetCampaignModelResult> {
        private GetCampaignModelRequest request;

        public GetCampaignModelTask(GetCampaignModelRequest request, AsyncAction<AsyncResult<GetCampaignModelResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCampaignModelResult parse(JsonNode data) {
            return GetCampaignModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/campaign/{campaignModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCampaignModelMastersTask
    extends Gs2RestSessionTask<DescribeCampaignModelMastersResult> {
        private DescribeCampaignModelMastersRequest request;

        public DescribeCampaignModelMastersTask(DescribeCampaignModelMastersRequest request, AsyncAction<AsyncResult<DescribeCampaignModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCampaignModelMastersResult parse(JsonNode data) {
            return DescribeCampaignModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/campaign";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateCampaignModelMasterTask
    extends Gs2RestSessionTask<CreateCampaignModelMasterResult> {
        private CreateCampaignModelMasterRequest request;

        public CreateCampaignModelMasterTask(CreateCampaignModelMasterRequest request, AsyncAction<AsyncResult<CreateCampaignModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateCampaignModelMasterResult parse(JsonNode data) {
            return CreateCampaignModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/campaign";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateCampaignModelMasterTask.this.request.getName());
                    this.put("description", CreateCampaignModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateCampaignModelMasterTask.this.request.getMetadata());
                    this.put("enableCampaignCode", CreateCampaignModelMasterTask.this.request.getEnableCampaignCode());
                    this.put("contextStack", CreateCampaignModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCampaignModelMasterTask
    extends Gs2RestSessionTask<GetCampaignModelMasterResult> {
        private GetCampaignModelMasterRequest request;

        public GetCampaignModelMasterTask(GetCampaignModelMasterRequest request, AsyncAction<AsyncResult<GetCampaignModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCampaignModelMasterResult parse(JsonNode data) {
            return GetCampaignModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/campaign/{campaignModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCampaignModelMasterTask
    extends Gs2RestSessionTask<UpdateCampaignModelMasterResult> {
        private UpdateCampaignModelMasterRequest request;

        public UpdateCampaignModelMasterTask(UpdateCampaignModelMasterRequest request, AsyncAction<AsyncResult<UpdateCampaignModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCampaignModelMasterResult parse(JsonNode data) {
            return UpdateCampaignModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/campaign/{campaignModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateCampaignModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateCampaignModelMasterTask.this.request.getMetadata());
                    this.put("enableCampaignCode", UpdateCampaignModelMasterTask.this.request.getEnableCampaignCode());
                    this.put("contextStack", UpdateCampaignModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteCampaignModelMasterTask
    extends Gs2RestSessionTask<DeleteCampaignModelMasterResult> {
        private DeleteCampaignModelMasterRequest request;

        public DeleteCampaignModelMasterTask(DeleteCampaignModelMasterRequest request, AsyncAction<AsyncResult<DeleteCampaignModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteCampaignModelMasterResult parse(JsonNode data) {
            return DeleteCampaignModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/campaign/{campaignModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{campaignModelName}", this.request.getCampaignModelName() == null || this.request.getCampaignModelName().length() == 0 ? "null" : String.valueOf(this.request.getCampaignModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentCampaignMasterTask
    extends Gs2RestSessionTask<GetCurrentCampaignMasterResult> {
        private GetCurrentCampaignMasterRequest request;

        public GetCurrentCampaignMasterTask(GetCurrentCampaignMasterRequest request, AsyncAction<AsyncResult<GetCurrentCampaignMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentCampaignMasterResult parse(JsonNode data) {
            return GetCurrentCampaignMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentCampaignMasterTask
    extends Gs2RestSessionTask<UpdateCurrentCampaignMasterResult> {
        private UpdateCurrentCampaignMasterRequest request;

        public UpdateCurrentCampaignMasterTask(UpdateCurrentCampaignMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentCampaignMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentCampaignMasterResult parse(JsonNode data) {
            return UpdateCurrentCampaignMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentCampaignMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentCampaignMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentCampaignMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentCampaignMasterFromGitHubResult> {
        private UpdateCurrentCampaignMasterFromGitHubRequest request;

        public UpdateCurrentCampaignMasterFromGitHubTask(UpdateCurrentCampaignMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentCampaignMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2SerialKeyRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentCampaignMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentCampaignMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "serial-key").replace("{region}", Gs2SerialKeyRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentCampaignMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentCampaignMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentCampaignMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

