/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.lottery.model.DrawnPrize;
import java.io.Serializable;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Probability
implements IModel,
Serializable {
    private DrawnPrize prize;
    private Float rate;

    public DrawnPrize getPrize() {
        return this.prize;
    }

    public void setPrize(DrawnPrize prize) {
        this.prize = prize;
    }

    public Probability withPrize(DrawnPrize prize) {
        this.prize = prize;
        return this;
    }

    public Float getRate() {
        return this.rate;
    }

    public void setRate(Float rate) {
        this.rate = rate;
    }

    public Probability withRate(Float rate) {
        this.rate = rate;
        return this;
    }

    public static Probability fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new Probability().withPrize(data.get("prize") == null || data.get("prize").isNull() ? null : DrawnPrize.fromJson(data.get("prize"))).withRate(data.get("rate") == null || data.get("rate").isNull() ? null : Float.valueOf(data.get("rate").floatValue()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("prize", Probability.this.getPrize() != null ? Probability.this.getPrize().toJson() : null);
                this.put("rate", Probability.this.getRate());
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.prize == null ? 0 : this.prize.hashCode());
        result = 31 * result + (this.rate == null ? 0 : this.rate.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Probability other = (Probability)o;
        if (this.prize == null) {
            return other.prize == null;
        }
        if (!this.prize.equals(other.prize)) {
            return false;
        }
        if (this.rate == null) {
            return other.rate == null;
        }
        return this.rate.equals(other.rate);
    }
}

