/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.inventory.model.ItemModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InventoryModel
implements IModel,
Serializable,
Comparable<InventoryModel> {
    private String inventoryModelId;
    private String name;
    private String metadata;
    private Integer initialCapacity;
    private Integer maxCapacity;
    private Boolean protectReferencedItem;
    private List<ItemModel> itemModels;

    public String getInventoryModelId() {
        return this.inventoryModelId;
    }

    public void setInventoryModelId(String inventoryModelId) {
        this.inventoryModelId = inventoryModelId;
    }

    public InventoryModel withInventoryModelId(String inventoryModelId) {
        this.inventoryModelId = inventoryModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InventoryModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public InventoryModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(Integer initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public InventoryModel withInitialCapacity(Integer initialCapacity) {
        this.initialCapacity = initialCapacity;
        return this;
    }

    public Integer getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public InventoryModel withMaxCapacity(Integer maxCapacity) {
        this.maxCapacity = maxCapacity;
        return this;
    }

    public Boolean getProtectReferencedItem() {
        return this.protectReferencedItem;
    }

    public void setProtectReferencedItem(Boolean protectReferencedItem) {
        this.protectReferencedItem = protectReferencedItem;
    }

    public InventoryModel withProtectReferencedItem(Boolean protectReferencedItem) {
        this.protectReferencedItem = protectReferencedItem;
        return this;
    }

    public List<ItemModel> getItemModels() {
        return this.itemModels;
    }

    public void setItemModels(List<ItemModel> itemModels) {
        this.itemModels = itemModels;
    }

    public InventoryModel withItemModels(List<ItemModel> itemModels) {
        this.itemModels = itemModels;
        return this;
    }

    public static InventoryModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new InventoryModel().withInventoryModelId(data.get("inventoryModelId") == null || data.get("inventoryModelId").isNull() ? null : data.get("inventoryModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withInitialCapacity(data.get("initialCapacity") == null || data.get("initialCapacity").isNull() ? null : Integer.valueOf(data.get("initialCapacity").intValue())).withMaxCapacity(data.get("maxCapacity") == null || data.get("maxCapacity").isNull() ? null : Integer.valueOf(data.get("maxCapacity").intValue())).withProtectReferencedItem(data.get("protectReferencedItem") == null || data.get("protectReferencedItem").isNull() ? null : Boolean.valueOf(data.get("protectReferencedItem").booleanValue())).withItemModels(data.get("itemModels") == null || data.get("itemModels").isNull() ? new ArrayList<ItemModel>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("itemModels").elements(), 256), false).map(item -> ItemModel.fromJson(item)).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("inventoryModelId", InventoryModel.this.getInventoryModelId());
                this.put("name", InventoryModel.this.getName());
                this.put("metadata", InventoryModel.this.getMetadata());
                this.put("initialCapacity", InventoryModel.this.getInitialCapacity());
                this.put("maxCapacity", InventoryModel.this.getMaxCapacity());
                this.put("protectReferencedItem", InventoryModel.this.getProtectReferencedItem());
                this.put("itemModels", InventoryModel.this.getItemModels() == null ? new ArrayList() : InventoryModel.this.getItemModels().stream().map(item -> item.toJson()).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(InventoryModel o) {
        return this.inventoryModelId.compareTo(o.inventoryModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inventoryModelId == null ? 0 : this.inventoryModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.initialCapacity == null ? 0 : this.initialCapacity.hashCode());
        result = 31 * result + (this.maxCapacity == null ? 0 : this.maxCapacity.hashCode());
        result = 31 * result + (this.protectReferencedItem == null ? 0 : this.protectReferencedItem.hashCode());
        result = 31 * result + (this.itemModels == null ? 0 : this.itemModels.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        InventoryModel other = (InventoryModel)o;
        if (this.inventoryModelId == null) {
            return other.inventoryModelId == null;
        }
        if (!this.inventoryModelId.equals(other.inventoryModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.initialCapacity == null) {
            return other.initialCapacity == null;
        }
        if (!this.initialCapacity.equals(other.initialCapacity)) {
            return false;
        }
        if (this.maxCapacity == null) {
            return other.maxCapacity == null;
        }
        if (!this.maxCapacity.equals(other.maxCapacity)) {
            return false;
        }
        if (this.protectReferencedItem == null) {
            return other.protectReferencedItem == null;
        }
        if (!this.protectReferencedItem.equals(other.protectReferencedItem)) {
            return false;
        }
        if (this.itemModels == null) {
            return other.itemModels == null;
        }
        return this.itemModels.equals(other.itemModels);
    }
}

