/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.net;

import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.SessionNotOpenException;
import io.gs2.core.exception.UnknownException;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.model.BasicGs2Credential;
import io.gs2.core.model.Region;
import io.gs2.core.net.Gs2ClientErrorResponse;
import io.gs2.core.net.Gs2SessionTask;
import io.gs2.core.net.Gs2SessionTaskId;
import io.gs2.core.result.CloseResult;
import io.gs2.core.result.OpenResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Gs2Session {
    private ReentrantLock m_Mutex = new ReentrantLock();
    private State m_State;
    private final BasicGs2Credential m_Gs2Credential;
    private Region m_Region;
    private String m_ProjectToken;
    private List<AsyncAction<AsyncResult<OpenResult>>> openCallbackList = new ArrayList<AsyncAction<AsyncResult<OpenResult>>>();
    private List<AsyncAction<AsyncResult<CloseResult>>> closeCallbackList = new ArrayList<AsyncAction<AsyncResult<CloseResult>>>();
    private List<Gs2SessionTask> gs2SessionTaskList = new ArrayList<Gs2SessionTask>();
    private AsyncAction<AsyncResult<CloseResult>> m_OnClose;
    private Gs2SessionTaskId.Generator m_Gs2SessionIdTaskGenerator = new Gs2SessionTaskId.Generator();

    private static void triggerOpenCallback(List<AsyncAction<AsyncResult<OpenResult>>> openCallbackList, Gs2Exception result) {
        for (AsyncAction<AsyncResult<OpenResult>> pOpenCallback : openCallbackList) {
            pOpenCallback.callback(new AsyncResult<OpenResult>(new OpenResult(), result));
        }
    }

    private static void triggerCloseCallback(List<AsyncAction<AsyncResult<CloseResult>>> closeCallbackList, Gs2Exception result) {
        for (AsyncAction<AsyncResult<CloseResult>> pCloseCallback : closeCallbackList) {
            pCloseCallback.callback(new AsyncResult<CloseResult>(new CloseResult(), result));
        }
    }

    private static void triggerCancelTasksCallback(List<Gs2SessionTask> gs2SessionTaskList, Gs2Exception gs2Exception) {
        for (Gs2SessionTask pGs2SessionTask : gs2SessionTaskList) {
            pGs2SessionTask.triggerUserCallback(new Gs2ClientErrorResponse(gs2Exception));
        }
    }

    private void enterStateLock() {
        this.m_Mutex.lock();
    }

    private void exitStateLock() {
        this.m_Mutex.unlock();
    }

    private void changeStateToIdle() {
        assert (this.openCallbackList.isEmpty());
        assert (this.closeCallbackList.isEmpty());
        assert (this.gs2SessionTaskList.isEmpty());
        this.m_State = State.Idle;
        this.exitStateLock();
    }

    private void changeStateToOpening() {
        assert (this.m_State == State.Idle || this.m_State == State.Closing);
        assert (!this.openCallbackList.isEmpty());
        assert (this.closeCallbackList.isEmpty());
        assert (this.gs2SessionTaskList.isEmpty());
        this.m_State = State.Opening;
        this.openImpl();
        this.exitStateLock();
    }

    private void changeStateToCancellingOpen() {
        assert (this.m_State == State.Opening);
        assert (!this.openCallbackList.isEmpty());
        assert (!this.closeCallbackList.isEmpty());
        assert (this.gs2SessionTaskList.isEmpty());
        this.m_State = State.CancellingOpen;
        this.cancelOpenImpl();
        this.exitStateLock();
    }

    private void changeStateToAvailable(String projectToken) {
        assert (this.m_State == State.Opening);
        assert (this.openCallbackList.isEmpty());
        assert (this.closeCallbackList.isEmpty());
        assert (this.gs2SessionTaskList.isEmpty());
        this.m_ProjectToken = projectToken;
        this.m_State = State.Available;
        this.exitStateLock();
    }

    private void changeStateToCancellingTasks() {
        assert (this.m_State == State.Available);
        assert (this.openCallbackList.isEmpty());
        assert (!this.gs2SessionTaskList.isEmpty());
        this.m_State = State.CancellingTasks;
        this.exitStateLock();
    }

    private void changeStateToClosing() {
        assert (this.m_State == State.Opening || this.m_State == State.CancellingOpen || this.m_State == State.Available || this.m_State == State.CancellingTasks);
        assert (this.gs2SessionTaskList.isEmpty());
        this.m_ProjectToken = null;
        this.m_State = State.Closing;
        boolean isCloseInstant = this.closeImpl();
        if (!isCloseInstant) {
            this.exitStateLock();
        }
    }

    private void keepCurrentState() {
        this.exitStateLock();
    }

    public void execute(Gs2SessionTask gs2SessionTask) {
        this.enterStateLock();
        if (this.m_State == State.Available) {
            gs2SessionTask.gs2SessionTaskId = this.m_Gs2SessionIdTaskGenerator.issue();
            gs2SessionTask.prepareImpl();
            this.gs2SessionTaskList.add(gs2SessionTask);
            this.keepCurrentState();
            gs2SessionTask.executeImpl();
        } else {
            this.keepCurrentState();
            gs2SessionTask.callback(new Gs2ClientErrorResponse(new SessionNotOpenException("")));
        }
    }

    void notifyComplete(Gs2SessionTask gs2SessionTask) {
        this.enterStateLock();
        this.gs2SessionTaskList.remove(gs2SessionTask);
        if (this.m_State == State.CancellingTasks && this.gs2SessionTaskList.isEmpty()) {
            this.changeStateToClosing();
        } else {
            this.keepCurrentState();
        }
    }

    protected String getProjectToken() {
        return this.m_ProjectToken;
    }

    public void openCallback(String pProjectToken, Gs2Exception exception) {
        this.enterStateLock();
        if (exception == null) {
            if (pProjectToken != null) {
                ArrayList<AsyncAction<AsyncResult<OpenResult>>> openCallbackList = new ArrayList<AsyncAction<AsyncResult<OpenResult>>>(this.openCallbackList);
                this.openCallbackList.clear();
                if (this.closeCallbackList.isEmpty()) {
                    this.changeStateToAvailable(pProjectToken);
                } else {
                    this.changeStateToClosing();
                }
                Gs2Session.triggerOpenCallback(openCallbackList, null);
            } else {
                ArrayList<AsyncAction<AsyncResult<OpenResult>>> openCallbackList = new ArrayList<AsyncAction<AsyncResult<OpenResult>>>(this.openCallbackList);
                this.openCallbackList.clear();
                ArrayList<AsyncAction<AsyncResult<CloseResult>>> closeCallbackList = new ArrayList<AsyncAction<AsyncResult<CloseResult>>>(this.closeCallbackList);
                this.closeCallbackList.clear();
                this.changeStateToIdle();
                Gs2Session.triggerOpenCallback(openCallbackList, new UnknownException(""));
                Gs2Session.triggerCloseCallback(closeCallbackList, new UnknownException(""));
            }
        } else {
            ArrayList<AsyncAction<AsyncResult<OpenResult>>> openCallbackList = new ArrayList<AsyncAction<AsyncResult<OpenResult>>>(this.openCallbackList);
            this.openCallbackList.clear();
            ArrayList<AsyncAction<AsyncResult<CloseResult>>> closeCallbackList = new ArrayList<AsyncAction<AsyncResult<CloseResult>>>(this.closeCallbackList);
            this.closeCallbackList.clear();
            this.changeStateToIdle();
            Gs2Session.triggerOpenCallback(openCallbackList, exception);
            Gs2Session.triggerCloseCallback(closeCallbackList, exception);
        }
    }

    public void closeCallback(Gs2Exception gs2Exception, boolean isCloseInstant) {
        if (!isCloseInstant) {
            this.enterStateLock();
        }
        AsyncAction<AsyncResult<CloseResult>> onClose = this.m_OnClose;
        ArrayList<Gs2SessionTask> gs2SessionTaskList = new ArrayList<Gs2SessionTask>(this.gs2SessionTaskList);
        this.gs2SessionTaskList.clear();
        ArrayList<AsyncAction<AsyncResult<CloseResult>>> closeCallbackList = new ArrayList<AsyncAction<AsyncResult<CloseResult>>>(this.closeCallbackList);
        this.closeCallbackList.clear();
        if (this.openCallbackList.isEmpty()) {
            this.changeStateToIdle();
        } else {
            this.changeStateToOpening();
        }
        Gs2Session.triggerCancelTasksCallback(gs2SessionTaskList, gs2Exception);
        if (onClose != null) {
            onClose.callback(null);
        }
        Gs2Session.triggerCloseCallback(closeCallbackList, null);
    }

    protected void cancelTasksCallback(Gs2Exception gs2Exception) {
        this.enterStateLock();
        ArrayList<Gs2SessionTask> gs2SessionTaskList = new ArrayList<Gs2SessionTask>(this.gs2SessionTaskList);
        this.gs2SessionTaskList.clear();
        this.keepCurrentState();
        Gs2Session.triggerCancelTasksCallback(gs2SessionTaskList, gs2Exception);
    }

    protected Gs2SessionTask findGs2SessionTask(Gs2SessionTaskId gs2SessionTaskId) {
        this.m_Mutex.lock();
        for (Gs2SessionTask sessionTask : this.gs2SessionTaskList) {
            if (sessionTask.gs2SessionTaskId != gs2SessionTaskId) continue;
            return sessionTask;
        }
        return null;
    }

    public Gs2Session(BasicGs2Credential gs2Credential) {
        this.m_State = State.Idle;
        this.m_Gs2Credential = gs2Credential;
        this.m_Region = Region.AP_NORTHEAST_1;
    }

    public Gs2Session(BasicGs2Credential gs2Credential, Region region) {
        this.m_State = State.Idle;
        this.m_Gs2Credential = gs2Credential;
        this.m_Region = region;
    }

    public Gs2Session(BasicGs2Credential gs2Credential, String region) {
        this.m_State = State.Idle;
        this.m_Gs2Credential = gs2Credential;
        this.m_Region = Region.prettyValueOf(region);
    }

    public BasicGs2Credential getGs2Credential() {
        return this.m_Gs2Credential;
    }

    public Region getRegion() {
        return this.m_Region;
    }

    public void openAsync(AsyncAction<AsyncResult<OpenResult>> callback) {
        this.enterStateLock();
        switch (this.m_State) {
            case Idle: {
                this.openCallbackList.add(callback);
                this.changeStateToOpening();
                break;
            }
            case Opening: 
            case CancellingOpen: 
            case CancellingTasks: 
            case Closing: {
                this.openCallbackList.add(callback);
                this.keepCurrentState();
                break;
            }
            case Available: {
                this.keepCurrentState();
                callback.callback(null);
            }
        }
    }

    public void open() {
        AtomicReference asyncResult = new AtomicReference();
        this.openAsync(r -> asyncResult.set(r));
        while (asyncResult.get() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void closeAsync(AsyncAction<AsyncResult<CloseResult>> callback) {
        this.enterStateLock();
        if (this.m_State == State.Idle) {
            this.keepCurrentState();
            callback.callback(null);
        } else {
            this.closeCallbackList.add(callback);
            switch (this.m_State) {
                case Opening: {
                    this.changeStateToCancellingOpen();
                    break;
                }
                case Available: {
                    if (this.gs2SessionTaskList.isEmpty()) {
                        this.changeStateToClosing();
                        break;
                    }
                    this.changeStateToCancellingTasks();
                    break;
                }
                case Idle: 
                case CancellingOpen: 
                case CancellingTasks: 
                case Closing: {
                    this.keepCurrentState();
                }
            }
        }
    }

    public void close() {
        this.closeAsync(r -> {});
    }

    public void setOnClose(AsyncAction<AsyncResult<CloseResult>> callback) {
        this.m_Mutex.lock();
        this.m_OnClose = callback;
    }

    abstract void openImpl();

    abstract void cancelOpenImpl();

    abstract boolean closeImpl();

    private static enum State {
        Idle,
        Opening,
        CancellingOpen,
        Available,
        CancellingTasks,
        Closing;

    }
}

