/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.version.model.Version;
import java.io.Serializable;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ScheduleVersion
implements IModel,
Serializable {
    private Version currentVersion;
    private Version warningVersion;
    private Version errorVersion;
    private String scheduleEventId;

    public Version getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(Version currentVersion) {
        this.currentVersion = currentVersion;
    }

    public ScheduleVersion withCurrentVersion(Version currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    public Version getWarningVersion() {
        return this.warningVersion;
    }

    public void setWarningVersion(Version warningVersion) {
        this.warningVersion = warningVersion;
    }

    public ScheduleVersion withWarningVersion(Version warningVersion) {
        this.warningVersion = warningVersion;
        return this;
    }

    public Version getErrorVersion() {
        return this.errorVersion;
    }

    public void setErrorVersion(Version errorVersion) {
        this.errorVersion = errorVersion;
    }

    public ScheduleVersion withErrorVersion(Version errorVersion) {
        this.errorVersion = errorVersion;
        return this;
    }

    public String getScheduleEventId() {
        return this.scheduleEventId;
    }

    public void setScheduleEventId(String scheduleEventId) {
        this.scheduleEventId = scheduleEventId;
    }

    public ScheduleVersion withScheduleEventId(String scheduleEventId) {
        this.scheduleEventId = scheduleEventId;
        return this;
    }

    public static ScheduleVersion fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new ScheduleVersion().withCurrentVersion(data.get("currentVersion") == null || data.get("currentVersion").isNull() ? null : Version.fromJson(data.get("currentVersion"))).withWarningVersion(data.get("warningVersion") == null || data.get("warningVersion").isNull() ? null : Version.fromJson(data.get("warningVersion"))).withErrorVersion(data.get("errorVersion") == null || data.get("errorVersion").isNull() ? null : Version.fromJson(data.get("errorVersion"))).withScheduleEventId(data.get("scheduleEventId") == null || data.get("scheduleEventId").isNull() ? null : data.get("scheduleEventId").asText());
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("currentVersion", ScheduleVersion.this.getCurrentVersion() != null ? ScheduleVersion.this.getCurrentVersion().toJson() : null);
                this.put("warningVersion", ScheduleVersion.this.getWarningVersion() != null ? ScheduleVersion.this.getWarningVersion().toJson() : null);
                this.put("errorVersion", ScheduleVersion.this.getErrorVersion() != null ? ScheduleVersion.this.getErrorVersion().toJson() : null);
                this.put("scheduleEventId", ScheduleVersion.this.getScheduleEventId());
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currentVersion == null ? 0 : this.currentVersion.hashCode());
        result = 31 * result + (this.warningVersion == null ? 0 : this.warningVersion.hashCode());
        result = 31 * result + (this.errorVersion == null ? 0 : this.errorVersion.hashCode());
        result = 31 * result + (this.scheduleEventId == null ? 0 : this.scheduleEventId.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleVersion other = (ScheduleVersion)o;
        if (this.currentVersion == null) {
            return other.currentVersion == null;
        }
        if (!this.currentVersion.equals(other.currentVersion)) {
            return false;
        }
        if (this.warningVersion == null) {
            return other.warningVersion == null;
        }
        if (!this.warningVersion.equals(other.warningVersion)) {
            return false;
        }
        if (this.errorVersion == null) {
            return other.errorVersion == null;
        }
        if (!this.errorVersion.equals(other.errorVersion)) {
            return false;
        }
        if (this.scheduleEventId == null) {
            return other.scheduleEventId == null;
        }
        return this.scheduleEventId.equals(other.scheduleEventId);
    }
}

