/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.showcase.request.BuyByUserIdRequest;
import io.gs2.showcase.request.BuyRequest;
import io.gs2.showcase.request.CreateNamespaceRequest;
import io.gs2.showcase.request.CreateRandomShowcaseMasterRequest;
import io.gs2.showcase.request.CreateSalesItemGroupMasterRequest;
import io.gs2.showcase.request.CreateSalesItemMasterRequest;
import io.gs2.showcase.request.CreateShowcaseMasterRequest;
import io.gs2.showcase.request.DecrementPurchaseCountByStampSheetRequest;
import io.gs2.showcase.request.DecrementPurchaseCountByUserIdRequest;
import io.gs2.showcase.request.DeleteNamespaceRequest;
import io.gs2.showcase.request.DeleteRandomShowcaseMasterRequest;
import io.gs2.showcase.request.DeleteSalesItemGroupMasterRequest;
import io.gs2.showcase.request.DeleteSalesItemMasterRequest;
import io.gs2.showcase.request.DeleteShowcaseMasterRequest;
import io.gs2.showcase.request.DescribeNamespacesRequest;
import io.gs2.showcase.request.DescribeRandomDisplayItemsByUserIdRequest;
import io.gs2.showcase.request.DescribeRandomDisplayItemsRequest;
import io.gs2.showcase.request.DescribeRandomShowcaseMastersRequest;
import io.gs2.showcase.request.DescribeSalesItemGroupMastersRequest;
import io.gs2.showcase.request.DescribeSalesItemMastersRequest;
import io.gs2.showcase.request.DescribeShowcaseMastersRequest;
import io.gs2.showcase.request.DescribeShowcasesByUserIdRequest;
import io.gs2.showcase.request.DescribeShowcasesRequest;
import io.gs2.showcase.request.ExportMasterRequest;
import io.gs2.showcase.request.ForceReDrawByUserIdByStampSheetRequest;
import io.gs2.showcase.request.ForceReDrawByUserIdRequest;
import io.gs2.showcase.request.GetCurrentShowcaseMasterRequest;
import io.gs2.showcase.request.GetNamespaceRequest;
import io.gs2.showcase.request.GetNamespaceStatusRequest;
import io.gs2.showcase.request.GetRandomDisplayItemByUserIdRequest;
import io.gs2.showcase.request.GetRandomDisplayItemRequest;
import io.gs2.showcase.request.GetRandomShowcaseMasterRequest;
import io.gs2.showcase.request.GetSalesItemGroupMasterRequest;
import io.gs2.showcase.request.GetSalesItemMasterRequest;
import io.gs2.showcase.request.GetShowcaseByUserIdRequest;
import io.gs2.showcase.request.GetShowcaseMasterRequest;
import io.gs2.showcase.request.GetShowcaseRequest;
import io.gs2.showcase.request.IncrementPurchaseCountByStampTaskRequest;
import io.gs2.showcase.request.IncrementPurchaseCountByUserIdRequest;
import io.gs2.showcase.request.RandomShowcaseBuyByUserIdRequest;
import io.gs2.showcase.request.RandomShowcaseBuyRequest;
import io.gs2.showcase.request.UpdateCurrentShowcaseMasterFromGitHubRequest;
import io.gs2.showcase.request.UpdateCurrentShowcaseMasterRequest;
import io.gs2.showcase.request.UpdateNamespaceRequest;
import io.gs2.showcase.request.UpdateRandomShowcaseMasterRequest;
import io.gs2.showcase.request.UpdateSalesItemGroupMasterRequest;
import io.gs2.showcase.request.UpdateSalesItemMasterRequest;
import io.gs2.showcase.request.UpdateShowcaseMasterRequest;
import io.gs2.showcase.result.BuyByUserIdResult;
import io.gs2.showcase.result.BuyResult;
import io.gs2.showcase.result.CreateNamespaceResult;
import io.gs2.showcase.result.CreateRandomShowcaseMasterResult;
import io.gs2.showcase.result.CreateSalesItemGroupMasterResult;
import io.gs2.showcase.result.CreateSalesItemMasterResult;
import io.gs2.showcase.result.CreateShowcaseMasterResult;
import io.gs2.showcase.result.DecrementPurchaseCountByStampSheetResult;
import io.gs2.showcase.result.DecrementPurchaseCountByUserIdResult;
import io.gs2.showcase.result.DeleteNamespaceResult;
import io.gs2.showcase.result.DeleteRandomShowcaseMasterResult;
import io.gs2.showcase.result.DeleteSalesItemGroupMasterResult;
import io.gs2.showcase.result.DeleteSalesItemMasterResult;
import io.gs2.showcase.result.DeleteShowcaseMasterResult;
import io.gs2.showcase.result.DescribeNamespacesResult;
import io.gs2.showcase.result.DescribeRandomDisplayItemsByUserIdResult;
import io.gs2.showcase.result.DescribeRandomDisplayItemsResult;
import io.gs2.showcase.result.DescribeRandomShowcaseMastersResult;
import io.gs2.showcase.result.DescribeSalesItemGroupMastersResult;
import io.gs2.showcase.result.DescribeSalesItemMastersResult;
import io.gs2.showcase.result.DescribeShowcaseMastersResult;
import io.gs2.showcase.result.DescribeShowcasesByUserIdResult;
import io.gs2.showcase.result.DescribeShowcasesResult;
import io.gs2.showcase.result.ExportMasterResult;
import io.gs2.showcase.result.ForceReDrawByUserIdByStampSheetResult;
import io.gs2.showcase.result.ForceReDrawByUserIdResult;
import io.gs2.showcase.result.GetCurrentShowcaseMasterResult;
import io.gs2.showcase.result.GetNamespaceResult;
import io.gs2.showcase.result.GetNamespaceStatusResult;
import io.gs2.showcase.result.GetRandomDisplayItemByUserIdResult;
import io.gs2.showcase.result.GetRandomDisplayItemResult;
import io.gs2.showcase.result.GetRandomShowcaseMasterResult;
import io.gs2.showcase.result.GetSalesItemGroupMasterResult;
import io.gs2.showcase.result.GetSalesItemMasterResult;
import io.gs2.showcase.result.GetShowcaseByUserIdResult;
import io.gs2.showcase.result.GetShowcaseMasterResult;
import io.gs2.showcase.result.GetShowcaseResult;
import io.gs2.showcase.result.IncrementPurchaseCountByStampTaskResult;
import io.gs2.showcase.result.IncrementPurchaseCountByUserIdResult;
import io.gs2.showcase.result.RandomShowcaseBuyByUserIdResult;
import io.gs2.showcase.result.RandomShowcaseBuyResult;
import io.gs2.showcase.result.UpdateCurrentShowcaseMasterFromGitHubResult;
import io.gs2.showcase.result.UpdateCurrentShowcaseMasterResult;
import io.gs2.showcase.result.UpdateNamespaceResult;
import io.gs2.showcase.result.UpdateRandomShowcaseMasterResult;
import io.gs2.showcase.result.UpdateSalesItemGroupMasterResult;
import io.gs2.showcase.result.UpdateSalesItemMasterResult;
import io.gs2.showcase.result.UpdateShowcaseMasterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2ShowcaseRestClient
extends AbstractGs2Client<Gs2ShowcaseRestClient> {
    public Gs2ShowcaseRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeSalesItemMastersAsync(DescribeSalesItemMastersRequest request, AsyncAction<AsyncResult<DescribeSalesItemMastersResult>> callback) {
        DescribeSalesItemMastersTask task = new DescribeSalesItemMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSalesItemMastersResult describeSalesItemMasters(DescribeSalesItemMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSalesItemMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSalesItemMastersResult)resultAsyncResult[0].getResult();
    }

    public void createSalesItemMasterAsync(CreateSalesItemMasterRequest request, AsyncAction<AsyncResult<CreateSalesItemMasterResult>> callback) {
        CreateSalesItemMasterTask task = new CreateSalesItemMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateSalesItemMasterResult createSalesItemMaster(CreateSalesItemMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createSalesItemMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateSalesItemMasterResult)resultAsyncResult[0].getResult();
    }

    public void getSalesItemMasterAsync(GetSalesItemMasterRequest request, AsyncAction<AsyncResult<GetSalesItemMasterResult>> callback) {
        GetSalesItemMasterTask task = new GetSalesItemMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetSalesItemMasterResult getSalesItemMaster(GetSalesItemMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSalesItemMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSalesItemMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateSalesItemMasterAsync(UpdateSalesItemMasterRequest request, AsyncAction<AsyncResult<UpdateSalesItemMasterResult>> callback) {
        UpdateSalesItemMasterTask task = new UpdateSalesItemMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateSalesItemMasterResult updateSalesItemMaster(UpdateSalesItemMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateSalesItemMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateSalesItemMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteSalesItemMasterAsync(DeleteSalesItemMasterRequest request, AsyncAction<AsyncResult<DeleteSalesItemMasterResult>> callback) {
        DeleteSalesItemMasterTask task = new DeleteSalesItemMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteSalesItemMasterResult deleteSalesItemMaster(DeleteSalesItemMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteSalesItemMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteSalesItemMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeSalesItemGroupMastersAsync(DescribeSalesItemGroupMastersRequest request, AsyncAction<AsyncResult<DescribeSalesItemGroupMastersResult>> callback) {
        DescribeSalesItemGroupMastersTask task = new DescribeSalesItemGroupMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeSalesItemGroupMastersResult describeSalesItemGroupMasters(DescribeSalesItemGroupMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSalesItemGroupMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSalesItemGroupMastersResult)resultAsyncResult[0].getResult();
    }

    public void createSalesItemGroupMasterAsync(CreateSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<CreateSalesItemGroupMasterResult>> callback) {
        CreateSalesItemGroupMasterTask task = new CreateSalesItemGroupMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateSalesItemGroupMasterResult createSalesItemGroupMaster(CreateSalesItemGroupMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createSalesItemGroupMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateSalesItemGroupMasterResult)resultAsyncResult[0].getResult();
    }

    public void getSalesItemGroupMasterAsync(GetSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<GetSalesItemGroupMasterResult>> callback) {
        GetSalesItemGroupMasterTask task = new GetSalesItemGroupMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetSalesItemGroupMasterResult getSalesItemGroupMaster(GetSalesItemGroupMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSalesItemGroupMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSalesItemGroupMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateSalesItemGroupMasterAsync(UpdateSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<UpdateSalesItemGroupMasterResult>> callback) {
        UpdateSalesItemGroupMasterTask task = new UpdateSalesItemGroupMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateSalesItemGroupMasterResult updateSalesItemGroupMaster(UpdateSalesItemGroupMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateSalesItemGroupMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateSalesItemGroupMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteSalesItemGroupMasterAsync(DeleteSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<DeleteSalesItemGroupMasterResult>> callback) {
        DeleteSalesItemGroupMasterTask task = new DeleteSalesItemGroupMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteSalesItemGroupMasterResult deleteSalesItemGroupMaster(DeleteSalesItemGroupMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteSalesItemGroupMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteSalesItemGroupMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeShowcaseMastersAsync(DescribeShowcaseMastersRequest request, AsyncAction<AsyncResult<DescribeShowcaseMastersResult>> callback) {
        DescribeShowcaseMastersTask task = new DescribeShowcaseMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeShowcaseMastersResult describeShowcaseMasters(DescribeShowcaseMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeShowcaseMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeShowcaseMastersResult)resultAsyncResult[0].getResult();
    }

    public void createShowcaseMasterAsync(CreateShowcaseMasterRequest request, AsyncAction<AsyncResult<CreateShowcaseMasterResult>> callback) {
        CreateShowcaseMasterTask task = new CreateShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateShowcaseMasterResult createShowcaseMaster(CreateShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void getShowcaseMasterAsync(GetShowcaseMasterRequest request, AsyncAction<AsyncResult<GetShowcaseMasterResult>> callback) {
        GetShowcaseMasterTask task = new GetShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetShowcaseMasterResult getShowcaseMaster(GetShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateShowcaseMasterAsync(UpdateShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateShowcaseMasterResult>> callback) {
        UpdateShowcaseMasterTask task = new UpdateShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateShowcaseMasterResult updateShowcaseMaster(UpdateShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteShowcaseMasterAsync(DeleteShowcaseMasterRequest request, AsyncAction<AsyncResult<DeleteShowcaseMasterResult>> callback) {
        DeleteShowcaseMasterTask task = new DeleteShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteShowcaseMasterResult deleteShowcaseMaster(DeleteShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentShowcaseMasterAsync(GetCurrentShowcaseMasterRequest request, AsyncAction<AsyncResult<GetCurrentShowcaseMasterResult>> callback) {
        GetCurrentShowcaseMasterTask task = new GetCurrentShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentShowcaseMasterResult getCurrentShowcaseMaster(GetCurrentShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentShowcaseMasterAsync(UpdateCurrentShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentShowcaseMasterResult>> callback) {
        UpdateCurrentShowcaseMasterTask task = new UpdateCurrentShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentShowcaseMasterResult updateCurrentShowcaseMaster(UpdateCurrentShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentShowcaseMasterFromGitHubAsync(UpdateCurrentShowcaseMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentShowcaseMasterFromGitHubResult>> callback) {
        UpdateCurrentShowcaseMasterFromGitHubTask task = new UpdateCurrentShowcaseMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentShowcaseMasterFromGitHubResult updateCurrentShowcaseMasterFromGitHub(UpdateCurrentShowcaseMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentShowcaseMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentShowcaseMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void describeShowcasesAsync(DescribeShowcasesRequest request, AsyncAction<AsyncResult<DescribeShowcasesResult>> callback) {
        DescribeShowcasesTask task = new DescribeShowcasesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeShowcasesResult describeShowcases(DescribeShowcasesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeShowcasesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeShowcasesResult)resultAsyncResult[0].getResult();
    }

    public void describeShowcasesByUserIdAsync(DescribeShowcasesByUserIdRequest request, AsyncAction<AsyncResult<DescribeShowcasesByUserIdResult>> callback) {
        DescribeShowcasesByUserIdTask task = new DescribeShowcasesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeShowcasesByUserIdResult describeShowcasesByUserId(DescribeShowcasesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeShowcasesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeShowcasesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getShowcaseAsync(GetShowcaseRequest request, AsyncAction<AsyncResult<GetShowcaseResult>> callback) {
        GetShowcaseTask task = new GetShowcaseTask(request, callback);
        this.session.execute(task);
    }

    public GetShowcaseResult getShowcase(GetShowcaseRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getShowcaseAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetShowcaseResult)resultAsyncResult[0].getResult();
    }

    public void getShowcaseByUserIdAsync(GetShowcaseByUserIdRequest request, AsyncAction<AsyncResult<GetShowcaseByUserIdResult>> callback) {
        GetShowcaseByUserIdTask task = new GetShowcaseByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetShowcaseByUserIdResult getShowcaseByUserId(GetShowcaseByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getShowcaseByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetShowcaseByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void buyAsync(BuyRequest request, AsyncAction<AsyncResult<BuyResult>> callback) {
        BuyTask task = new BuyTask(request, callback);
        this.session.execute(task);
    }

    public BuyResult buy(BuyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.buyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (BuyResult)resultAsyncResult[0].getResult();
    }

    public void buyByUserIdAsync(BuyByUserIdRequest request, AsyncAction<AsyncResult<BuyByUserIdResult>> callback) {
        BuyByUserIdTask task = new BuyByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public BuyByUserIdResult buyByUserId(BuyByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.buyByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (BuyByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeRandomShowcaseMastersAsync(DescribeRandomShowcaseMastersRequest request, AsyncAction<AsyncResult<DescribeRandomShowcaseMastersResult>> callback) {
        DescribeRandomShowcaseMastersTask task = new DescribeRandomShowcaseMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRandomShowcaseMastersResult describeRandomShowcaseMasters(DescribeRandomShowcaseMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRandomShowcaseMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRandomShowcaseMastersResult)resultAsyncResult[0].getResult();
    }

    public void createRandomShowcaseMasterAsync(CreateRandomShowcaseMasterRequest request, AsyncAction<AsyncResult<CreateRandomShowcaseMasterResult>> callback) {
        CreateRandomShowcaseMasterTask task = new CreateRandomShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateRandomShowcaseMasterResult createRandomShowcaseMaster(CreateRandomShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createRandomShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateRandomShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void getRandomShowcaseMasterAsync(GetRandomShowcaseMasterRequest request, AsyncAction<AsyncResult<GetRandomShowcaseMasterResult>> callback) {
        GetRandomShowcaseMasterTask task = new GetRandomShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetRandomShowcaseMasterResult getRandomShowcaseMaster(GetRandomShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRandomShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRandomShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateRandomShowcaseMasterAsync(UpdateRandomShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateRandomShowcaseMasterResult>> callback) {
        UpdateRandomShowcaseMasterTask task = new UpdateRandomShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateRandomShowcaseMasterResult updateRandomShowcaseMaster(UpdateRandomShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateRandomShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateRandomShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteRandomShowcaseMasterAsync(DeleteRandomShowcaseMasterRequest request, AsyncAction<AsyncResult<DeleteRandomShowcaseMasterResult>> callback) {
        DeleteRandomShowcaseMasterTask task = new DeleteRandomShowcaseMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteRandomShowcaseMasterResult deleteRandomShowcaseMaster(DeleteRandomShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteRandomShowcaseMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteRandomShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void incrementPurchaseCountByUserIdAsync(IncrementPurchaseCountByUserIdRequest request, AsyncAction<AsyncResult<IncrementPurchaseCountByUserIdResult>> callback) {
        IncrementPurchaseCountByUserIdTask task = new IncrementPurchaseCountByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public IncrementPurchaseCountByUserIdResult incrementPurchaseCountByUserId(IncrementPurchaseCountByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.incrementPurchaseCountByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (IncrementPurchaseCountByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void decrementPurchaseCountByUserIdAsync(DecrementPurchaseCountByUserIdRequest request, AsyncAction<AsyncResult<DecrementPurchaseCountByUserIdResult>> callback) {
        DecrementPurchaseCountByUserIdTask task = new DecrementPurchaseCountByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DecrementPurchaseCountByUserIdResult decrementPurchaseCountByUserId(DecrementPurchaseCountByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.decrementPurchaseCountByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DecrementPurchaseCountByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void incrementPurchaseCountByStampTaskAsync(IncrementPurchaseCountByStampTaskRequest request, AsyncAction<AsyncResult<IncrementPurchaseCountByStampTaskResult>> callback) {
        IncrementPurchaseCountByStampTaskTask task = new IncrementPurchaseCountByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public IncrementPurchaseCountByStampTaskResult incrementPurchaseCountByStampTask(IncrementPurchaseCountByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.incrementPurchaseCountByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (IncrementPurchaseCountByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void decrementPurchaseCountByStampSheetAsync(DecrementPurchaseCountByStampSheetRequest request, AsyncAction<AsyncResult<DecrementPurchaseCountByStampSheetResult>> callback) {
        DecrementPurchaseCountByStampSheetTask task = new DecrementPurchaseCountByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public DecrementPurchaseCountByStampSheetResult decrementPurchaseCountByStampSheet(DecrementPurchaseCountByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.decrementPurchaseCountByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DecrementPurchaseCountByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void forceReDrawByUserIdAsync(ForceReDrawByUserIdRequest request, AsyncAction<AsyncResult<ForceReDrawByUserIdResult>> callback) {
        ForceReDrawByUserIdTask task = new ForceReDrawByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ForceReDrawByUserIdResult forceReDrawByUserId(ForceReDrawByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.forceReDrawByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ForceReDrawByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void forceReDrawByUserIdByStampSheetAsync(ForceReDrawByUserIdByStampSheetRequest request, AsyncAction<AsyncResult<ForceReDrawByUserIdByStampSheetResult>> callback) {
        ForceReDrawByUserIdByStampSheetTask task = new ForceReDrawByUserIdByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public ForceReDrawByUserIdByStampSheetResult forceReDrawByUserIdByStampSheet(ForceReDrawByUserIdByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.forceReDrawByUserIdByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ForceReDrawByUserIdByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void describeRandomDisplayItemsAsync(DescribeRandomDisplayItemsRequest request, AsyncAction<AsyncResult<DescribeRandomDisplayItemsResult>> callback) {
        DescribeRandomDisplayItemsTask task = new DescribeRandomDisplayItemsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRandomDisplayItemsResult describeRandomDisplayItems(DescribeRandomDisplayItemsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRandomDisplayItemsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRandomDisplayItemsResult)resultAsyncResult[0].getResult();
    }

    public void describeRandomDisplayItemsByUserIdAsync(DescribeRandomDisplayItemsByUserIdRequest request, AsyncAction<AsyncResult<DescribeRandomDisplayItemsByUserIdResult>> callback) {
        DescribeRandomDisplayItemsByUserIdTask task = new DescribeRandomDisplayItemsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeRandomDisplayItemsByUserIdResult describeRandomDisplayItemsByUserId(DescribeRandomDisplayItemsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeRandomDisplayItemsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeRandomDisplayItemsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getRandomDisplayItemAsync(GetRandomDisplayItemRequest request, AsyncAction<AsyncResult<GetRandomDisplayItemResult>> callback) {
        GetRandomDisplayItemTask task = new GetRandomDisplayItemTask(request, callback);
        this.session.execute(task);
    }

    public GetRandomDisplayItemResult getRandomDisplayItem(GetRandomDisplayItemRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRandomDisplayItemAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRandomDisplayItemResult)resultAsyncResult[0].getResult();
    }

    public void getRandomDisplayItemByUserIdAsync(GetRandomDisplayItemByUserIdRequest request, AsyncAction<AsyncResult<GetRandomDisplayItemByUserIdResult>> callback) {
        GetRandomDisplayItemByUserIdTask task = new GetRandomDisplayItemByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetRandomDisplayItemByUserIdResult getRandomDisplayItemByUserId(GetRandomDisplayItemByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getRandomDisplayItemByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetRandomDisplayItemByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void randomShowcaseBuyAsync(RandomShowcaseBuyRequest request, AsyncAction<AsyncResult<RandomShowcaseBuyResult>> callback) {
        RandomShowcaseBuyTask task = new RandomShowcaseBuyTask(request, callback);
        this.session.execute(task);
    }

    public RandomShowcaseBuyResult randomShowcaseBuy(RandomShowcaseBuyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.randomShowcaseBuyAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RandomShowcaseBuyResult)resultAsyncResult[0].getResult();
    }

    public void randomShowcaseBuyByUserIdAsync(RandomShowcaseBuyByUserIdRequest request, AsyncAction<AsyncResult<RandomShowcaseBuyByUserIdResult>> callback) {
        RandomShowcaseBuyByUserIdTask task = new RandomShowcaseBuyByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public RandomShowcaseBuyByUserIdResult randomShowcaseBuyByUserId(RandomShowcaseBuyByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.randomShowcaseBuyByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RandomShowcaseBuyByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", CreateNamespaceTask.this.request.getTransactionSetting() != null ? CreateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("buyScript", CreateNamespaceTask.this.request.getBuyScript() != null ? CreateNamespaceTask.this.request.getBuyScript().toJson() : null);
                    this.put("queueNamespaceId", CreateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", CreateNamespaceTask.this.request.getKeyId());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", UpdateNamespaceTask.this.request.getTransactionSetting() != null ? UpdateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("buyScript", UpdateNamespaceTask.this.request.getBuyScript() != null ? UpdateNamespaceTask.this.request.getBuyScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("queueNamespaceId", UpdateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", UpdateNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSalesItemMastersTask
    extends Gs2RestSessionTask<DescribeSalesItemMastersResult> {
        private DescribeSalesItemMastersRequest request;

        public DescribeSalesItemMastersTask(DescribeSalesItemMastersRequest request, AsyncAction<AsyncResult<DescribeSalesItemMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSalesItemMastersResult parse(JsonNode data) {
            return DescribeSalesItemMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateSalesItemMasterTask
    extends Gs2RestSessionTask<CreateSalesItemMasterResult> {
        private CreateSalesItemMasterRequest request;

        public CreateSalesItemMasterTask(CreateSalesItemMasterRequest request, AsyncAction<AsyncResult<CreateSalesItemMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateSalesItemMasterResult parse(JsonNode data) {
            return CreateSalesItemMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateSalesItemMasterTask.this.request.getName());
                    this.put("description", CreateSalesItemMasterTask.this.request.getDescription());
                    this.put("metadata", CreateSalesItemMasterTask.this.request.getMetadata());
                    this.put("consumeActions", CreateSalesItemMasterTask.this.request.getConsumeActions() == null ? new ArrayList() : CreateSalesItemMasterTask.this.request.getConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("acquireActions", CreateSalesItemMasterTask.this.request.getAcquireActions() == null ? new ArrayList() : CreateSalesItemMasterTask.this.request.getAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CreateSalesItemMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetSalesItemMasterTask
    extends Gs2RestSessionTask<GetSalesItemMasterResult> {
        private GetSalesItemMasterRequest request;

        public GetSalesItemMasterTask(GetSalesItemMasterRequest request, AsyncAction<AsyncResult<GetSalesItemMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSalesItemMasterResult parse(JsonNode data) {
            return GetSalesItemMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem/{salesItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemName}", this.request.getSalesItemName() == null || this.request.getSalesItemName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateSalesItemMasterTask
    extends Gs2RestSessionTask<UpdateSalesItemMasterResult> {
        private UpdateSalesItemMasterRequest request;

        public UpdateSalesItemMasterTask(UpdateSalesItemMasterRequest request, AsyncAction<AsyncResult<UpdateSalesItemMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateSalesItemMasterResult parse(JsonNode data) {
            return UpdateSalesItemMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem/{salesItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemName}", this.request.getSalesItemName() == null || this.request.getSalesItemName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateSalesItemMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateSalesItemMasterTask.this.request.getMetadata());
                    this.put("consumeActions", UpdateSalesItemMasterTask.this.request.getConsumeActions() == null ? new ArrayList() : UpdateSalesItemMasterTask.this.request.getConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("acquireActions", UpdateSalesItemMasterTask.this.request.getAcquireActions() == null ? new ArrayList() : UpdateSalesItemMasterTask.this.request.getAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateSalesItemMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteSalesItemMasterTask
    extends Gs2RestSessionTask<DeleteSalesItemMasterResult> {
        private DeleteSalesItemMasterRequest request;

        public DeleteSalesItemMasterTask(DeleteSalesItemMasterRequest request, AsyncAction<AsyncResult<DeleteSalesItemMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteSalesItemMasterResult parse(JsonNode data) {
            return DeleteSalesItemMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem/{salesItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemName}", this.request.getSalesItemName() == null || this.request.getSalesItemName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSalesItemGroupMastersTask
    extends Gs2RestSessionTask<DescribeSalesItemGroupMastersResult> {
        private DescribeSalesItemGroupMastersRequest request;

        public DescribeSalesItemGroupMastersTask(DescribeSalesItemGroupMastersRequest request, AsyncAction<AsyncResult<DescribeSalesItemGroupMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeSalesItemGroupMastersResult parse(JsonNode data) {
            return DescribeSalesItemGroupMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateSalesItemGroupMasterTask
    extends Gs2RestSessionTask<CreateSalesItemGroupMasterResult> {
        private CreateSalesItemGroupMasterRequest request;

        public CreateSalesItemGroupMasterTask(CreateSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<CreateSalesItemGroupMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateSalesItemGroupMasterResult parse(JsonNode data) {
            return CreateSalesItemGroupMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateSalesItemGroupMasterTask.this.request.getName());
                    this.put("description", CreateSalesItemGroupMasterTask.this.request.getDescription());
                    this.put("metadata", CreateSalesItemGroupMasterTask.this.request.getMetadata());
                    this.put("salesItemNames", CreateSalesItemGroupMasterTask.this.request.getSalesItemNames() == null ? new ArrayList() : CreateSalesItemGroupMasterTask.this.request.getSalesItemNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", CreateSalesItemGroupMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetSalesItemGroupMasterTask
    extends Gs2RestSessionTask<GetSalesItemGroupMasterResult> {
        private GetSalesItemGroupMasterRequest request;

        public GetSalesItemGroupMasterTask(GetSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<GetSalesItemGroupMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetSalesItemGroupMasterResult parse(JsonNode data) {
            return GetSalesItemGroupMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{salesItemGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemGroupName}", this.request.getSalesItemGroupName() == null || this.request.getSalesItemGroupName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateSalesItemGroupMasterTask
    extends Gs2RestSessionTask<UpdateSalesItemGroupMasterResult> {
        private UpdateSalesItemGroupMasterRequest request;

        public UpdateSalesItemGroupMasterTask(UpdateSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<UpdateSalesItemGroupMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateSalesItemGroupMasterResult parse(JsonNode data) {
            return UpdateSalesItemGroupMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{salesItemGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemGroupName}", this.request.getSalesItemGroupName() == null || this.request.getSalesItemGroupName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemGroupName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateSalesItemGroupMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateSalesItemGroupMasterTask.this.request.getMetadata());
                    this.put("salesItemNames", UpdateSalesItemGroupMasterTask.this.request.getSalesItemNames() == null ? new ArrayList() : UpdateSalesItemGroupMasterTask.this.request.getSalesItemNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", UpdateSalesItemGroupMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteSalesItemGroupMasterTask
    extends Gs2RestSessionTask<DeleteSalesItemGroupMasterResult> {
        private DeleteSalesItemGroupMasterRequest request;

        public DeleteSalesItemGroupMasterTask(DeleteSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<DeleteSalesItemGroupMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteSalesItemGroupMasterResult parse(JsonNode data) {
            return DeleteSalesItemGroupMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{salesItemGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemGroupName}", this.request.getSalesItemGroupName() == null || this.request.getSalesItemGroupName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeShowcaseMastersTask
    extends Gs2RestSessionTask<DescribeShowcaseMastersResult> {
        private DescribeShowcaseMastersRequest request;

        public DescribeShowcaseMastersTask(DescribeShowcaseMastersRequest request, AsyncAction<AsyncResult<DescribeShowcaseMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeShowcaseMastersResult parse(JsonNode data) {
            return DescribeShowcaseMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateShowcaseMasterTask
    extends Gs2RestSessionTask<CreateShowcaseMasterResult> {
        private CreateShowcaseMasterRequest request;

        public CreateShowcaseMasterTask(CreateShowcaseMasterRequest request, AsyncAction<AsyncResult<CreateShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateShowcaseMasterResult parse(JsonNode data) {
            return CreateShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateShowcaseMasterTask.this.request.getName());
                    this.put("description", CreateShowcaseMasterTask.this.request.getDescription());
                    this.put("metadata", CreateShowcaseMasterTask.this.request.getMetadata());
                    this.put("displayItems", CreateShowcaseMasterTask.this.request.getDisplayItems() == null ? new ArrayList() : CreateShowcaseMasterTask.this.request.getDisplayItems().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("salesPeriodEventId", CreateShowcaseMasterTask.this.request.getSalesPeriodEventId());
                    this.put("contextStack", CreateShowcaseMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetShowcaseMasterTask
    extends Gs2RestSessionTask<GetShowcaseMasterResult> {
        private GetShowcaseMasterRequest request;

        public GetShowcaseMasterTask(GetShowcaseMasterRequest request, AsyncAction<AsyncResult<GetShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetShowcaseMasterResult parse(JsonNode data) {
            return GetShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateShowcaseMasterTask
    extends Gs2RestSessionTask<UpdateShowcaseMasterResult> {
        private UpdateShowcaseMasterRequest request;

        public UpdateShowcaseMasterTask(UpdateShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateShowcaseMasterResult parse(JsonNode data) {
            return UpdateShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateShowcaseMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateShowcaseMasterTask.this.request.getMetadata());
                    this.put("displayItems", UpdateShowcaseMasterTask.this.request.getDisplayItems() == null ? new ArrayList() : UpdateShowcaseMasterTask.this.request.getDisplayItems().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("salesPeriodEventId", UpdateShowcaseMasterTask.this.request.getSalesPeriodEventId());
                    this.put("contextStack", UpdateShowcaseMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteShowcaseMasterTask
    extends Gs2RestSessionTask<DeleteShowcaseMasterResult> {
        private DeleteShowcaseMasterRequest request;

        public DeleteShowcaseMasterTask(DeleteShowcaseMasterRequest request, AsyncAction<AsyncResult<DeleteShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteShowcaseMasterResult parse(JsonNode data) {
            return DeleteShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentShowcaseMasterTask
    extends Gs2RestSessionTask<GetCurrentShowcaseMasterResult> {
        private GetCurrentShowcaseMasterRequest request;

        public GetCurrentShowcaseMasterTask(GetCurrentShowcaseMasterRequest request, AsyncAction<AsyncResult<GetCurrentShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentShowcaseMasterResult parse(JsonNode data) {
            return GetCurrentShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentShowcaseMasterTask
    extends Gs2RestSessionTask<UpdateCurrentShowcaseMasterResult> {
        private UpdateCurrentShowcaseMasterRequest request;

        public UpdateCurrentShowcaseMasterTask(UpdateCurrentShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentShowcaseMasterResult parse(JsonNode data) {
            return UpdateCurrentShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentShowcaseMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentShowcaseMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentShowcaseMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentShowcaseMasterFromGitHubResult> {
        private UpdateCurrentShowcaseMasterFromGitHubRequest request;

        public UpdateCurrentShowcaseMasterFromGitHubTask(UpdateCurrentShowcaseMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentShowcaseMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentShowcaseMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentShowcaseMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentShowcaseMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentShowcaseMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentShowcaseMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeShowcasesTask
    extends Gs2RestSessionTask<DescribeShowcasesResult> {
        private DescribeShowcasesRequest request;

        public DescribeShowcasesTask(DescribeShowcasesRequest request, AsyncAction<AsyncResult<DescribeShowcasesResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeShowcasesResult parse(JsonNode data) {
            return DescribeShowcasesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeShowcasesByUserIdTask
    extends Gs2RestSessionTask<DescribeShowcasesByUserIdResult> {
        private DescribeShowcasesByUserIdRequest request;

        public DescribeShowcasesByUserIdTask(DescribeShowcasesByUserIdRequest request, AsyncAction<AsyncResult<DescribeShowcasesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeShowcasesByUserIdResult parse(JsonNode data) {
            return DescribeShowcasesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetShowcaseTask
    extends Gs2RestSessionTask<GetShowcaseResult> {
        private GetShowcaseRequest request;

        public GetShowcaseTask(GetShowcaseRequest request, AsyncAction<AsyncResult<GetShowcaseResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetShowcaseResult parse(JsonNode data) {
            return GetShowcaseResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetShowcaseByUserIdTask
    extends Gs2RestSessionTask<GetShowcaseByUserIdResult> {
        private GetShowcaseByUserIdRequest request;

        public GetShowcaseByUserIdTask(GetShowcaseByUserIdRequest request, AsyncAction<AsyncResult<GetShowcaseByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetShowcaseByUserIdResult parse(JsonNode data) {
            return GetShowcaseByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class BuyTask
    extends Gs2RestSessionTask<BuyResult> {
        private BuyRequest request;

        public BuyTask(BuyRequest request, AsyncAction<AsyncResult<BuyResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public BuyResult parse(JsonNode data) {
            return BuyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/showcase/{showcaseName}/{displayItemId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemId}", this.request.getDisplayItemId() == null || this.request.getDisplayItemId().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("quantity", BuyTask.this.request.getQuantity());
                    this.put("config", BuyTask.this.request.getConfig() == null ? new ArrayList() : BuyTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", BuyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class BuyByUserIdTask
    extends Gs2RestSessionTask<BuyByUserIdResult> {
        private BuyByUserIdRequest request;

        public BuyByUserIdTask(BuyByUserIdRequest request, AsyncAction<AsyncResult<BuyByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public BuyByUserIdResult parse(JsonNode data) {
            return BuyByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/showcase/{showcaseName}/{displayItemId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemId}", this.request.getDisplayItemId() == null || this.request.getDisplayItemId().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemId()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("quantity", BuyByUserIdTask.this.request.getQuantity());
                    this.put("config", BuyByUserIdTask.this.request.getConfig() == null ? new ArrayList() : BuyByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", BuyByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeRandomShowcaseMastersTask
    extends Gs2RestSessionTask<DescribeRandomShowcaseMastersResult> {
        private DescribeRandomShowcaseMastersRequest request;

        public DescribeRandomShowcaseMastersTask(DescribeRandomShowcaseMastersRequest request, AsyncAction<AsyncResult<DescribeRandomShowcaseMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRandomShowcaseMastersResult parse(JsonNode data) {
            return DescribeRandomShowcaseMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/random/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateRandomShowcaseMasterTask
    extends Gs2RestSessionTask<CreateRandomShowcaseMasterResult> {
        private CreateRandomShowcaseMasterRequest request;

        public CreateRandomShowcaseMasterTask(CreateRandomShowcaseMasterRequest request, AsyncAction<AsyncResult<CreateRandomShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateRandomShowcaseMasterResult parse(JsonNode data) {
            return CreateRandomShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/random/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateRandomShowcaseMasterTask.this.request.getName());
                    this.put("description", CreateRandomShowcaseMasterTask.this.request.getDescription());
                    this.put("metadata", CreateRandomShowcaseMasterTask.this.request.getMetadata());
                    this.put("maximumNumberOfChoice", CreateRandomShowcaseMasterTask.this.request.getMaximumNumberOfChoice());
                    this.put("displayItems", CreateRandomShowcaseMasterTask.this.request.getDisplayItems() == null ? new ArrayList() : CreateRandomShowcaseMasterTask.this.request.getDisplayItems().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("baseTimestamp", CreateRandomShowcaseMasterTask.this.request.getBaseTimestamp());
                    this.put("resetIntervalHours", CreateRandomShowcaseMasterTask.this.request.getResetIntervalHours());
                    this.put("salesPeriodEventId", CreateRandomShowcaseMasterTask.this.request.getSalesPeriodEventId());
                    this.put("contextStack", CreateRandomShowcaseMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRandomShowcaseMasterTask
    extends Gs2RestSessionTask<GetRandomShowcaseMasterResult> {
        private GetRandomShowcaseMasterRequest request;

        public GetRandomShowcaseMasterTask(GetRandomShowcaseMasterRequest request, AsyncAction<AsyncResult<GetRandomShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRandomShowcaseMasterResult parse(JsonNode data) {
            return GetRandomShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/random/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateRandomShowcaseMasterTask
    extends Gs2RestSessionTask<UpdateRandomShowcaseMasterResult> {
        private UpdateRandomShowcaseMasterRequest request;

        public UpdateRandomShowcaseMasterTask(UpdateRandomShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateRandomShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateRandomShowcaseMasterResult parse(JsonNode data) {
            return UpdateRandomShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/random/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateRandomShowcaseMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateRandomShowcaseMasterTask.this.request.getMetadata());
                    this.put("maximumNumberOfChoice", UpdateRandomShowcaseMasterTask.this.request.getMaximumNumberOfChoice());
                    this.put("displayItems", UpdateRandomShowcaseMasterTask.this.request.getDisplayItems() == null ? new ArrayList() : UpdateRandomShowcaseMasterTask.this.request.getDisplayItems().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("baseTimestamp", UpdateRandomShowcaseMasterTask.this.request.getBaseTimestamp());
                    this.put("resetIntervalHours", UpdateRandomShowcaseMasterTask.this.request.getResetIntervalHours());
                    this.put("salesPeriodEventId", UpdateRandomShowcaseMasterTask.this.request.getSalesPeriodEventId());
                    this.put("contextStack", UpdateRandomShowcaseMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteRandomShowcaseMasterTask
    extends Gs2RestSessionTask<DeleteRandomShowcaseMasterResult> {
        private DeleteRandomShowcaseMasterRequest request;

        public DeleteRandomShowcaseMasterTask(DeleteRandomShowcaseMasterRequest request, AsyncAction<AsyncResult<DeleteRandomShowcaseMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteRandomShowcaseMasterResult parse(JsonNode data) {
            return DeleteRandomShowcaseMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/random/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class IncrementPurchaseCountByUserIdTask
    extends Gs2RestSessionTask<IncrementPurchaseCountByUserIdResult> {
        private IncrementPurchaseCountByUserIdRequest request;

        public IncrementPurchaseCountByUserIdTask(IncrementPurchaseCountByUserIdRequest request, AsyncAction<AsyncResult<IncrementPurchaseCountByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public IncrementPurchaseCountByUserIdResult parse(JsonNode data) {
            return IncrementPurchaseCountByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/random/showcase/user/{userId}/status/{showcaseName}/{displayItemName}/purchase/count";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemName}", this.request.getDisplayItemName() == null || this.request.getDisplayItemName().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("count", IncrementPurchaseCountByUserIdTask.this.request.getCount());
                    this.put("contextStack", IncrementPurchaseCountByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DecrementPurchaseCountByUserIdTask
    extends Gs2RestSessionTask<DecrementPurchaseCountByUserIdResult> {
        private DecrementPurchaseCountByUserIdRequest request;

        public DecrementPurchaseCountByUserIdTask(DecrementPurchaseCountByUserIdRequest request, AsyncAction<AsyncResult<DecrementPurchaseCountByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DecrementPurchaseCountByUserIdResult parse(JsonNode data) {
            return DecrementPurchaseCountByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/random/showcase/user/{userId}/status/{showcaseName}/{displayItemName}/purchase/count/decrease";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemName}", this.request.getDisplayItemName() == null || this.request.getDisplayItemName().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("count", DecrementPurchaseCountByUserIdTask.this.request.getCount());
                    this.put("contextStack", DecrementPurchaseCountByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class IncrementPurchaseCountByStampTaskTask
    extends Gs2RestSessionTask<IncrementPurchaseCountByStampTaskResult> {
        private IncrementPurchaseCountByStampTaskRequest request;

        public IncrementPurchaseCountByStampTaskTask(IncrementPurchaseCountByStampTaskRequest request, AsyncAction<AsyncResult<IncrementPurchaseCountByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public IncrementPurchaseCountByStampTaskResult parse(JsonNode data) {
            return IncrementPurchaseCountByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/stamp/random/showcase/status/purchase/count";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", IncrementPurchaseCountByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", IncrementPurchaseCountByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", IncrementPurchaseCountByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DecrementPurchaseCountByStampSheetTask
    extends Gs2RestSessionTask<DecrementPurchaseCountByStampSheetResult> {
        private DecrementPurchaseCountByStampSheetRequest request;

        public DecrementPurchaseCountByStampSheetTask(DecrementPurchaseCountByStampSheetRequest request, AsyncAction<AsyncResult<DecrementPurchaseCountByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DecrementPurchaseCountByStampSheetResult parse(JsonNode data) {
            return DecrementPurchaseCountByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/stamp/random/showcase/status/purchase/count/decrease";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", DecrementPurchaseCountByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", DecrementPurchaseCountByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", DecrementPurchaseCountByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ForceReDrawByUserIdTask
    extends Gs2RestSessionTask<ForceReDrawByUserIdResult> {
        private ForceReDrawByUserIdRequest request;

        public ForceReDrawByUserIdTask(ForceReDrawByUserIdRequest request, AsyncAction<AsyncResult<ForceReDrawByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ForceReDrawByUserIdResult parse(JsonNode data) {
            return ForceReDrawByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/random/showcase/{showcaseName}/user/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ForceReDrawByUserIdByStampSheetTask
    extends Gs2RestSessionTask<ForceReDrawByUserIdByStampSheetResult> {
        private ForceReDrawByUserIdByStampSheetRequest request;

        public ForceReDrawByUserIdByStampSheetTask(ForceReDrawByUserIdByStampSheetRequest request, AsyncAction<AsyncResult<ForceReDrawByUserIdByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ForceReDrawByUserIdByStampSheetResult parse(JsonNode data) {
            return ForceReDrawByUserIdByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/stamp/random/showcase/status/redraw";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", ForceReDrawByUserIdByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", ForceReDrawByUserIdByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", ForceReDrawByUserIdByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeRandomDisplayItemsTask
    extends Gs2RestSessionTask<DescribeRandomDisplayItemsResult> {
        private DescribeRandomDisplayItemsRequest request;

        public DescribeRandomDisplayItemsTask(DescribeRandomDisplayItemsRequest request, AsyncAction<AsyncResult<DescribeRandomDisplayItemsResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRandomDisplayItemsResult parse(JsonNode data) {
            return DescribeRandomDisplayItemsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/random/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeRandomDisplayItemsByUserIdTask
    extends Gs2RestSessionTask<DescribeRandomDisplayItemsByUserIdResult> {
        private DescribeRandomDisplayItemsByUserIdRequest request;

        public DescribeRandomDisplayItemsByUserIdTask(DescribeRandomDisplayItemsByUserIdRequest request, AsyncAction<AsyncResult<DescribeRandomDisplayItemsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeRandomDisplayItemsByUserIdResult parse(JsonNode data) {
            return DescribeRandomDisplayItemsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/random/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetRandomDisplayItemTask
    extends Gs2RestSessionTask<GetRandomDisplayItemResult> {
        private GetRandomDisplayItemRequest request;

        public GetRandomDisplayItemTask(GetRandomDisplayItemRequest request, AsyncAction<AsyncResult<GetRandomDisplayItemResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRandomDisplayItemResult parse(JsonNode data) {
            return GetRandomDisplayItemResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/random/showcase/{showcaseName}/displayItem/{displayItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemName}", this.request.getDisplayItemName() == null || this.request.getDisplayItemName().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetRandomDisplayItemByUserIdTask
    extends Gs2RestSessionTask<GetRandomDisplayItemByUserIdResult> {
        private GetRandomDisplayItemByUserIdRequest request;

        public GetRandomDisplayItemByUserIdTask(GetRandomDisplayItemByUserIdRequest request, AsyncAction<AsyncResult<GetRandomDisplayItemByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetRandomDisplayItemByUserIdResult parse(JsonNode data) {
            return GetRandomDisplayItemByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/random/showcase/{showcaseName}/displayItem/{displayItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemName}", this.request.getDisplayItemName() == null || this.request.getDisplayItemName().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RandomShowcaseBuyTask
    extends Gs2RestSessionTask<RandomShowcaseBuyResult> {
        private RandomShowcaseBuyRequest request;

        public RandomShowcaseBuyTask(RandomShowcaseBuyRequest request, AsyncAction<AsyncResult<RandomShowcaseBuyResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RandomShowcaseBuyResult parse(JsonNode data) {
            return RandomShowcaseBuyResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/random/showcase/{showcaseName}/{displayItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemName}", this.request.getDisplayItemName() == null || this.request.getDisplayItemName().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("quantity", RandomShowcaseBuyTask.this.request.getQuantity());
                    this.put("config", RandomShowcaseBuyTask.this.request.getConfig() == null ? new ArrayList() : RandomShowcaseBuyTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", RandomShowcaseBuyTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class RandomShowcaseBuyByUserIdTask
    extends Gs2RestSessionTask<RandomShowcaseBuyByUserIdResult> {
        private RandomShowcaseBuyByUserIdRequest request;

        public RandomShowcaseBuyByUserIdTask(RandomShowcaseBuyByUserIdRequest request, AsyncAction<AsyncResult<RandomShowcaseBuyByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RandomShowcaseBuyByUserIdResult parse(JsonNode data) {
            return RandomShowcaseBuyByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/random/showcase/{showcaseName}/{displayItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemName}", this.request.getDisplayItemName() == null || this.request.getDisplayItemName().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("quantity", RandomShowcaseBuyByUserIdTask.this.request.getQuantity());
                    this.put("config", RandomShowcaseBuyByUserIdTask.this.request.getConfig() == null ? new ArrayList() : RandomShowcaseBuyByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", RandomShowcaseBuyByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }
}

