/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.loginReward;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.loginReward.request.CreateBonusModelMasterRequest;
import io.gs2.loginReward.request.CreateNamespaceRequest;
import io.gs2.loginReward.request.DeleteBonusModelMasterRequest;
import io.gs2.loginReward.request.DeleteNamespaceRequest;
import io.gs2.loginReward.request.DeleteReceiveStatusByStampSheetRequest;
import io.gs2.loginReward.request.DeleteReceiveStatusByUserIdRequest;
import io.gs2.loginReward.request.DescribeBonusModelMastersRequest;
import io.gs2.loginReward.request.DescribeBonusModelsRequest;
import io.gs2.loginReward.request.DescribeNamespacesRequest;
import io.gs2.loginReward.request.DescribeReceiveStatusesByUserIdRequest;
import io.gs2.loginReward.request.DescribeReceiveStatusesRequest;
import io.gs2.loginReward.request.ExportMasterRequest;
import io.gs2.loginReward.request.GetBonusModelMasterRequest;
import io.gs2.loginReward.request.GetBonusModelRequest;
import io.gs2.loginReward.request.GetCurrentBonusMasterRequest;
import io.gs2.loginReward.request.GetNamespaceRequest;
import io.gs2.loginReward.request.GetNamespaceStatusRequest;
import io.gs2.loginReward.request.GetReceiveStatusByUserIdRequest;
import io.gs2.loginReward.request.GetReceiveStatusRequest;
import io.gs2.loginReward.request.MarkReceivedByStampTaskRequest;
import io.gs2.loginReward.request.MarkReceivedByUserIdRequest;
import io.gs2.loginReward.request.MarkReceivedRequest;
import io.gs2.loginReward.request.MissedReceiveByUserIdRequest;
import io.gs2.loginReward.request.MissedReceiveRequest;
import io.gs2.loginReward.request.ReceiveByUserIdRequest;
import io.gs2.loginReward.request.ReceiveRequest;
import io.gs2.loginReward.request.UnmarkReceivedByStampSheetRequest;
import io.gs2.loginReward.request.UnmarkReceivedByUserIdRequest;
import io.gs2.loginReward.request.UpdateBonusModelMasterRequest;
import io.gs2.loginReward.request.UpdateCurrentBonusMasterFromGitHubRequest;
import io.gs2.loginReward.request.UpdateCurrentBonusMasterRequest;
import io.gs2.loginReward.request.UpdateNamespaceRequest;
import io.gs2.loginReward.result.CreateBonusModelMasterResult;
import io.gs2.loginReward.result.CreateNamespaceResult;
import io.gs2.loginReward.result.DeleteBonusModelMasterResult;
import io.gs2.loginReward.result.DeleteNamespaceResult;
import io.gs2.loginReward.result.DeleteReceiveStatusByStampSheetResult;
import io.gs2.loginReward.result.DeleteReceiveStatusByUserIdResult;
import io.gs2.loginReward.result.DescribeBonusModelMastersResult;
import io.gs2.loginReward.result.DescribeBonusModelsResult;
import io.gs2.loginReward.result.DescribeNamespacesResult;
import io.gs2.loginReward.result.DescribeReceiveStatusesByUserIdResult;
import io.gs2.loginReward.result.DescribeReceiveStatusesResult;
import io.gs2.loginReward.result.ExportMasterResult;
import io.gs2.loginReward.result.GetBonusModelMasterResult;
import io.gs2.loginReward.result.GetBonusModelResult;
import io.gs2.loginReward.result.GetCurrentBonusMasterResult;
import io.gs2.loginReward.result.GetNamespaceResult;
import io.gs2.loginReward.result.GetNamespaceStatusResult;
import io.gs2.loginReward.result.GetReceiveStatusByUserIdResult;
import io.gs2.loginReward.result.GetReceiveStatusResult;
import io.gs2.loginReward.result.MarkReceivedByStampTaskResult;
import io.gs2.loginReward.result.MarkReceivedByUserIdResult;
import io.gs2.loginReward.result.MarkReceivedResult;
import io.gs2.loginReward.result.MissedReceiveByUserIdResult;
import io.gs2.loginReward.result.MissedReceiveResult;
import io.gs2.loginReward.result.ReceiveByUserIdResult;
import io.gs2.loginReward.result.ReceiveResult;
import io.gs2.loginReward.result.UnmarkReceivedByStampSheetResult;
import io.gs2.loginReward.result.UnmarkReceivedByUserIdResult;
import io.gs2.loginReward.result.UpdateBonusModelMasterResult;
import io.gs2.loginReward.result.UpdateCurrentBonusMasterFromGitHubResult;
import io.gs2.loginReward.result.UpdateCurrentBonusMasterResult;
import io.gs2.loginReward.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2LoginRewardRestClient
extends AbstractGs2Client<Gs2LoginRewardRestClient> {
    public Gs2LoginRewardRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeBonusModelMastersAsync(DescribeBonusModelMastersRequest request, AsyncAction<AsyncResult<DescribeBonusModelMastersResult>> callback) {
        DescribeBonusModelMastersTask task = new DescribeBonusModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBonusModelMastersResult describeBonusModelMasters(DescribeBonusModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBonusModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBonusModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createBonusModelMasterAsync(CreateBonusModelMasterRequest request, AsyncAction<AsyncResult<CreateBonusModelMasterResult>> callback) {
        CreateBonusModelMasterTask task = new CreateBonusModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateBonusModelMasterResult createBonusModelMaster(CreateBonusModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createBonusModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateBonusModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getBonusModelMasterAsync(GetBonusModelMasterRequest request, AsyncAction<AsyncResult<GetBonusModelMasterResult>> callback) {
        GetBonusModelMasterTask task = new GetBonusModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetBonusModelMasterResult getBonusModelMaster(GetBonusModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getBonusModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetBonusModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateBonusModelMasterAsync(UpdateBonusModelMasterRequest request, AsyncAction<AsyncResult<UpdateBonusModelMasterResult>> callback) {
        UpdateBonusModelMasterTask task = new UpdateBonusModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateBonusModelMasterResult updateBonusModelMaster(UpdateBonusModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateBonusModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateBonusModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteBonusModelMasterAsync(DeleteBonusModelMasterRequest request, AsyncAction<AsyncResult<DeleteBonusModelMasterResult>> callback) {
        DeleteBonusModelMasterTask task = new DeleteBonusModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteBonusModelMasterResult deleteBonusModelMaster(DeleteBonusModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteBonusModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteBonusModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentBonusMasterAsync(GetCurrentBonusMasterRequest request, AsyncAction<AsyncResult<GetCurrentBonusMasterResult>> callback) {
        GetCurrentBonusMasterTask task = new GetCurrentBonusMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentBonusMasterResult getCurrentBonusMaster(GetCurrentBonusMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentBonusMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentBonusMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentBonusMasterAsync(UpdateCurrentBonusMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentBonusMasterResult>> callback) {
        UpdateCurrentBonusMasterTask task = new UpdateCurrentBonusMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentBonusMasterResult updateCurrentBonusMaster(UpdateCurrentBonusMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentBonusMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentBonusMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentBonusMasterFromGitHubAsync(UpdateCurrentBonusMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentBonusMasterFromGitHubResult>> callback) {
        UpdateCurrentBonusMasterFromGitHubTask task = new UpdateCurrentBonusMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentBonusMasterFromGitHubResult updateCurrentBonusMasterFromGitHub(UpdateCurrentBonusMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentBonusMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentBonusMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void describeBonusModelsAsync(DescribeBonusModelsRequest request, AsyncAction<AsyncResult<DescribeBonusModelsResult>> callback) {
        DescribeBonusModelsTask task = new DescribeBonusModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeBonusModelsResult describeBonusModels(DescribeBonusModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeBonusModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeBonusModelsResult)resultAsyncResult[0].getResult();
    }

    public void getBonusModelAsync(GetBonusModelRequest request, AsyncAction<AsyncResult<GetBonusModelResult>> callback) {
        GetBonusModelTask task = new GetBonusModelTask(request, callback);
        this.session.execute(task);
    }

    public GetBonusModelResult getBonusModel(GetBonusModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getBonusModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetBonusModelResult)resultAsyncResult[0].getResult();
    }

    public void receiveAsync(ReceiveRequest request, AsyncAction<AsyncResult<ReceiveResult>> callback) {
        ReceiveTask task = new ReceiveTask(request, callback);
        this.session.execute(task);
    }

    public ReceiveResult receive(ReceiveRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.receiveAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReceiveResult)resultAsyncResult[0].getResult();
    }

    public void receiveByUserIdAsync(ReceiveByUserIdRequest request, AsyncAction<AsyncResult<ReceiveByUserIdResult>> callback) {
        ReceiveByUserIdTask task = new ReceiveByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ReceiveByUserIdResult receiveByUserId(ReceiveByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.receiveByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReceiveByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void missedReceiveAsync(MissedReceiveRequest request, AsyncAction<AsyncResult<MissedReceiveResult>> callback) {
        MissedReceiveTask task = new MissedReceiveTask(request, callback);
        this.session.execute(task);
    }

    public MissedReceiveResult missedReceive(MissedReceiveRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.missedReceiveAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MissedReceiveResult)resultAsyncResult[0].getResult();
    }

    public void missedReceiveByUserIdAsync(MissedReceiveByUserIdRequest request, AsyncAction<AsyncResult<MissedReceiveByUserIdResult>> callback) {
        MissedReceiveByUserIdTask task = new MissedReceiveByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public MissedReceiveByUserIdResult missedReceiveByUserId(MissedReceiveByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.missedReceiveByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MissedReceiveByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeReceiveStatusesAsync(DescribeReceiveStatusesRequest request, AsyncAction<AsyncResult<DescribeReceiveStatusesResult>> callback) {
        DescribeReceiveStatusesTask task = new DescribeReceiveStatusesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeReceiveStatusesResult describeReceiveStatuses(DescribeReceiveStatusesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeReceiveStatusesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeReceiveStatusesResult)resultAsyncResult[0].getResult();
    }

    public void describeReceiveStatusesByUserIdAsync(DescribeReceiveStatusesByUserIdRequest request, AsyncAction<AsyncResult<DescribeReceiveStatusesByUserIdResult>> callback) {
        DescribeReceiveStatusesByUserIdTask task = new DescribeReceiveStatusesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeReceiveStatusesByUserIdResult describeReceiveStatusesByUserId(DescribeReceiveStatusesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeReceiveStatusesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeReceiveStatusesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getReceiveStatusAsync(GetReceiveStatusRequest request, AsyncAction<AsyncResult<GetReceiveStatusResult>> callback) {
        GetReceiveStatusTask task = new GetReceiveStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetReceiveStatusResult getReceiveStatus(GetReceiveStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getReceiveStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetReceiveStatusResult)resultAsyncResult[0].getResult();
    }

    public void getReceiveStatusByUserIdAsync(GetReceiveStatusByUserIdRequest request, AsyncAction<AsyncResult<GetReceiveStatusByUserIdResult>> callback) {
        GetReceiveStatusByUserIdTask task = new GetReceiveStatusByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetReceiveStatusByUserIdResult getReceiveStatusByUserId(GetReceiveStatusByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getReceiveStatusByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetReceiveStatusByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteReceiveStatusByUserIdAsync(DeleteReceiveStatusByUserIdRequest request, AsyncAction<AsyncResult<DeleteReceiveStatusByUserIdResult>> callback) {
        DeleteReceiveStatusByUserIdTask task = new DeleteReceiveStatusByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteReceiveStatusByUserIdResult deleteReceiveStatusByUserId(DeleteReceiveStatusByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteReceiveStatusByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteReceiveStatusByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteReceiveStatusByStampSheetAsync(DeleteReceiveStatusByStampSheetRequest request, AsyncAction<AsyncResult<DeleteReceiveStatusByStampSheetResult>> callback) {
        DeleteReceiveStatusByStampSheetTask task = new DeleteReceiveStatusByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public DeleteReceiveStatusByStampSheetResult deleteReceiveStatusByStampSheet(DeleteReceiveStatusByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteReceiveStatusByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteReceiveStatusByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void markReceivedAsync(MarkReceivedRequest request, AsyncAction<AsyncResult<MarkReceivedResult>> callback) {
        MarkReceivedTask task = new MarkReceivedTask(request, callback);
        this.session.execute(task);
    }

    public MarkReceivedResult markReceived(MarkReceivedRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.markReceivedAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MarkReceivedResult)resultAsyncResult[0].getResult();
    }

    public void markReceivedByUserIdAsync(MarkReceivedByUserIdRequest request, AsyncAction<AsyncResult<MarkReceivedByUserIdResult>> callback) {
        MarkReceivedByUserIdTask task = new MarkReceivedByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public MarkReceivedByUserIdResult markReceivedByUserId(MarkReceivedByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.markReceivedByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MarkReceivedByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void unmarkReceivedByUserIdAsync(UnmarkReceivedByUserIdRequest request, AsyncAction<AsyncResult<UnmarkReceivedByUserIdResult>> callback) {
        UnmarkReceivedByUserIdTask task = new UnmarkReceivedByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UnmarkReceivedByUserIdResult unmarkReceivedByUserId(UnmarkReceivedByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unmarkReceivedByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnmarkReceivedByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void markReceivedByStampTaskAsync(MarkReceivedByStampTaskRequest request, AsyncAction<AsyncResult<MarkReceivedByStampTaskResult>> callback) {
        MarkReceivedByStampTaskTask task = new MarkReceivedByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public MarkReceivedByStampTaskResult markReceivedByStampTask(MarkReceivedByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.markReceivedByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (MarkReceivedByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void unmarkReceivedByStampSheetAsync(UnmarkReceivedByStampSheetRequest request, AsyncAction<AsyncResult<UnmarkReceivedByStampSheetResult>> callback) {
        UnmarkReceivedByStampSheetTask task = new UnmarkReceivedByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public UnmarkReceivedByStampSheetResult unmarkReceivedByStampSheet(UnmarkReceivedByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.unmarkReceivedByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UnmarkReceivedByStampSheetResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", CreateNamespaceTask.this.request.getTransactionSetting() != null ? CreateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("receiveScript", CreateNamespaceTask.this.request.getReceiveScript() != null ? CreateNamespaceTask.this.request.getReceiveScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", UpdateNamespaceTask.this.request.getTransactionSetting() != null ? UpdateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("receiveScript", UpdateNamespaceTask.this.request.getReceiveScript() != null ? UpdateNamespaceTask.this.request.getReceiveScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeBonusModelMastersTask
    extends Gs2RestSessionTask<DescribeBonusModelMastersResult> {
        private DescribeBonusModelMastersRequest request;

        public DescribeBonusModelMastersTask(DescribeBonusModelMastersRequest request, AsyncAction<AsyncResult<DescribeBonusModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBonusModelMastersResult parse(JsonNode data) {
            return DescribeBonusModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/bonusModel";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateBonusModelMasterTask
    extends Gs2RestSessionTask<CreateBonusModelMasterResult> {
        private CreateBonusModelMasterRequest request;

        public CreateBonusModelMasterTask(CreateBonusModelMasterRequest request, AsyncAction<AsyncResult<CreateBonusModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateBonusModelMasterResult parse(JsonNode data) {
            return CreateBonusModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/bonusModel";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateBonusModelMasterTask.this.request.getName());
                    this.put("description", CreateBonusModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateBonusModelMasterTask.this.request.getMetadata());
                    this.put("mode", CreateBonusModelMasterTask.this.request.getMode());
                    this.put("periodEventId", CreateBonusModelMasterTask.this.request.getPeriodEventId());
                    this.put("resetHour", CreateBonusModelMasterTask.this.request.getResetHour());
                    this.put("repeat", CreateBonusModelMasterTask.this.request.getRepeat());
                    this.put("rewards", CreateBonusModelMasterTask.this.request.getRewards() == null ? new ArrayList() : CreateBonusModelMasterTask.this.request.getRewards().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("missedReceiveRelief", CreateBonusModelMasterTask.this.request.getMissedReceiveRelief());
                    this.put("missedReceiveReliefConsumeActions", CreateBonusModelMasterTask.this.request.getMissedReceiveReliefConsumeActions() == null ? new ArrayList() : CreateBonusModelMasterTask.this.request.getMissedReceiveReliefConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CreateBonusModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetBonusModelMasterTask
    extends Gs2RestSessionTask<GetBonusModelMasterResult> {
        private GetBonusModelMasterRequest request;

        public GetBonusModelMasterTask(GetBonusModelMasterRequest request, AsyncAction<AsyncResult<GetBonusModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetBonusModelMasterResult parse(JsonNode data) {
            return GetBonusModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/bonusModel/{bonusModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateBonusModelMasterTask
    extends Gs2RestSessionTask<UpdateBonusModelMasterResult> {
        private UpdateBonusModelMasterRequest request;

        public UpdateBonusModelMasterTask(UpdateBonusModelMasterRequest request, AsyncAction<AsyncResult<UpdateBonusModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateBonusModelMasterResult parse(JsonNode data) {
            return UpdateBonusModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/bonusModel/{bonusModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateBonusModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateBonusModelMasterTask.this.request.getMetadata());
                    this.put("mode", UpdateBonusModelMasterTask.this.request.getMode());
                    this.put("periodEventId", UpdateBonusModelMasterTask.this.request.getPeriodEventId());
                    this.put("resetHour", UpdateBonusModelMasterTask.this.request.getResetHour());
                    this.put("repeat", UpdateBonusModelMasterTask.this.request.getRepeat());
                    this.put("rewards", UpdateBonusModelMasterTask.this.request.getRewards() == null ? new ArrayList() : UpdateBonusModelMasterTask.this.request.getRewards().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("missedReceiveRelief", UpdateBonusModelMasterTask.this.request.getMissedReceiveRelief());
                    this.put("missedReceiveReliefConsumeActions", UpdateBonusModelMasterTask.this.request.getMissedReceiveReliefConsumeActions() == null ? new ArrayList() : UpdateBonusModelMasterTask.this.request.getMissedReceiveReliefConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", UpdateBonusModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteBonusModelMasterTask
    extends Gs2RestSessionTask<DeleteBonusModelMasterResult> {
        private DeleteBonusModelMasterRequest request;

        public DeleteBonusModelMasterTask(DeleteBonusModelMasterRequest request, AsyncAction<AsyncResult<DeleteBonusModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteBonusModelMasterResult parse(JsonNode data) {
            return DeleteBonusModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/bonusModel/{bonusModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentBonusMasterTask
    extends Gs2RestSessionTask<GetCurrentBonusMasterResult> {
        private GetCurrentBonusMasterRequest request;

        public GetCurrentBonusMasterTask(GetCurrentBonusMasterRequest request, AsyncAction<AsyncResult<GetCurrentBonusMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentBonusMasterResult parse(JsonNode data) {
            return GetCurrentBonusMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentBonusMasterTask
    extends Gs2RestSessionTask<UpdateCurrentBonusMasterResult> {
        private UpdateCurrentBonusMasterRequest request;

        public UpdateCurrentBonusMasterTask(UpdateCurrentBonusMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentBonusMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentBonusMasterResult parse(JsonNode data) {
            return UpdateCurrentBonusMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentBonusMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentBonusMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentBonusMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentBonusMasterFromGitHubResult> {
        private UpdateCurrentBonusMasterFromGitHubRequest request;

        public UpdateCurrentBonusMasterFromGitHubTask(UpdateCurrentBonusMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentBonusMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentBonusMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentBonusMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentBonusMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentBonusMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentBonusMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeBonusModelsTask
    extends Gs2RestSessionTask<DescribeBonusModelsResult> {
        private DescribeBonusModelsRequest request;

        public DescribeBonusModelsTask(DescribeBonusModelsRequest request, AsyncAction<AsyncResult<DescribeBonusModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeBonusModelsResult parse(JsonNode data) {
            return DescribeBonusModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model/bonusModel";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetBonusModelTask
    extends Gs2RestSessionTask<GetBonusModelResult> {
        private GetBonusModelRequest request;

        public GetBonusModelTask(GetBonusModelRequest request, AsyncAction<AsyncResult<GetBonusModelResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetBonusModelResult parse(JsonNode data) {
            return GetBonusModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model/bonusModel/{bonusModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ReceiveTask
    extends Gs2RestSessionTask<ReceiveResult> {
        private ReceiveRequest request;

        public ReceiveTask(ReceiveRequest request, AsyncAction<AsyncResult<ReceiveResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReceiveResult parse(JsonNode data) {
            return ReceiveResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/bonus/{bonusModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", ReceiveTask.this.request.getConfig() == null ? new ArrayList() : ReceiveTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ReceiveTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ReceiveByUserIdTask
    extends Gs2RestSessionTask<ReceiveByUserIdResult> {
        private ReceiveByUserIdRequest request;

        public ReceiveByUserIdTask(ReceiveByUserIdRequest request, AsyncAction<AsyncResult<ReceiveByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReceiveByUserIdResult parse(JsonNode data) {
            return ReceiveByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/bonus/{bonusModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", ReceiveByUserIdTask.this.request.getConfig() == null ? new ArrayList() : ReceiveByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ReceiveByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class MissedReceiveTask
    extends Gs2RestSessionTask<MissedReceiveResult> {
        private MissedReceiveRequest request;

        public MissedReceiveTask(MissedReceiveRequest request, AsyncAction<AsyncResult<MissedReceiveResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MissedReceiveResult parse(JsonNode data) {
            return MissedReceiveResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/bonus/{bonusModelName}/missed";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stepNumber", MissedReceiveTask.this.request.getStepNumber());
                    this.put("config", MissedReceiveTask.this.request.getConfig() == null ? new ArrayList() : MissedReceiveTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", MissedReceiveTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class MissedReceiveByUserIdTask
    extends Gs2RestSessionTask<MissedReceiveByUserIdResult> {
        private MissedReceiveByUserIdRequest request;

        public MissedReceiveByUserIdTask(MissedReceiveByUserIdRequest request, AsyncAction<AsyncResult<MissedReceiveByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MissedReceiveByUserIdResult parse(JsonNode data) {
            return MissedReceiveByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/bonus/{bonusModelName}/missed";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stepNumber", MissedReceiveByUserIdTask.this.request.getStepNumber());
                    this.put("config", MissedReceiveByUserIdTask.this.request.getConfig() == null ? new ArrayList() : MissedReceiveByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", MissedReceiveByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeReceiveStatusesTask
    extends Gs2RestSessionTask<DescribeReceiveStatusesResult> {
        private DescribeReceiveStatusesRequest request;

        public DescribeReceiveStatusesTask(DescribeReceiveStatusesRequest request, AsyncAction<AsyncResult<DescribeReceiveStatusesResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeReceiveStatusesResult parse(JsonNode data) {
            return DescribeReceiveStatusesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/login_reward";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeReceiveStatusesByUserIdTask
    extends Gs2RestSessionTask<DescribeReceiveStatusesByUserIdResult> {
        private DescribeReceiveStatusesByUserIdRequest request;

        public DescribeReceiveStatusesByUserIdTask(DescribeReceiveStatusesByUserIdRequest request, AsyncAction<AsyncResult<DescribeReceiveStatusesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeReceiveStatusesByUserIdResult parse(JsonNode data) {
            return DescribeReceiveStatusesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/login_reward";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetReceiveStatusTask
    extends Gs2RestSessionTask<GetReceiveStatusResult> {
        private GetReceiveStatusRequest request;

        public GetReceiveStatusTask(GetReceiveStatusRequest request, AsyncAction<AsyncResult<GetReceiveStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetReceiveStatusResult parse(JsonNode data) {
            return GetReceiveStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/receiveStatus/{bonusModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetReceiveStatusByUserIdTask
    extends Gs2RestSessionTask<GetReceiveStatusByUserIdResult> {
        private GetReceiveStatusByUserIdRequest request;

        public GetReceiveStatusByUserIdTask(GetReceiveStatusByUserIdRequest request, AsyncAction<AsyncResult<GetReceiveStatusByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetReceiveStatusByUserIdResult parse(JsonNode data) {
            return GetReceiveStatusByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/receiveStatus/{bonusModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteReceiveStatusByUserIdTask
    extends Gs2RestSessionTask<DeleteReceiveStatusByUserIdResult> {
        private DeleteReceiveStatusByUserIdRequest request;

        public DeleteReceiveStatusByUserIdTask(DeleteReceiveStatusByUserIdRequest request, AsyncAction<AsyncResult<DeleteReceiveStatusByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteReceiveStatusByUserIdResult parse(JsonNode data) {
            return DeleteReceiveStatusByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/receiveStatus/{bonusModelName}/delete";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DeleteReceiveStatusByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteReceiveStatusByStampSheetTask
    extends Gs2RestSessionTask<DeleteReceiveStatusByStampSheetResult> {
        private DeleteReceiveStatusByStampSheetRequest request;

        public DeleteReceiveStatusByStampSheetTask(DeleteReceiveStatusByStampSheetRequest request, AsyncAction<AsyncResult<DeleteReceiveStatusByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteReceiveStatusByStampSheetResult parse(JsonNode data) {
            return DeleteReceiveStatusByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/receiveStatus/delete";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", DeleteReceiveStatusByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", DeleteReceiveStatusByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", DeleteReceiveStatusByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class MarkReceivedTask
    extends Gs2RestSessionTask<MarkReceivedResult> {
        private MarkReceivedRequest request;

        public MarkReceivedTask(MarkReceivedRequest request, AsyncAction<AsyncResult<MarkReceivedResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MarkReceivedResult parse(JsonNode data) {
            return MarkReceivedResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/receiveStatus/{bonusModelName}/mark";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stepNumber", MarkReceivedTask.this.request.getStepNumber());
                    this.put("contextStack", MarkReceivedTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class MarkReceivedByUserIdTask
    extends Gs2RestSessionTask<MarkReceivedByUserIdResult> {
        private MarkReceivedByUserIdRequest request;

        public MarkReceivedByUserIdTask(MarkReceivedByUserIdRequest request, AsyncAction<AsyncResult<MarkReceivedByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MarkReceivedByUserIdResult parse(JsonNode data) {
            return MarkReceivedByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/receiveStatus/{bonusModelName}/mark";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stepNumber", MarkReceivedByUserIdTask.this.request.getStepNumber());
                    this.put("contextStack", MarkReceivedByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UnmarkReceivedByUserIdTask
    extends Gs2RestSessionTask<UnmarkReceivedByUserIdResult> {
        private UnmarkReceivedByUserIdRequest request;

        public UnmarkReceivedByUserIdTask(UnmarkReceivedByUserIdRequest request, AsyncAction<AsyncResult<UnmarkReceivedByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnmarkReceivedByUserIdResult parse(JsonNode data) {
            return UnmarkReceivedByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/receiveStatus/{bonusModelName}/unmark";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{bonusModelName}", this.request.getBonusModelName() == null || this.request.getBonusModelName().length() == 0 ? "null" : String.valueOf(this.request.getBonusModelName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stepNumber", UnmarkReceivedByUserIdTask.this.request.getStepNumber());
                    this.put("contextStack", UnmarkReceivedByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class MarkReceivedByStampTaskTask
    extends Gs2RestSessionTask<MarkReceivedByStampTaskResult> {
        private MarkReceivedByStampTaskRequest request;

        public MarkReceivedByStampTaskTask(MarkReceivedByStampTaskRequest request, AsyncAction<AsyncResult<MarkReceivedByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public MarkReceivedByStampTaskResult parse(JsonNode data) {
            return MarkReceivedByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/receiveStatus/mark";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", MarkReceivedByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", MarkReceivedByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", MarkReceivedByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UnmarkReceivedByStampSheetTask
    extends Gs2RestSessionTask<UnmarkReceivedByStampSheetResult> {
        private UnmarkReceivedByStampSheetRequest request;

        public UnmarkReceivedByStampSheetTask(UnmarkReceivedByStampSheetRequest request, AsyncAction<AsyncResult<UnmarkReceivedByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2LoginRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UnmarkReceivedByStampSheetResult parse(JsonNode data) {
            return UnmarkReceivedByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "login-reward").replace("{region}", Gs2LoginRewardRestClient.this.session.getRegion().getName()) + "/receiveStatus/unmark";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", UnmarkReceivedByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", UnmarkReceivedByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", UnmarkReceivedByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

