/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.idle;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.idle.request.CreateCategoryModelMasterRequest;
import io.gs2.idle.request.CreateNamespaceRequest;
import io.gs2.idle.request.DecreaseMaximumIdleMinutesByStampTaskRequest;
import io.gs2.idle.request.DecreaseMaximumIdleMinutesByUserIdRequest;
import io.gs2.idle.request.DeleteCategoryModelMasterRequest;
import io.gs2.idle.request.DeleteNamespaceRequest;
import io.gs2.idle.request.DescribeCategoryModelMastersRequest;
import io.gs2.idle.request.DescribeCategoryModelsRequest;
import io.gs2.idle.request.DescribeNamespacesRequest;
import io.gs2.idle.request.DescribeStatusesByUserIdRequest;
import io.gs2.idle.request.DescribeStatusesRequest;
import io.gs2.idle.request.ExportMasterRequest;
import io.gs2.idle.request.GetCategoryModelMasterRequest;
import io.gs2.idle.request.GetCategoryModelRequest;
import io.gs2.idle.request.GetCurrentCategoryMasterRequest;
import io.gs2.idle.request.GetNamespaceRequest;
import io.gs2.idle.request.GetNamespaceStatusRequest;
import io.gs2.idle.request.GetStatusByUserIdRequest;
import io.gs2.idle.request.GetStatusRequest;
import io.gs2.idle.request.IncreaseMaximumIdleMinutesByStampSheetRequest;
import io.gs2.idle.request.IncreaseMaximumIdleMinutesByUserIdRequest;
import io.gs2.idle.request.PredictionByUserIdRequest;
import io.gs2.idle.request.PredictionRequest;
import io.gs2.idle.request.ReceiveByUserIdRequest;
import io.gs2.idle.request.ReceiveRequest;
import io.gs2.idle.request.UpdateCategoryModelMasterRequest;
import io.gs2.idle.request.UpdateCurrentCategoryMasterFromGitHubRequest;
import io.gs2.idle.request.UpdateCurrentCategoryMasterRequest;
import io.gs2.idle.request.UpdateNamespaceRequest;
import io.gs2.idle.result.CreateCategoryModelMasterResult;
import io.gs2.idle.result.CreateNamespaceResult;
import io.gs2.idle.result.DecreaseMaximumIdleMinutesByStampTaskResult;
import io.gs2.idle.result.DecreaseMaximumIdleMinutesByUserIdResult;
import io.gs2.idle.result.DeleteCategoryModelMasterResult;
import io.gs2.idle.result.DeleteNamespaceResult;
import io.gs2.idle.result.DescribeCategoryModelMastersResult;
import io.gs2.idle.result.DescribeCategoryModelsResult;
import io.gs2.idle.result.DescribeNamespacesResult;
import io.gs2.idle.result.DescribeStatusesByUserIdResult;
import io.gs2.idle.result.DescribeStatusesResult;
import io.gs2.idle.result.ExportMasterResult;
import io.gs2.idle.result.GetCategoryModelMasterResult;
import io.gs2.idle.result.GetCategoryModelResult;
import io.gs2.idle.result.GetCurrentCategoryMasterResult;
import io.gs2.idle.result.GetNamespaceResult;
import io.gs2.idle.result.GetNamespaceStatusResult;
import io.gs2.idle.result.GetStatusByUserIdResult;
import io.gs2.idle.result.GetStatusResult;
import io.gs2.idle.result.IncreaseMaximumIdleMinutesByStampSheetResult;
import io.gs2.idle.result.IncreaseMaximumIdleMinutesByUserIdResult;
import io.gs2.idle.result.PredictionByUserIdResult;
import io.gs2.idle.result.PredictionResult;
import io.gs2.idle.result.ReceiveByUserIdResult;
import io.gs2.idle.result.ReceiveResult;
import io.gs2.idle.result.UpdateCategoryModelMasterResult;
import io.gs2.idle.result.UpdateCurrentCategoryMasterFromGitHubResult;
import io.gs2.idle.result.UpdateCurrentCategoryMasterResult;
import io.gs2.idle.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2IdleRestClient
extends AbstractGs2Client<Gs2IdleRestClient> {
    public Gs2IdleRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeCategoryModelMastersAsync(DescribeCategoryModelMastersRequest request, AsyncAction<AsyncResult<DescribeCategoryModelMastersResult>> callback) {
        DescribeCategoryModelMastersTask task = new DescribeCategoryModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCategoryModelMastersResult describeCategoryModelMasters(DescribeCategoryModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCategoryModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCategoryModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createCategoryModelMasterAsync(CreateCategoryModelMasterRequest request, AsyncAction<AsyncResult<CreateCategoryModelMasterResult>> callback) {
        CreateCategoryModelMasterTask task = new CreateCategoryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateCategoryModelMasterResult createCategoryModelMaster(CreateCategoryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createCategoryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateCategoryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCategoryModelMasterAsync(GetCategoryModelMasterRequest request, AsyncAction<AsyncResult<GetCategoryModelMasterResult>> callback) {
        GetCategoryModelMasterTask task = new GetCategoryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCategoryModelMasterResult getCategoryModelMaster(GetCategoryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCategoryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCategoryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCategoryModelMasterAsync(UpdateCategoryModelMasterRequest request, AsyncAction<AsyncResult<UpdateCategoryModelMasterResult>> callback) {
        UpdateCategoryModelMasterTask task = new UpdateCategoryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCategoryModelMasterResult updateCategoryModelMaster(UpdateCategoryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCategoryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCategoryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteCategoryModelMasterAsync(DeleteCategoryModelMasterRequest request, AsyncAction<AsyncResult<DeleteCategoryModelMasterResult>> callback) {
        DeleteCategoryModelMasterTask task = new DeleteCategoryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteCategoryModelMasterResult deleteCategoryModelMaster(DeleteCategoryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteCategoryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteCategoryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeCategoryModelsAsync(DescribeCategoryModelsRequest request, AsyncAction<AsyncResult<DescribeCategoryModelsResult>> callback) {
        DescribeCategoryModelsTask task = new DescribeCategoryModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCategoryModelsResult describeCategoryModels(DescribeCategoryModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCategoryModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCategoryModelsResult)resultAsyncResult[0].getResult();
    }

    public void getCategoryModelAsync(GetCategoryModelRequest request, AsyncAction<AsyncResult<GetCategoryModelResult>> callback) {
        GetCategoryModelTask task = new GetCategoryModelTask(request, callback);
        this.session.execute(task);
    }

    public GetCategoryModelResult getCategoryModel(GetCategoryModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCategoryModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCategoryModelResult)resultAsyncResult[0].getResult();
    }

    public void describeStatusesAsync(DescribeStatusesRequest request, AsyncAction<AsyncResult<DescribeStatusesResult>> callback) {
        DescribeStatusesTask task = new DescribeStatusesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeStatusesResult describeStatuses(DescribeStatusesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeStatusesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeStatusesResult)resultAsyncResult[0].getResult();
    }

    public void describeStatusesByUserIdAsync(DescribeStatusesByUserIdRequest request, AsyncAction<AsyncResult<DescribeStatusesByUserIdResult>> callback) {
        DescribeStatusesByUserIdTask task = new DescribeStatusesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeStatusesByUserIdResult describeStatusesByUserId(DescribeStatusesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeStatusesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeStatusesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getStatusAsync(GetStatusRequest request, AsyncAction<AsyncResult<GetStatusResult>> callback) {
        GetStatusTask task = new GetStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetStatusResult getStatus(GetStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStatusResult)resultAsyncResult[0].getResult();
    }

    public void getStatusByUserIdAsync(GetStatusByUserIdRequest request, AsyncAction<AsyncResult<GetStatusByUserIdResult>> callback) {
        GetStatusByUserIdTask task = new GetStatusByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetStatusByUserIdResult getStatusByUserId(GetStatusByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStatusByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStatusByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void predictionAsync(PredictionRequest request, AsyncAction<AsyncResult<PredictionResult>> callback) {
        PredictionTask task = new PredictionTask(request, callback);
        this.session.execute(task);
    }

    public PredictionResult prediction(PredictionRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.predictionAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PredictionResult)resultAsyncResult[0].getResult();
    }

    public void predictionByUserIdAsync(PredictionByUserIdRequest request, AsyncAction<AsyncResult<PredictionByUserIdResult>> callback) {
        PredictionByUserIdTask task = new PredictionByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PredictionByUserIdResult predictionByUserId(PredictionByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.predictionByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PredictionByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void receiveAsync(ReceiveRequest request, AsyncAction<AsyncResult<ReceiveResult>> callback) {
        ReceiveTask task = new ReceiveTask(request, callback);
        this.session.execute(task);
    }

    public ReceiveResult receive(ReceiveRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.receiveAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReceiveResult)resultAsyncResult[0].getResult();
    }

    public void receiveByUserIdAsync(ReceiveByUserIdRequest request, AsyncAction<AsyncResult<ReceiveByUserIdResult>> callback) {
        ReceiveByUserIdTask task = new ReceiveByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ReceiveByUserIdResult receiveByUserId(ReceiveByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.receiveByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ReceiveByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void increaseMaximumIdleMinutesByUserIdAsync(IncreaseMaximumIdleMinutesByUserIdRequest request, AsyncAction<AsyncResult<IncreaseMaximumIdleMinutesByUserIdResult>> callback) {
        IncreaseMaximumIdleMinutesByUserIdTask task = new IncreaseMaximumIdleMinutesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public IncreaseMaximumIdleMinutesByUserIdResult increaseMaximumIdleMinutesByUserId(IncreaseMaximumIdleMinutesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.increaseMaximumIdleMinutesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (IncreaseMaximumIdleMinutesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void decreaseMaximumIdleMinutesByUserIdAsync(DecreaseMaximumIdleMinutesByUserIdRequest request, AsyncAction<AsyncResult<DecreaseMaximumIdleMinutesByUserIdResult>> callback) {
        DecreaseMaximumIdleMinutesByUserIdTask task = new DecreaseMaximumIdleMinutesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DecreaseMaximumIdleMinutesByUserIdResult decreaseMaximumIdleMinutesByUserId(DecreaseMaximumIdleMinutesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.decreaseMaximumIdleMinutesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DecreaseMaximumIdleMinutesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void increaseMaximumIdleMinutesByStampSheetAsync(IncreaseMaximumIdleMinutesByStampSheetRequest request, AsyncAction<AsyncResult<IncreaseMaximumIdleMinutesByStampSheetResult>> callback) {
        IncreaseMaximumIdleMinutesByStampSheetTask task = new IncreaseMaximumIdleMinutesByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public IncreaseMaximumIdleMinutesByStampSheetResult increaseMaximumIdleMinutesByStampSheet(IncreaseMaximumIdleMinutesByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.increaseMaximumIdleMinutesByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (IncreaseMaximumIdleMinutesByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void decreaseMaximumIdleMinutesByStampTaskAsync(DecreaseMaximumIdleMinutesByStampTaskRequest request, AsyncAction<AsyncResult<DecreaseMaximumIdleMinutesByStampTaskResult>> callback) {
        DecreaseMaximumIdleMinutesByStampTaskTask task = new DecreaseMaximumIdleMinutesByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public DecreaseMaximumIdleMinutesByStampTaskResult decreaseMaximumIdleMinutesByStampTask(DecreaseMaximumIdleMinutesByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.decreaseMaximumIdleMinutesByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DecreaseMaximumIdleMinutesByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentCategoryMasterAsync(GetCurrentCategoryMasterRequest request, AsyncAction<AsyncResult<GetCurrentCategoryMasterResult>> callback) {
        GetCurrentCategoryMasterTask task = new GetCurrentCategoryMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentCategoryMasterResult getCurrentCategoryMaster(GetCurrentCategoryMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentCategoryMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentCategoryMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentCategoryMasterAsync(UpdateCurrentCategoryMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentCategoryMasterResult>> callback) {
        UpdateCurrentCategoryMasterTask task = new UpdateCurrentCategoryMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentCategoryMasterResult updateCurrentCategoryMaster(UpdateCurrentCategoryMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentCategoryMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentCategoryMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentCategoryMasterFromGitHubAsync(UpdateCurrentCategoryMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentCategoryMasterFromGitHubResult>> callback) {
        UpdateCurrentCategoryMasterFromGitHubTask task = new UpdateCurrentCategoryMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentCategoryMasterFromGitHubResult updateCurrentCategoryMasterFromGitHub(UpdateCurrentCategoryMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentCategoryMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentCategoryMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", CreateNamespaceTask.this.request.getTransactionSetting() != null ? CreateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("receiveScript", CreateNamespaceTask.this.request.getReceiveScript() != null ? CreateNamespaceTask.this.request.getReceiveScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", UpdateNamespaceTask.this.request.getTransactionSetting() != null ? UpdateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("receiveScript", UpdateNamespaceTask.this.request.getReceiveScript() != null ? UpdateNamespaceTask.this.request.getReceiveScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCategoryModelMastersTask
    extends Gs2RestSessionTask<DescribeCategoryModelMastersResult> {
        private DescribeCategoryModelMastersRequest request;

        public DescribeCategoryModelMastersTask(DescribeCategoryModelMastersRequest request, AsyncAction<AsyncResult<DescribeCategoryModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCategoryModelMastersResult parse(JsonNode data) {
            return DescribeCategoryModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateCategoryModelMasterTask
    extends Gs2RestSessionTask<CreateCategoryModelMasterResult> {
        private CreateCategoryModelMasterRequest request;

        public CreateCategoryModelMasterTask(CreateCategoryModelMasterRequest request, AsyncAction<AsyncResult<CreateCategoryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateCategoryModelMasterResult parse(JsonNode data) {
            return CreateCategoryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateCategoryModelMasterTask.this.request.getName());
                    this.put("description", CreateCategoryModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateCategoryModelMasterTask.this.request.getMetadata());
                    this.put("rewardIntervalMinutes", CreateCategoryModelMasterTask.this.request.getRewardIntervalMinutes());
                    this.put("defaultMaximumIdleMinutes", CreateCategoryModelMasterTask.this.request.getDefaultMaximumIdleMinutes());
                    this.put("acquireActions", CreateCategoryModelMasterTask.this.request.getAcquireActions() == null ? new ArrayList() : CreateCategoryModelMasterTask.this.request.getAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("idlePeriodScheduleId", CreateCategoryModelMasterTask.this.request.getIdlePeriodScheduleId());
                    this.put("receivePeriodScheduleId", CreateCategoryModelMasterTask.this.request.getReceivePeriodScheduleId());
                    this.put("contextStack", CreateCategoryModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCategoryModelMasterTask
    extends Gs2RestSessionTask<GetCategoryModelMasterResult> {
        private GetCategoryModelMasterRequest request;

        public GetCategoryModelMasterTask(GetCategoryModelMasterRequest request, AsyncAction<AsyncResult<GetCategoryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCategoryModelMasterResult parse(JsonNode data) {
            return GetCategoryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCategoryModelMasterTask
    extends Gs2RestSessionTask<UpdateCategoryModelMasterResult> {
        private UpdateCategoryModelMasterRequest request;

        public UpdateCategoryModelMasterTask(UpdateCategoryModelMasterRequest request, AsyncAction<AsyncResult<UpdateCategoryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCategoryModelMasterResult parse(JsonNode data) {
            return UpdateCategoryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateCategoryModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateCategoryModelMasterTask.this.request.getMetadata());
                    this.put("rewardIntervalMinutes", UpdateCategoryModelMasterTask.this.request.getRewardIntervalMinutes());
                    this.put("defaultMaximumIdleMinutes", UpdateCategoryModelMasterTask.this.request.getDefaultMaximumIdleMinutes());
                    this.put("acquireActions", UpdateCategoryModelMasterTask.this.request.getAcquireActions() == null ? new ArrayList() : UpdateCategoryModelMasterTask.this.request.getAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("idlePeriodScheduleId", UpdateCategoryModelMasterTask.this.request.getIdlePeriodScheduleId());
                    this.put("receivePeriodScheduleId", UpdateCategoryModelMasterTask.this.request.getReceivePeriodScheduleId());
                    this.put("contextStack", UpdateCategoryModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteCategoryModelMasterTask
    extends Gs2RestSessionTask<DeleteCategoryModelMasterResult> {
        private DeleteCategoryModelMasterRequest request;

        public DeleteCategoryModelMasterTask(DeleteCategoryModelMasterRequest request, AsyncAction<AsyncResult<DeleteCategoryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteCategoryModelMasterResult parse(JsonNode data) {
            return DeleteCategoryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCategoryModelsTask
    extends Gs2RestSessionTask<DescribeCategoryModelsResult> {
        private DescribeCategoryModelsRequest request;

        public DescribeCategoryModelsTask(DescribeCategoryModelsRequest request, AsyncAction<AsyncResult<DescribeCategoryModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCategoryModelsResult parse(JsonNode data) {
            return DescribeCategoryModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCategoryModelTask
    extends Gs2RestSessionTask<GetCategoryModelResult> {
        private GetCategoryModelRequest request;

        public GetCategoryModelTask(GetCategoryModelRequest request, AsyncAction<AsyncResult<GetCategoryModelResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCategoryModelResult parse(JsonNode data) {
            return GetCategoryModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeStatusesTask
    extends Gs2RestSessionTask<DescribeStatusesResult> {
        private DescribeStatusesRequest request;

        public DescribeStatusesTask(DescribeStatusesRequest request, AsyncAction<AsyncResult<DescribeStatusesResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeStatusesResult parse(JsonNode data) {
            return DescribeStatusesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeStatusesByUserIdTask
    extends Gs2RestSessionTask<DescribeStatusesByUserIdResult> {
        private DescribeStatusesByUserIdRequest request;

        public DescribeStatusesByUserIdTask(DescribeStatusesByUserIdRequest request, AsyncAction<AsyncResult<DescribeStatusesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeStatusesByUserIdResult parse(JsonNode data) {
            return DescribeStatusesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetStatusTask
    extends Gs2RestSessionTask<GetStatusResult> {
        private GetStatusRequest request;

        public GetStatusTask(GetStatusRequest request, AsyncAction<AsyncResult<GetStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStatusResult parse(JsonNode data) {
            return GetStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetStatusByUserIdTask
    extends Gs2RestSessionTask<GetStatusByUserIdResult> {
        private GetStatusByUserIdRequest request;

        public GetStatusByUserIdTask(GetStatusByUserIdRequest request, AsyncAction<AsyncResult<GetStatusByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStatusByUserIdResult parse(JsonNode data) {
            return GetStatusByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class PredictionTask
    extends Gs2RestSessionTask<PredictionResult> {
        private PredictionRequest request;

        public PredictionTask(PredictionRequest request, AsyncAction<AsyncResult<PredictionResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PredictionResult parse(JsonNode data) {
            return PredictionResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/model/{categoryName}/prediction";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PredictionTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class PredictionByUserIdTask
    extends Gs2RestSessionTask<PredictionByUserIdResult> {
        private PredictionByUserIdRequest request;

        public PredictionByUserIdTask(PredictionByUserIdRequest request, AsyncAction<AsyncResult<PredictionByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PredictionByUserIdResult parse(JsonNode data) {
            return PredictionByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{categoryName}/prediction";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PredictionByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ReceiveTask
    extends Gs2RestSessionTask<ReceiveResult> {
        private ReceiveRequest request;

        public ReceiveTask(ReceiveRequest request, AsyncAction<AsyncResult<ReceiveResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReceiveResult parse(JsonNode data) {
            return ReceiveResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/status/model/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", ReceiveTask.this.request.getConfig() == null ? new ArrayList() : ReceiveTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ReceiveTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ReceiveByUserIdTask
    extends Gs2RestSessionTask<ReceiveByUserIdResult> {
        private ReceiveByUserIdRequest request;

        public ReceiveByUserIdTask(ReceiveByUserIdRequest request, AsyncAction<AsyncResult<ReceiveByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ReceiveByUserIdResult parse(JsonNode data) {
            return ReceiveByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{categoryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("config", ReceiveByUserIdTask.this.request.getConfig() == null ? new ArrayList() : ReceiveByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", ReceiveByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class IncreaseMaximumIdleMinutesByUserIdTask
    extends Gs2RestSessionTask<IncreaseMaximumIdleMinutesByUserIdResult> {
        private IncreaseMaximumIdleMinutesByUserIdRequest request;

        public IncreaseMaximumIdleMinutesByUserIdTask(IncreaseMaximumIdleMinutesByUserIdRequest request, AsyncAction<AsyncResult<IncreaseMaximumIdleMinutesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public IncreaseMaximumIdleMinutesByUserIdResult parse(JsonNode data) {
            return IncreaseMaximumIdleMinutesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{categoryName}/maximumIdle/increase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("increaseMinutes", IncreaseMaximumIdleMinutesByUserIdTask.this.request.getIncreaseMinutes());
                    this.put("contextStack", IncreaseMaximumIdleMinutesByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DecreaseMaximumIdleMinutesByUserIdTask
    extends Gs2RestSessionTask<DecreaseMaximumIdleMinutesByUserIdResult> {
        private DecreaseMaximumIdleMinutesByUserIdRequest request;

        public DecreaseMaximumIdleMinutesByUserIdTask(DecreaseMaximumIdleMinutesByUserIdRequest request, AsyncAction<AsyncResult<DecreaseMaximumIdleMinutesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DecreaseMaximumIdleMinutesByUserIdResult parse(JsonNode data) {
            return DecreaseMaximumIdleMinutesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/status/model/{categoryName}/maximumIdle/decrease";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{categoryName}", this.request.getCategoryName() == null || this.request.getCategoryName().length() == 0 ? "null" : String.valueOf(this.request.getCategoryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("decreaseMinutes", DecreaseMaximumIdleMinutesByUserIdTask.this.request.getDecreaseMinutes());
                    this.put("contextStack", DecreaseMaximumIdleMinutesByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class IncreaseMaximumIdleMinutesByStampSheetTask
    extends Gs2RestSessionTask<IncreaseMaximumIdleMinutesByStampSheetResult> {
        private IncreaseMaximumIdleMinutesByStampSheetRequest request;

        public IncreaseMaximumIdleMinutesByStampSheetTask(IncreaseMaximumIdleMinutesByStampSheetRequest request, AsyncAction<AsyncResult<IncreaseMaximumIdleMinutesByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public IncreaseMaximumIdleMinutesByStampSheetResult parse(JsonNode data) {
            return IncreaseMaximumIdleMinutesByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/stamp/status/maximumIdleMinutes/add";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", IncreaseMaximumIdleMinutesByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", IncreaseMaximumIdleMinutesByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", IncreaseMaximumIdleMinutesByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DecreaseMaximumIdleMinutesByStampTaskTask
    extends Gs2RestSessionTask<DecreaseMaximumIdleMinutesByStampTaskResult> {
        private DecreaseMaximumIdleMinutesByStampTaskRequest request;

        public DecreaseMaximumIdleMinutesByStampTaskTask(DecreaseMaximumIdleMinutesByStampTaskRequest request, AsyncAction<AsyncResult<DecreaseMaximumIdleMinutesByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DecreaseMaximumIdleMinutesByStampTaskResult parse(JsonNode data) {
            return DecreaseMaximumIdleMinutesByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/stamp/status/maximumIdleMinutes/sub";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", DecreaseMaximumIdleMinutesByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", DecreaseMaximumIdleMinutesByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", DecreaseMaximumIdleMinutesByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentCategoryMasterTask
    extends Gs2RestSessionTask<GetCurrentCategoryMasterResult> {
        private GetCurrentCategoryMasterRequest request;

        public GetCurrentCategoryMasterTask(GetCurrentCategoryMasterRequest request, AsyncAction<AsyncResult<GetCurrentCategoryMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentCategoryMasterResult parse(JsonNode data) {
            return GetCurrentCategoryMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentCategoryMasterTask
    extends Gs2RestSessionTask<UpdateCurrentCategoryMasterResult> {
        private UpdateCurrentCategoryMasterRequest request;

        public UpdateCurrentCategoryMasterTask(UpdateCurrentCategoryMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentCategoryMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentCategoryMasterResult parse(JsonNode data) {
            return UpdateCurrentCategoryMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentCategoryMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentCategoryMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentCategoryMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentCategoryMasterFromGitHubResult> {
        private UpdateCurrentCategoryMasterFromGitHubRequest request;

        public UpdateCurrentCategoryMasterFromGitHubTask(UpdateCurrentCategoryMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentCategoryMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2IdleRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentCategoryMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentCategoryMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "idle").replace("{region}", Gs2IdleRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentCategoryMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentCategoryMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentCategoryMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

