/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.core.model;

import io.gs2.core.model.IGs2Credential;
import org.apache.http.client.methods.HttpUriRequest;

public class BasicGs2Credential
implements IGs2Credential {
    String clientId;
    String clientSecret;
    String projectToken;

    public BasicGs2Credential(String clientId, String clientSecret) {
        if (clientId == null || clientSecret == null) {
            throw new IllegalArgumentException("invalid credential");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getProjectToken() {
        return this.projectToken;
    }

    @Override
    public void setProjectToken(String projectToken) {
        this.projectToken = projectToken;
    }

    @Override
    public void authorized(HttpUriRequest request) {
        request.setHeader("X-GS2-CLIENT-ID", this.getClientId());
        if (this.getProjectToken() != null) {
            request.setHeader("Authorization", "Bearer " + this.getProjectToken());
        }
    }
}

