/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.adReward;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.adReward.request.AcquirePointByStampSheetRequest;
import io.gs2.adReward.request.AcquirePointByUserIdRequest;
import io.gs2.adReward.request.ConsumePointByStampTaskRequest;
import io.gs2.adReward.request.ConsumePointByUserIdRequest;
import io.gs2.adReward.request.ConsumePointRequest;
import io.gs2.adReward.request.CreateNamespaceRequest;
import io.gs2.adReward.request.DeleteNamespaceRequest;
import io.gs2.adReward.request.DeletePointByUserIdRequest;
import io.gs2.adReward.request.DescribeNamespacesRequest;
import io.gs2.adReward.request.GetNamespaceRequest;
import io.gs2.adReward.request.GetNamespaceStatusRequest;
import io.gs2.adReward.request.GetPointByUserIdRequest;
import io.gs2.adReward.request.GetPointRequest;
import io.gs2.adReward.request.UpdateNamespaceRequest;
import io.gs2.adReward.result.AcquirePointByStampSheetResult;
import io.gs2.adReward.result.AcquirePointByUserIdResult;
import io.gs2.adReward.result.ConsumePointByStampTaskResult;
import io.gs2.adReward.result.ConsumePointByUserIdResult;
import io.gs2.adReward.result.ConsumePointResult;
import io.gs2.adReward.result.CreateNamespaceResult;
import io.gs2.adReward.result.DeleteNamespaceResult;
import io.gs2.adReward.result.DeletePointByUserIdResult;
import io.gs2.adReward.result.DescribeNamespacesResult;
import io.gs2.adReward.result.GetNamespaceResult;
import io.gs2.adReward.result.GetNamespaceStatusResult;
import io.gs2.adReward.result.GetPointByUserIdResult;
import io.gs2.adReward.result.GetPointResult;
import io.gs2.adReward.result.UpdateNamespaceResult;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2AdRewardRestClient
extends AbstractGs2Client<Gs2AdRewardRestClient> {
    public Gs2AdRewardRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getPointAsync(GetPointRequest request, AsyncAction<AsyncResult<GetPointResult>> callback) {
        GetPointTask task = new GetPointTask(request, callback);
        this.session.execute(task);
    }

    public GetPointResult getPoint(GetPointRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getPointAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetPointResult)resultAsyncResult[0].getResult();
    }

    public void getPointByUserIdAsync(GetPointByUserIdRequest request, AsyncAction<AsyncResult<GetPointByUserIdResult>> callback) {
        GetPointByUserIdTask task = new GetPointByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetPointByUserIdResult getPointByUserId(GetPointByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getPointByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetPointByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void acquirePointByUserIdAsync(AcquirePointByUserIdRequest request, AsyncAction<AsyncResult<AcquirePointByUserIdResult>> callback) {
        AcquirePointByUserIdTask task = new AcquirePointByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public AcquirePointByUserIdResult acquirePointByUserId(AcquirePointByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acquirePointByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcquirePointByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void consumePointAsync(ConsumePointRequest request, AsyncAction<AsyncResult<ConsumePointResult>> callback) {
        ConsumePointTask task = new ConsumePointTask(request, callback);
        this.session.execute(task);
    }

    public ConsumePointResult consumePoint(ConsumePointRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.consumePointAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ConsumePointResult)resultAsyncResult[0].getResult();
    }

    public void consumePointByUserIdAsync(ConsumePointByUserIdRequest request, AsyncAction<AsyncResult<ConsumePointByUserIdResult>> callback) {
        ConsumePointByUserIdTask task = new ConsumePointByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ConsumePointByUserIdResult consumePointByUserId(ConsumePointByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.consumePointByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ConsumePointByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deletePointByUserIdAsync(DeletePointByUserIdRequest request, AsyncAction<AsyncResult<DeletePointByUserIdResult>> callback) {
        DeletePointByUserIdTask task = new DeletePointByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeletePointByUserIdResult deletePointByUserId(DeletePointByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deletePointByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeletePointByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void consumePointByStampTaskAsync(ConsumePointByStampTaskRequest request, AsyncAction<AsyncResult<ConsumePointByStampTaskResult>> callback) {
        ConsumePointByStampTaskTask task = new ConsumePointByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public ConsumePointByStampTaskResult consumePointByStampTask(ConsumePointByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.consumePointByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ConsumePointByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void acquirePointByStampSheetAsync(AcquirePointByStampSheetRequest request, AsyncAction<AsyncResult<AcquirePointByStampSheetResult>> callback) {
        AcquirePointByStampSheetTask task = new AcquirePointByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public AcquirePointByStampSheetResult acquirePointByStampSheet(AcquirePointByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.acquirePointByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AcquirePointByStampSheetResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("admob", CreateNamespaceTask.this.request.getAdmob() != null ? CreateNamespaceTask.this.request.getAdmob().toJson() : null);
                    this.put("unityAd", CreateNamespaceTask.this.request.getUnityAd() != null ? CreateNamespaceTask.this.request.getUnityAd().toJson() : null);
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("changePointNotification", CreateNamespaceTask.this.request.getChangePointNotification() != null ? CreateNamespaceTask.this.request.getChangePointNotification().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("admob", UpdateNamespaceTask.this.request.getAdmob() != null ? UpdateNamespaceTask.this.request.getAdmob().toJson() : null);
                    this.put("unityAd", UpdateNamespaceTask.this.request.getUnityAd() != null ? UpdateNamespaceTask.this.request.getUnityAd().toJson() : null);
                    this.put("changePointNotification", UpdateNamespaceTask.this.request.getChangePointNotification() != null ? UpdateNamespaceTask.this.request.getChangePointNotification().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetPointTask
    extends Gs2RestSessionTask<GetPointResult> {
        private GetPointRequest request;

        public GetPointTask(GetPointRequest request, AsyncAction<AsyncResult<GetPointResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetPointResult parse(JsonNode data) {
            return GetPointResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/point";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetPointByUserIdTask
    extends Gs2RestSessionTask<GetPointByUserIdResult> {
        private GetPointByUserIdRequest request;

        public GetPointByUserIdTask(GetPointByUserIdRequest request, AsyncAction<AsyncResult<GetPointByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetPointByUserIdResult parse(JsonNode data) {
            return GetPointByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/point";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AcquirePointByUserIdTask
    extends Gs2RestSessionTask<AcquirePointByUserIdResult> {
        private AcquirePointByUserIdRequest request;

        public AcquirePointByUserIdTask(AcquirePointByUserIdRequest request, AsyncAction<AsyncResult<AcquirePointByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcquirePointByUserIdResult parse(JsonNode data) {
            return AcquirePointByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/point/acquire";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("point", AcquirePointByUserIdTask.this.request.getPoint());
                    this.put("contextStack", AcquirePointByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ConsumePointTask
    extends Gs2RestSessionTask<ConsumePointResult> {
        private ConsumePointRequest request;

        public ConsumePointTask(ConsumePointRequest request, AsyncAction<AsyncResult<ConsumePointResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ConsumePointResult parse(JsonNode data) {
            return ConsumePointResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/point/consume";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("point", ConsumePointTask.this.request.getPoint());
                    this.put("contextStack", ConsumePointTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ConsumePointByUserIdTask
    extends Gs2RestSessionTask<ConsumePointByUserIdResult> {
        private ConsumePointByUserIdRequest request;

        public ConsumePointByUserIdTask(ConsumePointByUserIdRequest request, AsyncAction<AsyncResult<ConsumePointByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ConsumePointByUserIdResult parse(JsonNode data) {
            return ConsumePointByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/point/consume";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("point", ConsumePointByUserIdTask.this.request.getPoint());
                    this.put("contextStack", ConsumePointByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeletePointByUserIdTask
    extends Gs2RestSessionTask<DeletePointByUserIdResult> {
        private DeletePointByUserIdRequest request;

        public DeletePointByUserIdTask(DeletePointByUserIdRequest request, AsyncAction<AsyncResult<DeletePointByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeletePointByUserIdResult parse(JsonNode data) {
            return DeletePointByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/point/delete";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DeletePointByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class ConsumePointByStampTaskTask
    extends Gs2RestSessionTask<ConsumePointByStampTaskResult> {
        private ConsumePointByStampTaskRequest request;

        public ConsumePointByStampTaskTask(ConsumePointByStampTaskRequest request, AsyncAction<AsyncResult<ConsumePointByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ConsumePointByStampTaskResult parse(JsonNode data) {
            return ConsumePointByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/point/consume";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", ConsumePointByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", ConsumePointByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", ConsumePointByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AcquirePointByStampSheetTask
    extends Gs2RestSessionTask<AcquirePointByStampSheetResult> {
        private AcquirePointByStampSheetRequest request;

        public AcquirePointByStampSheetTask(AcquirePointByStampSheetRequest request, AsyncAction<AsyncResult<AcquirePointByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2AdRewardRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AcquirePointByStampSheetResult parse(JsonNode data) {
            return AcquirePointByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "ad-reward").replace("{region}", Gs2AdRewardRestClient.this.session.getRegion().getName()) + "/point/acquire";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", AcquirePointByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", AcquirePointByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", AcquirePointByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

