/*
 * Copyright 2016 Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.gs2.script.result;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import io.gs2.core.model.*;
import io.gs2.script.model.*;

@SuppressWarnings("serial")
@JsonIgnoreProperties(ignoreUnknown=true)
public class InvokeScriptResult implements IResult, Serializable {
    private Integer code;
    private String result;
    private Integer executeTime;
    private Integer charged;
    private List<String> output;

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public InvokeScriptResult withCode(Integer code) {
		this.code = code;
		return this;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public InvokeScriptResult withResult(String result) {
		this.result = result;
		return this;
	}

	public Integer getExecuteTime() {
		return executeTime;
	}

	public void setExecuteTime(Integer executeTime) {
		this.executeTime = executeTime;
	}

	public InvokeScriptResult withExecuteTime(Integer executeTime) {
		this.executeTime = executeTime;
		return this;
	}

	public Integer getCharged() {
		return charged;
	}

	public void setCharged(Integer charged) {
		this.charged = charged;
	}

	public InvokeScriptResult withCharged(Integer charged) {
		this.charged = charged;
		return this;
	}

	public List<String> getOutput() {
		return output;
	}

	public void setOutput(List<String> output) {
		this.output = output;
	}

	public InvokeScriptResult withOutput(List<String> output) {
		this.output = output;
		return this;
	}

    public static InvokeScriptResult fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new InvokeScriptResult()
            .withCode(data.get("code") == null || data.get("code").isNull() ? null : data.get("code").intValue())
            .withResult(data.get("result") == null || data.get("result").isNull() ? null : data.get("result").asText())
            .withExecuteTime(data.get("executeTime") == null || data.get("executeTime").isNull() ? null : data.get("executeTime").intValue())
            .withCharged(data.get("charged") == null || data.get("charged").isNull() ? null : data.get("charged").intValue())
            .withOutput(data.get("output") == null || data.get("output").isNull() ? new ArrayList<String>() :
                StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("output").elements(), Spliterator.NONNULL), false).map(item -> {
                    return item.asText();
                }
            ).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree(
            new HashMap<String, Object>() {{
                put("code", getCode());
                put("result", getResult());
                put("executeTime", getExecuteTime());
                put("charged", getCharged());
                put("output", getOutput() == null ? new ArrayList<String>() :
                    getOutput().stream().map(item -> {
                        return item;
                    }
                ).collect(Collectors.toList()));
            }}
        );
    }
}