/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.identifier.request.AttachSecurityPolicyRequest;
import io.gs2.identifier.request.CreateIdentifierRequest;
import io.gs2.identifier.request.CreateSecurityPolicyRequest;
import io.gs2.identifier.request.CreateUserRequest;
import io.gs2.identifier.request.DeleteIdentifierRequest;
import io.gs2.identifier.request.DeleteSecurityPolicyRequest;
import io.gs2.identifier.request.DeleteUserRequest;
import io.gs2.identifier.request.DescribeCommonSecurityPoliciesRequest;
import io.gs2.identifier.request.DescribeIdentifiersRequest;
import io.gs2.identifier.request.DescribeSecurityPoliciesRequest;
import io.gs2.identifier.request.DescribeUsersRequest;
import io.gs2.identifier.request.DetachSecurityPolicyRequest;
import io.gs2.identifier.request.GetHasSecurityPolicyRequest;
import io.gs2.identifier.request.GetIdentifierRequest;
import io.gs2.identifier.request.GetSecurityPolicyRequest;
import io.gs2.identifier.request.GetUserRequest;
import io.gs2.identifier.request.LoginRequest;
import io.gs2.identifier.request.UpdateSecurityPolicyRequest;
import io.gs2.identifier.request.UpdateUserRequest;
import io.gs2.identifier.result.AttachSecurityPolicyResult;
import io.gs2.identifier.result.CreateIdentifierResult;
import io.gs2.identifier.result.CreateSecurityPolicyResult;
import io.gs2.identifier.result.CreateUserResult;
import io.gs2.identifier.result.DeleteIdentifierResult;
import io.gs2.identifier.result.DeleteSecurityPolicyResult;
import io.gs2.identifier.result.DeleteUserResult;
import io.gs2.identifier.result.DescribeCommonSecurityPoliciesResult;
import io.gs2.identifier.result.DescribeIdentifiersResult;
import io.gs2.identifier.result.DescribeSecurityPoliciesResult;
import io.gs2.identifier.result.DescribeUsersResult;
import io.gs2.identifier.result.DetachSecurityPolicyResult;
import io.gs2.identifier.result.GetHasSecurityPolicyResult;
import io.gs2.identifier.result.GetIdentifierResult;
import io.gs2.identifier.result.GetSecurityPolicyResult;
import io.gs2.identifier.result.GetUserResult;
import io.gs2.identifier.result.LoginResult;
import io.gs2.identifier.result.UpdateSecurityPolicyResult;
import io.gs2.identifier.result.UpdateUserResult;
import io.gs2.model.IGs2Credential;
import io.gs2.model.Region;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2IdentifierRestClient
extends AbstractGs2Client<Gs2IdentifierRestClient> {
    public static String ENDPOINT = "identifier";

    public Gs2IdentifierRestClient(IGs2Credential credential) {
        super(credential);
    }

    public Gs2IdentifierRestClient(IGs2Credential credential, Region region) {
        super(credential, region);
    }

    public Gs2IdentifierRestClient(IGs2Credential credential, String region) {
        super(credential, region);
    }

    public DescribeUsersResult describeUsers(DescribeUsersRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FUserFunctionHandler.describeUsers";
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeUsersResult)this.doRequest((HttpUriRequest)http, DescribeUsersResult.class);
    }

    public CreateUserResult createUser(CreateUserRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FUserFunctionHandler.createUser";
        String name = null;
        if (request.getName() != null) {
            name = request.getName();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (name != null) {
            _body.put("name", name);
        }
        if (description != null) {
            _body.put("description", description);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateUserResult)this.doRequest((HttpUriRequest)http, CreateUserResult.class);
    }

    public UpdateUserResult updateUser(UpdateUserRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FUserFunctionHandler.updateUser";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (description != null) {
            _body.put("description", description);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateUserResult)this.doRequest((HttpUriRequest)http, UpdateUserResult.class);
    }

    public GetUserResult getUser(GetUserRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FUserFunctionHandler.getUser";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetUserResult)this.doRequest((HttpUriRequest)http, GetUserResult.class);
    }

    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FUserFunctionHandler.deleteUser";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DeleteUserResult)this.doRequest((HttpUriRequest)http, DeleteUserResult.class);
    }

    public DescribeSecurityPoliciesResult describeSecurityPolicies(DescribeSecurityPoliciesRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FSecurityPolicyFunctionHandler.describeSecurityPolicies";
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeSecurityPoliciesResult)this.doRequest((HttpUriRequest)http, DescribeSecurityPoliciesResult.class);
    }

    public DescribeCommonSecurityPoliciesResult describeCommonSecurityPolicies(DescribeCommonSecurityPoliciesRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FSecurityPolicyFunctionHandler.describeCommonSecurityPolicies";
        String ownerId = null;
        if (request.getOwnerId() != null) {
            ownerId = request.getOwnerId();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeCommonSecurityPoliciesResult)this.doRequest((HttpUriRequest)http, DescribeCommonSecurityPoliciesResult.class);
    }

    public CreateSecurityPolicyResult createSecurityPolicy(CreateSecurityPolicyRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FSecurityPolicyFunctionHandler.createSecurityPolicy";
        String name = null;
        if (request.getName() != null) {
            name = request.getName();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String policy = null;
        if (request.getPolicy() != null) {
            policy = request.getPolicy();
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (name != null) {
            _body.put("name", name);
        }
        if (description != null) {
            _body.put("description", description);
        }
        if (policy != null) {
            _body.put("policy", policy);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateSecurityPolicyResult)this.doRequest((HttpUriRequest)http, CreateSecurityPolicyResult.class);
    }

    public UpdateSecurityPolicyResult updateSecurityPolicy(UpdateSecurityPolicyRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FSecurityPolicyFunctionHandler.updateSecurityPolicy";
        String securityPolicyName = null;
        if (request.getSecurityPolicyName() != null) {
            securityPolicyName = request.getSecurityPolicyName();
        }
        String description = null;
        if (request.getDescription() != null) {
            description = request.getDescription();
        }
        String policy = null;
        if (request.getPolicy() != null) {
            policy = request.getPolicy();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (securityPolicyName != null) {
            _queryString.add(new BasicNameValuePair("securityPolicyName", String.valueOf(securityPolicyName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (description != null) {
            _body.put("description", description);
        }
        if (policy != null) {
            _body.put("policy", policy);
        }
        HttpPut http = this.createHttpPut(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateSecurityPolicyResult)this.doRequest((HttpUriRequest)http, UpdateSecurityPolicyResult.class);
    }

    public GetSecurityPolicyResult getSecurityPolicy(GetSecurityPolicyRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FSecurityPolicyFunctionHandler.getSecurityPolicy";
        String securityPolicyName = null;
        if (request.getSecurityPolicyName() != null) {
            securityPolicyName = request.getSecurityPolicyName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (securityPolicyName != null) {
            _queryString.add(new BasicNameValuePair("securityPolicyName", String.valueOf(securityPolicyName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetSecurityPolicyResult)this.doRequest((HttpUriRequest)http, GetSecurityPolicyResult.class);
    }

    public DeleteSecurityPolicyResult deleteSecurityPolicy(DeleteSecurityPolicyRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FSecurityPolicyFunctionHandler.deleteSecurityPolicy";
        String securityPolicyName = null;
        if (request.getSecurityPolicyName() != null) {
            securityPolicyName = request.getSecurityPolicyName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (securityPolicyName != null) {
            _queryString.add(new BasicNameValuePair("securityPolicyName", String.valueOf(securityPolicyName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DeleteSecurityPolicyResult)this.doRequest((HttpUriRequest)http, DeleteSecurityPolicyResult.class);
    }

    public DescribeIdentifiersResult describeIdentifiers(DescribeIdentifiersRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FIdentifierFunctionHandler.describeIdentifiers";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        String pageToken = String.valueOf(request.getPageToken());
        String limit = String.valueOf(request.getLimit());
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (pageToken != null) {
            _queryString.add(new BasicNameValuePair("pageToken", String.valueOf(pageToken)));
        }
        if (limit != null) {
            _queryString.add(new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeIdentifiersResult)this.doRequest((HttpUriRequest)http, DescribeIdentifiersResult.class);
    }

    public CreateIdentifierResult createIdentifier(CreateIdentifierRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FIdentifierFunctionHandler.createIdentifier";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateIdentifierResult)this.doRequest((HttpUriRequest)http, CreateIdentifierResult.class);
    }

    public GetIdentifierResult getIdentifier(GetIdentifierRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FIdentifierFunctionHandler.getIdentifier";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        String clientId = null;
        if (request.getClientId() != null) {
            clientId = request.getClientId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (clientId != null) {
            _queryString.add(new BasicNameValuePair("clientId", String.valueOf(clientId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetIdentifierResult)this.doRequest((HttpUriRequest)http, GetIdentifierResult.class);
    }

    public DeleteIdentifierResult deleteIdentifier(DeleteIdentifierRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FIdentifierFunctionHandler.deleteIdentifier";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        String clientId = null;
        if (request.getClientId() != null) {
            clientId = request.getClientId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (clientId != null) {
            _queryString.add(new BasicNameValuePair("clientId", String.valueOf(clientId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DeleteIdentifierResult)this.doRequest((HttpUriRequest)http, DeleteIdentifierResult.class);
    }

    public GetHasSecurityPolicyResult getHasSecurityPolicy(GetHasSecurityPolicyRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FAttachSecurityPolicyFunctionHandler.getHasSecurityPolicy";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpGet http = this.createHttpGet(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetHasSecurityPolicyResult)this.doRequest((HttpUriRequest)http, GetHasSecurityPolicyResult.class);
    }

    public AttachSecurityPolicyResult attachSecurityPolicy(AttachSecurityPolicyRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FAttachSecurityPolicyFunctionHandler.attachSecurityPolicy";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        String securityPolicyId = null;
        if (request.getSecurityPolicyId() != null) {
            securityPolicyId = request.getSecurityPolicyId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (securityPolicyId != null) {
            _body.put("securityPolicyId", securityPolicyId);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (AttachSecurityPolicyResult)this.doRequest((HttpUriRequest)http, AttachSecurityPolicyResult.class);
    }

    public DetachSecurityPolicyResult detachSecurityPolicy(DetachSecurityPolicyRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FAttachSecurityPolicyFunctionHandler.detachSecurityPolicy";
        String userName = null;
        if (request.getUserName() != null) {
            userName = request.getUserName();
        }
        String securityPolicyId = null;
        if (request.getSecurityPolicyId() != null) {
            securityPolicyId = request.getSecurityPolicyId();
        }
        ArrayList<BasicNameValuePair> _queryString = new ArrayList<BasicNameValuePair>();
        if (userName != null) {
            _queryString.add(new BasicNameValuePair("userName", String.valueOf(userName)));
        }
        if (securityPolicyId != null) {
            _queryString.add(new BasicNameValuePair("securityPolicyId", String.valueOf(securityPolicyId)));
        }
        if (_queryString.size() > 0) {
            url = url + "&" + URLEncodedUtils.format(_queryString, (String)"UTF-8");
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        HttpDelete http = this.createHttpDelete(url, ENDPOINT);
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DetachSecurityPolicyResult)this.doRequest((HttpUriRequest)http, DetachSecurityPolicyResult.class);
    }

    public LoginResult login(LoginRequest request) {
        String url = "https://asia-northeast1-gs2-on-gcp.cloudfunctions.net/identifier-handler?handler=gs2_identifier%2Fhandler%2FProjectTokenFunctionHandler.login";
        String clientId = null;
        if (request.getClientId() != null) {
            clientId = request.getClientId();
        }
        String clientSecret = null;
        if (request.getClientSecret() != null) {
            clientSecret = request.getClientSecret();
        }
        ObjectNode _body = JsonNodeFactory.instance.objectNode();
        if (clientId != null) {
            _body.put("clientId", clientId);
        }
        if (clientSecret != null) {
            _body.put("clientSecret", clientSecret);
        }
        HttpPost http = this.createHttpPost(url, ENDPOINT, _body.toString());
        if (request.getRequestId() != null) {
            http.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (LoginResult)this.doRequest((HttpUriRequest)http, LoginResult.class);
    }
}

