/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.identifier;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.identifier.control.AttachSecurityPolicyRequest;
import io.gs2.identifier.control.CreateIdentifierRequest;
import io.gs2.identifier.control.CreateIdentifierResult;
import io.gs2.identifier.control.CreateSecurityPolicyRequest;
import io.gs2.identifier.control.CreateSecurityPolicyResult;
import io.gs2.identifier.control.CreateUserRequest;
import io.gs2.identifier.control.CreateUserResult;
import io.gs2.identifier.control.DeleteIdentifierRequest;
import io.gs2.identifier.control.DeleteSecurityPolicyRequest;
import io.gs2.identifier.control.DeleteUserRequest;
import io.gs2.identifier.control.DescribeCommonSecurityPolicyRequest;
import io.gs2.identifier.control.DescribeCommonSecurityPolicyResult;
import io.gs2.identifier.control.DescribeIdentifierRequest;
import io.gs2.identifier.control.DescribeIdentifierResult;
import io.gs2.identifier.control.DescribeSecurityPolicyRequest;
import io.gs2.identifier.control.DescribeSecurityPolicyResult;
import io.gs2.identifier.control.DescribeUserRequest;
import io.gs2.identifier.control.DescribeUserResult;
import io.gs2.identifier.control.DetachSecurityPolicyRequest;
import io.gs2.identifier.control.GetIdentifierRequest;
import io.gs2.identifier.control.GetIdentifierResult;
import io.gs2.identifier.control.GetSecurityPolicyRequest;
import io.gs2.identifier.control.GetSecurityPolicyResult;
import io.gs2.identifier.control.GetUserRequest;
import io.gs2.identifier.control.GetUserResult;
import io.gs2.identifier.control.HasSecurityPolicyRequest;
import io.gs2.identifier.control.HasSecurityPolicyResult;
import io.gs2.identifier.control.UpdateSecurityPolicyRequest;
import io.gs2.identifier.control.UpdateSecurityPolicyResult;
import io.gs2.model.IGs2Credential;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2IdentifierClient
extends AbstractGs2Client<Gs2IdentifierClient> {
    public static String ENDPOINT = "identifier";

    public Gs2IdentifierClient(IGs2Credential credential) {
        super(credential);
    }

    public void attachSecurityPolicy(AttachSecurityPolicyRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("securityPolicyId", request.getSecurityPolicyId());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "/securityPolicy", this.credential, ENDPOINT, "Gs2Identifier", "AttachSecurityPolicy", body.toString());
        this.doRequest((HttpUriRequest)put, null);
    }

    public CreateIdentifierResult createIdentifier(CreateIdentifierRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "/identifier", this.credential, ENDPOINT, "Gs2Identifier", "CreateIdentifier", body.toString());
        return (CreateIdentifierResult)this.doRequest((HttpUriRequest)post, CreateIdentifierResult.class);
    }

    public CreateSecurityPolicyResult createSecurityPolicy(CreateSecurityPolicyRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("policy", request.getPolicy()).put("name", request.getName());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/securityPolicy", this.credential, ENDPOINT, "Gs2Identifier", "CreateSecurityPolicy", body.toString());
        return (CreateSecurityPolicyResult)this.doRequest((HttpUriRequest)post, CreateSecurityPolicyResult.class);
    }

    public CreateUserResult createUser(CreateUserRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/user", this.credential, ENDPOINT, "Gs2Identifier", "CreateUser", body.toString());
        return (CreateUserResult)this.doRequest((HttpUriRequest)post, CreateUserResult.class);
    }

    public void deleteIdentifier(DeleteIdentifierRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "/identifier/" + (request.getIdentifierId() == null ? "null" : request.getIdentifierId()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Identifier", "DeleteIdentifier");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteSecurityPolicy(DeleteSecurityPolicyRequest request) {
        String url = "https://{service}.{region}.gs2.io/securityPolicy/" + (request.getSecurityPolicyName() == null ? "null" : request.getSecurityPolicyName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Identifier", "DeleteSecurityPolicy");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteUser(DeleteUserRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Identifier", "DeleteUser");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeCommonSecurityPolicyResult describeCommonSecurityPolicy(DescribeCommonSecurityPolicyRequest request) {
        String url = "https://{service}.{region}.gs2.io/securityPolicy/common";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Identifier", "DescribeSecurityPolicy");
        return (DescribeCommonSecurityPolicyResult)this.doRequest((HttpUriRequest)get, DescribeCommonSecurityPolicyResult.class);
    }

    public DescribeIdentifierResult describeIdentifier(DescribeIdentifierRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "/identifier";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Identifier", "DescribeIdentifier");
        return (DescribeIdentifierResult)this.doRequest((HttpUriRequest)get, DescribeIdentifierResult.class);
    }

    public DescribeSecurityPolicyResult describeSecurityPolicy(DescribeSecurityPolicyRequest request) {
        String url = "https://{service}.{region}.gs2.io/securityPolicy";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Identifier", "DescribeSecurityPolicy");
        return (DescribeSecurityPolicyResult)this.doRequest((HttpUriRequest)get, DescribeSecurityPolicyResult.class);
    }

    public DescribeUserResult describeUser(DescribeUserRequest request) {
        String url = "https://{service}.{region}.gs2.io/user";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Identifier", "DescribeUser");
        return (DescribeUserResult)this.doRequest((HttpUriRequest)get, DescribeUserResult.class);
    }

    public void detachSecurityPolicy(DetachSecurityPolicyRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "/securityPolicy/" + (request.getSecurityPolicyId() == null ? "null" : request.getSecurityPolicyId()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Identifier", "DetachSecurityPolicy");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public GetIdentifierResult getIdentifier(GetIdentifierRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "/identifier/" + (request.getIdentifierId() == null ? "null" : request.getIdentifierId()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Identifier", "GetIdentifier");
        return (GetIdentifierResult)this.doRequest((HttpUriRequest)get, GetIdentifierResult.class);
    }

    public GetSecurityPolicyResult getSecurityPolicy(GetSecurityPolicyRequest request) {
        String url = "https://{service}.{region}.gs2.io/securityPolicy/" + (request.getSecurityPolicyName() == null ? "null" : request.getSecurityPolicyName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Identifier", "GetSecurityPolicy");
        return (GetSecurityPolicyResult)this.doRequest((HttpUriRequest)get, GetSecurityPolicyResult.class);
    }

    public GetUserResult getUser(GetUserRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Identifier", "GetUser");
        return (GetUserResult)this.doRequest((HttpUriRequest)get, GetUserResult.class);
    }

    public HasSecurityPolicyResult hasSecurityPolicy(HasSecurityPolicyRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserName() == null ? "null" : request.getUserName()) + "/securityPolicy";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Identifier", "HasSecurityPolicy");
        return (HasSecurityPolicyResult)this.doRequest((HttpUriRequest)get, HasSecurityPolicyResult.class);
    }

    public UpdateSecurityPolicyResult updateSecurityPolicy(UpdateSecurityPolicyRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("policy", request.getPolicy());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/securityPolicy/" + (request.getSecurityPolicyName() == null ? "null" : request.getSecurityPolicyName()) + "", this.credential, ENDPOINT, "Gs2Identifier", "UpdateSecurityPolicy", body.toString());
        return (UpdateSecurityPolicyResult)this.doRequest((HttpUriRequest)put, UpdateSecurityPolicyResult.class);
    }
}

