/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.netty.AbstractNettyHandler;
import io.grpc.netty.CancelServerStreamCommand;
import io.grpc.netty.ForcefulCloseCommand;
import io.grpc.netty.GrpcHttp2HeadersDecoder;
import io.grpc.netty.NettyServerStream;
import io.grpc.netty.SendGrpcFrameCommand;
import io.grpc.netty.SendResponseHeadersCommand;
import io.grpc.netty.Utils;
import io.grpc.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.logging.LogLevel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class NettyServerHandler
extends AbstractNettyHandler {
    private static Logger logger = Logger.getLogger(NettyServerHandler.class.getName());
    private final Http2Connection.PropertyKey streamKey;
    private final ServerTransportListener transportListener;
    private final int maxMessageSize;
    private Attributes attributes;
    private Throwable connectionError;
    private boolean teWarningLogged;
    private WriteQueue serverWriteQueue;
    private Attributes protocolNegotationAttrs = Attributes.EMPTY;

    static NettyServerHandler newHandler(ServerTransportListener transportListener, int maxStreams, int flowControlWindow, int maxHeaderListSize, int maxMessageSize) {
        Preconditions.checkArgument((maxHeaderListSize > 0 ? 1 : 0) != 0, (Object)"maxHeaderListSize must be positive");
        Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.DEBUG, NettyServerHandler.class);
        GrpcHttp2HeadersDecoder.GrpcHttp2ServerHeadersDecoder headersDecoder = new GrpcHttp2HeadersDecoder.GrpcHttp2ServerHeadersDecoder(maxHeaderListSize);
        Http2InboundFrameLogger frameReader = new Http2InboundFrameLogger((Http2FrameReader)new DefaultHttp2FrameReader((Http2HeadersDecoder)headersDecoder), frameLogger);
        Http2OutboundFrameLogger frameWriter = new Http2OutboundFrameLogger((Http2FrameWriter)new DefaultHttp2FrameWriter(), frameLogger);
        return NettyServerHandler.newHandler((Http2FrameReader)frameReader, (Http2FrameWriter)frameWriter, transportListener, maxStreams, flowControlWindow, maxMessageSize);
    }

    @VisibleForTesting
    static NettyServerHandler newHandler(Http2FrameReader frameReader, Http2FrameWriter frameWriter, ServerTransportListener transportListener, int maxStreams, int flowControlWindow, int maxMessageSize) {
        Preconditions.checkArgument((maxStreams > 0 ? 1 : 0) != 0, (Object)"maxStreams must be positive");
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        Preconditions.checkArgument((maxMessageSize > 0 ? 1 : 0) != 0, (Object)"maxMessageSize must be positive");
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        connection.local().flowController((Http2FlowController)new DefaultHttp2LocalFlowController((Http2Connection)connection, 0.5f, true));
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)connection, frameWriter);
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)connection, (Http2ConnectionEncoder)encoder, frameReader);
        Http2Settings settings = new Http2Settings();
        settings.initialWindowSize(flowControlWindow);
        settings.maxConcurrentStreams((long)maxStreams);
        return new NettyServerHandler(transportListener, (Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder, settings, maxMessageSize);
    }

    private NettyServerHandler(ServerTransportListener transportListener, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings settings, int maxMessageSize) {
        super(decoder, encoder, settings);
        Preconditions.checkArgument((maxMessageSize >= 0 ? 1 : 0) != 0, (Object)"maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        this.streamKey = encoder.connection().newKey();
        this.transportListener = (ServerTransportListener)Preconditions.checkNotNull((Object)transportListener, (Object)"transportListener");
        this.decoder().frameListener((Http2FrameListener)new FrameListener());
    }

    @Nullable
    Throwable connectionError() {
        return this.connectionError;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.serverWriteQueue = new WriteQueue(ctx.channel());
        this.attributes = this.transportListener.transportReady(Attributes.newBuilder((Attributes)this.protocolNegotationAttrs).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).build());
        super.handlerAdded(ctx);
    }

    private void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers) throws Http2Exception {
        if (!this.teWarningLogged && !Utils.TE_TRAILERS.equals(headers.get((Object)Utils.TE_HEADER))) {
            logger.warning(String.format("Expected header TE: %s, but %s is received. This means some intermediate proxy may not support trailers", Utils.TE_TRAILERS, headers.get((Object)Utils.TE_HEADER)));
            this.teWarningLogged = true;
        }
        try {
            this.verifyContentType(streamId, headers);
            String method = this.determineMethod(streamId, headers);
            Http2Stream http2Stream = this.requireHttp2Stream(streamId);
            Metadata metadata = Utils.convertHeaders(headers);
            StatsTraceContext statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)this.transportListener.methodDetermined(method, metadata), (Object)"statsTraceCtx");
            NettyServerStream.TransportState state = new NettyServerStream.TransportState(this, http2Stream, this.maxMessageSize, statsTraceCtx);
            NettyServerStream stream = new NettyServerStream(ctx.channel(), state, this.attributes, statsTraceCtx);
            this.transportListener.streamCreated((ServerStream)stream, method, metadata);
            state.onStreamAllocated();
            http2Stream.setProperty(this.streamKey, (Object)state);
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onHeadersRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onDataRead(int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        this.flowControlPing().onDataRead(data.readableBytes(), padding);
        try {
            NettyServerStream.TransportState stream = this.serverStream(this.requireHttp2Stream(streamId));
            stream.inboundDataReceived(data, endOfStream);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onDataRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onRstStreamRead(int streamId) throws Http2Exception {
        try {
            NettyServerStream.TransportState stream = this.serverStream(this.connection().stream(streamId));
            if (stream != null) {
                stream.transportReportStatus(Status.CANCELLED);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onRstStreamRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        logger.log(Level.WARNING, "Connection Error", cause);
        this.connectionError = cause;
        super.onConnectionError(ctx, cause, http2Ex);
    }

    protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
        logger.log(Level.WARNING, "Stream Error", cause);
        NettyServerStream.TransportState serverStream = this.serverStream(this.connection().stream(Http2Exception.streamId((Http2Exception)http2Ex)));
        if (serverStream != null) {
            serverStream.transportReportStatus(Utils.statusFromThrowable(cause));
        }
        super.onStreamError(ctx, cause, http2Ex);
    }

    @Override
    public void handleProtocolNegotiationCompleted(Attributes attrs) {
        this.protocolNegotationAttrs = attrs;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            final Status status = Status.UNAVAILABLE.withDescription("connection terminated for unknown reason");
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                public boolean visit(Http2Stream stream) throws Http2Exception {
                    NettyServerStream.TransportState serverStream = NettyServerHandler.this.serverStream(stream);
                    if (serverStream != null) {
                        serverStream.transportReportStatus(status);
                    }
                    return true;
                }
            });
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    WriteQueue getWriteQueue() {
        return this.serverWriteQueue;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof SendGrpcFrameCommand) {
            this.sendGrpcFrame(ctx, (SendGrpcFrameCommand)msg, promise);
        } else if (msg instanceof SendResponseHeadersCommand) {
            this.sendResponseHeaders(ctx, (SendResponseHeadersCommand)msg, promise);
        } else if (msg instanceof CancelServerStreamCommand) {
            this.cancelStream(ctx, (CancelServerStreamCommand)msg, promise);
        } else if (msg instanceof ForcefulCloseCommand) {
            this.forcefulClose(ctx, (ForcefulCloseCommand)msg, promise);
        } else {
            AssertionError e = new AssertionError((Object)("Write called for unexpected type: " + msg.getClass().getName()));
            ReferenceCountUtil.release((Object)msg);
            promise.setFailure((Throwable)((Object)e));
            throw e;
        }
    }

    void returnProcessedBytes(Http2Stream http2Stream, int bytes) {
        try {
            this.decoder().flowController().consumeBytes(http2Stream, bytes);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void closeStreamWhenDone(ChannelPromise promise, int streamId) throws Http2Exception {
        final NettyServerStream.TransportState stream = this.serverStream(this.requireHttp2Stream(streamId));
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                stream.complete();
            }
        });
    }

    private void sendGrpcFrame(ChannelHandlerContext ctx, SendGrpcFrameCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeData(ctx, cmd.streamId(), cmd.content(), 0, cmd.endStream(), promise);
    }

    private void sendResponseHeaders(ChannelHandlerContext ctx, SendResponseHeadersCommand cmd, ChannelPromise promise) throws Http2Exception {
        int streamId = cmd.stream().id();
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            this.resetStream(ctx, streamId, Http2Error.CANCEL.code(), promise);
            return;
        }
        if (cmd.endOfStream()) {
            this.closeStreamWhenDone(promise, streamId);
        }
        this.encoder().writeHeaders(ctx, streamId, cmd.headers(), 0, cmd.endOfStream(), promise);
    }

    private void cancelStream(ChannelHandlerContext ctx, CancelServerStreamCommand cmd, ChannelPromise promise) {
        cmd.stream().transportReportStatus(cmd.reason());
        this.encoder().writeRstStream(ctx, cmd.stream().id(), Http2Error.CANCEL.code(), promise);
    }

    private void forcefulClose(final ChannelHandlerContext ctx, final ForcefulCloseCommand msg, ChannelPromise promise) throws Exception {
        this.close(ctx, promise);
        this.connection().forEachActiveStream(new Http2StreamVisitor(){

            public boolean visit(Http2Stream stream) throws Http2Exception {
                NettyServerStream.TransportState serverStream = NettyServerHandler.this.serverStream(stream);
                if (serverStream != null) {
                    serverStream.transportReportStatus(msg.getStatus());
                    NettyServerHandler.this.resetStream(ctx, stream.id(), Http2Error.CANCEL.code(), ctx.newPromise());
                }
                stream.close();
                return true;
            }
        });
    }

    private void verifyContentType(int streamId, Http2Headers headers) throws Http2Exception {
        CharSequence contentType = (CharSequence)headers.get((Object)Utils.CONTENT_TYPE_HEADER);
        if (contentType == null) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Content-Type is missing from the request", (Object[])new Object[0]);
        }
        String contentTypeString = contentType.toString();
        if (!GrpcUtil.isGrpcContentType((String)contentTypeString)) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Content-Type '%s' is not supported", (Object[])new Object[]{contentTypeString});
        }
    }

    private Http2Stream requireHttp2Stream(int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            throw new AssertionError((Object)("Stream does not exist: " + streamId));
        }
        return stream;
    }

    private String determineMethod(int streamId, Http2Headers headers) throws Http2Exception {
        if (!Utils.HTTP_METHOD.equals((Object)headers.method())) {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Method '%s' is not supported", (Object[])new Object[]{headers.method()});
        }
        CharSequence path = headers.path();
        if (path.charAt(0) != '/') {
            throw Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.REFUSED_STREAM, (String)"Malformatted path: %s", (Object[])new Object[]{path});
        }
        return path.subSequence(1, path.length()).toString();
    }

    private NettyServerStream.TransportState serverStream(Http2Stream stream) {
        return stream == null ? null : (NettyServerStream.TransportState)stream.getProperty(this.streamKey);
    }

    private Http2Exception newStreamException(int streamId, Throwable cause) {
        return Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)cause, (String)cause.getMessage(), (Object[])new Object[0]);
    }

    private class FrameListener
    extends Http2FrameAdapter {
        private FrameListener() {
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            NettyServerHandler.this.onDataRead(streamId, data, padding, endOfStream);
            return padding;
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            NettyServerHandler.this.onHeadersRead(ctx, streamId, headers);
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            NettyServerHandler.this.onRstStreamRead(streamId);
        }

        public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            if (data.getLong(data.readerIndex()) == (long)NettyServerHandler.this.flowControlPing().payload()) {
                NettyServerHandler.this.flowControlPing().updateWindow();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, String.format("Window: %d", NettyServerHandler.this.decoder().flowController().initialWindowSize(NettyServerHandler.this.connection().connectionStream())));
                }
            } else {
                logger.warning("Received unexpected ping ack. No ping outstanding");
            }
        }
    }
}

