/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Preconditions;

public enum Http2TestCases {
    RST_AFTER_HEADER("server resets stream after sending header"),
    RST_AFTER_DATA("server resets stream after sending data"),
    RST_DURING_DATA("server resets stream in the middle of sending data"),
    GOAWAY("server sends goaway after first request and asserts second request uses new connection"),
    PING("server sends pings during request and verifies client response"),
    MAX_STREAMS("server verifies that the client respects MAX_STREAMS setting");

    private final String description;

    private Http2TestCases(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public static Http2TestCases fromString(String s) {
        Preconditions.checkNotNull((Object)s, (Object)"s");
        try {
            return Http2TestCases.valueOf(s.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid test case: " + s);
        }
    }
}

