/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.common.Function;
import com.google.instrumentation.stats.DistributionAggregationDescriptor;
import com.google.instrumentation.stats.IntervalAggregationDescriptor;
import com.google.instrumentation.stats.MeasurementDescriptor;
import com.google.instrumentation.stats.TagKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ViewDescriptor {
    private final String name;
    private final String description;
    private final MeasurementDescriptor measurementDescriptor;
    private final List<TagKey> tagKeys;

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final MeasurementDescriptor getMeasurementDescriptor() {
        return this.measurementDescriptor;
    }

    public final List<TagKey> getTagKeys() {
        return this.tagKeys;
    }

    public abstract <T> T match(Function<DistributionViewDescriptor, T> var1, Function<IntervalViewDescriptor, T> var2);

    private ViewDescriptor(String string, String string2, MeasurementDescriptor measurementDescriptor, List<TagKey> list) {
        this.name = string;
        this.description = string2;
        this.measurementDescriptor = measurementDescriptor;
        this.tagKeys = Collections.unmodifiableList(new ArrayList<TagKey>(list));
    }

    public static class IntervalViewDescriptor
    extends ViewDescriptor {
        private final IntervalAggregationDescriptor intervalAggregationDescriptor;

        public static IntervalViewDescriptor create(String string, String string2, MeasurementDescriptor measurementDescriptor, IntervalAggregationDescriptor intervalAggregationDescriptor, List<TagKey> list) {
            return new IntervalViewDescriptor(string, string2, measurementDescriptor, intervalAggregationDescriptor, list);
        }

        public IntervalAggregationDescriptor getIntervalAggregationDescriptor() {
            return this.intervalAggregationDescriptor;
        }

        @Override
        public <T> T match(Function<DistributionViewDescriptor, T> function, Function<IntervalViewDescriptor, T> function2) {
            return function2.apply(this);
        }

        private IntervalViewDescriptor(String string, String string2, MeasurementDescriptor measurementDescriptor, IntervalAggregationDescriptor intervalAggregationDescriptor, List<TagKey> list) {
            super(string, string2, measurementDescriptor, list);
            this.intervalAggregationDescriptor = intervalAggregationDescriptor;
        }
    }

    public static class DistributionViewDescriptor
    extends ViewDescriptor {
        private final DistributionAggregationDescriptor distributionAggregationDescriptor;

        public static DistributionViewDescriptor create(String string, String string2, MeasurementDescriptor measurementDescriptor, DistributionAggregationDescriptor distributionAggregationDescriptor, List<TagKey> list) {
            return new DistributionViewDescriptor(string, string2, measurementDescriptor, distributionAggregationDescriptor, list);
        }

        public DistributionAggregationDescriptor getDistributionAggregationDescriptor() {
            return this.distributionAggregationDescriptor;
        }

        @Override
        public <T> T match(Function<DistributionViewDescriptor, T> function, Function<IntervalViewDescriptor, T> function2) {
            return function.apply(this);
        }

        private DistributionViewDescriptor(String string, String string2, MeasurementDescriptor measurementDescriptor, DistributionAggregationDescriptor distributionAggregationDescriptor, List<TagKey> list) {
            super(string, string2, measurementDescriptor, list);
            this.distributionAggregationDescriptor = distributionAggregationDescriptor;
        }
    }
}

