/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Doubles;

public final class MathUtil {
    private MathUtil() {
    }

    public static boolean equals(double left, double right, double tolerance) {
        return Math.abs(left - right) <= Math.abs(tolerance);
    }

    public static boolean equals(float left, float right, float tolerance) {
        return MathUtil.equals((double)left, (double)right, (double)tolerance);
    }

    public static boolean notEquals(double left, double right, double tolerance) {
        if (Doubles.isFinite((double)left) && Doubles.isFinite((double)right)) {
            return Math.abs(left - right) > Math.abs(tolerance);
        }
        return false;
    }

    public static boolean notEquals(float left, float right, float tolerance) {
        return MathUtil.notEquals((double)left, (double)right, (double)tolerance);
    }
}

