/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Objects;
import io.grpc.Compressor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CallOptions {
    public static final CallOptions DEFAULT = new CallOptions();
    private Long deadlineNanoTime;
    @Nullable
    private Compressor compressor;
    @Nullable
    private String authority;

    public CallOptions withAuthority(@Nullable String authority) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.authority = authority;
        return newOptions;
    }

    public CallOptions withDeadlineNanoTime(@Nullable Long deadlineNanoTime) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.deadlineNanoTime = deadlineNanoTime;
        return newOptions;
    }

    public CallOptions withDeadlineAfter(long duration, TimeUnit unit) {
        return this.withDeadlineNanoTime(System.nanoTime() + unit.toNanos(duration));
    }

    @Nullable
    public Long getDeadlineNanoTime() {
        return this.deadlineNanoTime;
    }

    @Nullable
    public Compressor getCompressor() {
        return this.compressor;
    }

    public CallOptions withCompressor(@Nullable Compressor compressor) {
        CallOptions newOptions = new CallOptions(this);
        newOptions.compressor = compressor;
        return newOptions;
    }

    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    private CallOptions() {
    }

    private CallOptions(CallOptions other) {
        this.deadlineNanoTime = other.deadlineNanoTime;
        this.compressor = other.compressor;
        this.authority = other.authority;
    }

    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this);
        toStringHelper.add("deadlineNanoTime", (Object)this.deadlineNanoTime);
        if (this.deadlineNanoTime != null) {
            long remainingNanos = this.deadlineNanoTime - System.nanoTime();
            toStringHelper.addValue((Object)(remainingNanos + " ns from now"));
        }
        toStringHelper.add("compressor", (Object)this.compressor);
        return toStringHelper.toString();
    }
}

