/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.internal.AbstractStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.Http2ClientStream;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.netty.CancelClientStreamCommand;
import io.grpc.netty.NettyClientHandler;
import io.grpc.netty.NettyReadableBuffer;
import io.grpc.netty.NettyWritableBuffer;
import io.grpc.netty.NettyWritableBufferAllocator;
import io.grpc.netty.RequestMessagesCommand;
import io.grpc.netty.SendGrpcFrameCommand;
import io.grpc.netty.Utils;
import io.grpc.netty.WriteQueue;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;
import javax.annotation.Nullable;

class NettyClientStream
extends Http2ClientStream {
    private final Channel channel;
    private final NettyClientHandler handler;
    private Http2Stream http2Stream;
    private Integer id;
    private WriteQueue writeQueue;

    NettyClientStream(ClientStreamListener listener, Channel channel, NettyClientHandler handler, int maxMessageSize) {
        super((WritableBufferAllocator)new NettyWritableBufferAllocator(channel.alloc()), listener, maxMessageSize);
        this.writeQueue = handler.getWriteQueue();
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.handler = (NettyClientHandler)((Object)Preconditions.checkNotNull((Object)((Object)handler), (Object)"handler"));
    }

    public void request(int numMessages) {
        if (this.channel.eventLoop().inEventLoop()) {
            this.requestMessagesFromDeframer(numMessages);
        } else {
            this.writeQueue.enqueue(new RequestMessagesCommand((AbstractStream<Integer>)this, numMessages), true);
        }
    }

    public Integer id() {
        return this.id;
    }

    public void id(int id) {
        this.id = id;
    }

    public void setHttp2Stream(Http2Stream http2Stream) {
        Preconditions.checkNotNull((Object)http2Stream, (Object)"http2Stream");
        Preconditions.checkState((this.http2Stream == null ? 1 : 0) != 0, (Object)"Can only set http2Stream once");
        this.http2Stream = http2Stream;
        this.onStreamAllocated();
    }

    @Nullable
    public Http2Stream http2Stream() {
        return this.http2Stream;
    }

    void transportHeadersReceived(Http2Headers headers, boolean endOfStream) {
        if (endOfStream) {
            this.transportTrailersReceived(Utils.convertTrailers(headers));
        } else {
            this.transportHeadersReceived(Utils.convertHeaders(headers));
        }
    }

    void transportDataReceived(ByteBuf frame, boolean endOfStream) {
        this.transportDataReceived((ReadableBuffer)new NettyReadableBuffer(frame.retain()), endOfStream);
    }

    protected void sendCancel(Status reason) {
        this.writeQueue.enqueue(new CancelClientStreamCommand(this, reason), true);
    }

    protected void sendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        ByteBuf bytebuf = frame == null ? Unpooled.EMPTY_BUFFER : ((NettyWritableBuffer)frame).bytebuf();
        final int numBytes = bytebuf.readableBytes();
        if (numBytes > 0) {
            this.onSendingBytes(numBytes);
            this.writeQueue.enqueue((Object)new SendGrpcFrameCommand((AbstractStream<Integer>)this, bytebuf, endOfStream), this.channel.newPromise().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyClientStream.this.onSentBytes(numBytes);
                }
            }), flush);
        } else {
            this.writeQueue.enqueue((Object)new SendGrpcFrameCommand((AbstractStream<Integer>)this, bytebuf, endOfStream), flush);
        }
    }

    protected void returnProcessedBytes(int processedBytes) {
        this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
        this.writeQueue.scheduleFlush();
    }
}

