/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AbstractReferenceCounted;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyClientTransport;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.ProtocolNegotiators;
import io.grpc.netty.Utils;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class NettyChannelBuilder
extends AbstractManagedChannelImplBuilder<NettyChannelBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 0x100000;
    private final SocketAddress serverAddress;
    private String authority;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private Class<? extends Channel> channelType = NioSocketChannel.class;
    @Nullable
    private EventLoopGroup eventLoopGroup;
    private SslContext sslContext;
    private int flowControlWindow = 0x100000;
    private int maxMessageSize = 0x6400000;

    public static NettyChannelBuilder forAddress(SocketAddress serverAddress) {
        String authority;
        if (serverAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)serverAddress;
            authority = GrpcUtil.authorityFromHostAndPort((String)address.getHostString(), (int)address.getPort());
        } else {
            authority = serverAddress.toString();
        }
        return new NettyChannelBuilder(serverAddress, authority);
    }

    public static NettyChannelBuilder forAddress(String host, int port) {
        return new NettyChannelBuilder(new InetSocketAddress(host, port), GrpcUtil.authorityFromHostAndPort((String)host, (int)port));
    }

    private NettyChannelBuilder(SocketAddress serverAddress, String authority) {
        this.serverAddress = serverAddress;
        this.authority = authority;
    }

    public NettyChannelBuilder channelType(Class<? extends Channel> channelType) {
        this.channelType = (Class)Preconditions.checkNotNull(channelType);
        return this;
    }

    public NettyChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = type;
        return this;
    }

    public NettyChannelBuilder eventLoopGroup(@Nullable EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public NettyChannelBuilder sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public NettyChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkArgument((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    public NettyChannelBuilder maxMessageSize(int maxMessageSize) {
        Preconditions.checkArgument((maxMessageSize >= 0 ? 1 : 0) != 0, (Object)"maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public NettyChannelBuilder usePlaintext(boolean skipNegotiation) {
        if (skipNegotiation) {
            this.negotiationType(NegotiationType.PLAINTEXT);
        } else {
            this.negotiationType(NegotiationType.PLAINTEXT_UPGRADE);
        }
        return this;
    }

    public NettyChannelBuilder overrideAuthority(String authority) {
        this.authority = GrpcUtil.checkAuthority((String)authority);
        return this;
    }

    protected ClientTransportFactory buildTransportFactory() {
        GrpcUtil.checkAuthority((String)this.authority);
        return new NettyTransportFactory(this.serverAddress, this.authority, this.channelType, this.eventLoopGroup, this.flowControlWindow, this.createProtocolNegotiator(), this.maxMessageSize);
    }

    private ProtocolNegotiator createProtocolNegotiator() {
        switch (this.negotiationType) {
            case PLAINTEXT: {
                return ProtocolNegotiators.plaintext();
            }
            case PLAINTEXT_UPGRADE: {
                return ProtocolNegotiators.plaintextUpgrade();
            }
            case TLS: {
                if (this.sslContext == null) {
                    try {
                        this.sslContext = GrpcSslContexts.forClient().build();
                    }
                    catch (SSLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return ProtocolNegotiators.tls(this.sslContext, this.authority);
            }
        }
        throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)this.negotiationType));
    }

    private static class NettyTransportFactory
    extends AbstractReferenceCounted
    implements ClientTransportFactory {
        private final SocketAddress serverAddress;
        private final Class<? extends Channel> channelType;
        private final EventLoopGroup group;
        private final boolean usingSharedGroup;
        private final int flowControlWindow;
        private final ProtocolNegotiator negotiator;
        private final int maxMessageSize;
        private final String authority;

        private NettyTransportFactory(SocketAddress serverAddress, String authority, Class<? extends Channel> channelType, EventLoopGroup group, int flowControlWindow, ProtocolNegotiator negotiator, int maxMessageSize) {
            this.serverAddress = serverAddress;
            this.channelType = channelType;
            this.flowControlWindow = flowControlWindow;
            this.negotiator = negotiator;
            this.maxMessageSize = maxMessageSize;
            this.authority = authority;
            this.usingSharedGroup = group == null;
            this.group = this.usingSharedGroup ? (EventLoopGroup)SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP) : group;
        }

        public ClientTransport newClientTransport() {
            return new NettyClientTransport(this.serverAddress, this.channelType, this.group, this.negotiator, this.flowControlWindow, this.maxMessageSize, this.authority);
        }

        public String authority() {
            return this.authority;
        }

        protected void deallocate() {
            if (this.usingSharedGroup) {
                SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, (Object)this.group);
            }
        }
    }
}

