/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionAdapter;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public class DefaultHttp2RemoteFlowController
implements Http2RemoteFlowController {
    private static final int MIN_WRITABLE_CHUNK = 32768;
    private final Http2StreamVisitor WRITE_ALLOCATED_BYTES = new Http2StreamVisitor(){

        @Override
        public boolean visit(Http2Stream stream) {
            int written = DefaultHttp2RemoteFlowController.this.state(stream).writeAllocatedBytes();
            if (written != -1 && DefaultHttp2RemoteFlowController.this.listener != null) {
                DefaultHttp2RemoteFlowController.this.listener.streamWritten(stream, written);
            }
            return true;
        }
    };
    private final Http2Connection connection;
    private final Http2Connection.PropertyKey stateKey;
    private int initialWindowSize = 65535;
    private ChannelHandlerContext ctx;
    private Http2RemoteFlowController.Listener listener;

    public DefaultHttp2RemoteFlowController(Http2Connection connection) {
        this.connection = (Http2Connection)ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this.stateKey = connection.newKey();
        connection.connectionStream().setProperty(this.stateKey, new DefaultState(connection.connectionStream(), this.initialWindowSize));
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream stream) {
                stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, stream.state() == Http2Stream.State.IDLE ? new ReducedState(stream) : new DefaultState(stream, 0));
            }

            @Override
            public void onStreamActive(Http2Stream stream) {
                AbstractState state = DefaultHttp2RemoteFlowController.this.state(stream);
                if (state.getClass() == DefaultState.class) {
                    state.window(DefaultHttp2RemoteFlowController.this.initialWindowSize);
                } else {
                    stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, new DefaultState(state, DefaultHttp2RemoteFlowController.this.initialWindowSize));
                }
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                AbstractState state = DefaultHttp2RemoteFlowController.this.state(stream);
                state.cancel();
                if (stream.prioritizableForTree() != 0) {
                    stream.setProperty(DefaultHttp2RemoteFlowController.this.stateKey, new ReducedState(state));
                }
            }

            @Override
            public void onStreamHalfClosed(Http2Stream stream) {
                if (Http2Stream.State.HALF_CLOSED_LOCAL.equals((Object)stream.state())) {
                    DefaultHttp2RemoteFlowController.this.state(stream).cancel();
                }
            }

            @Override
            public void onPriorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
                int delta;
                Http2Stream parent = stream.parent();
                if (parent != null && (delta = DefaultHttp2RemoteFlowController.this.state(stream).streamableBytesForTree()) != 0) {
                    DefaultHttp2RemoteFlowController.this.state(parent).incrementStreamableBytesForTree(delta);
                }
            }

            @Override
            public void onPriorityTreeParentChanging(Http2Stream stream, Http2Stream newParent) {
                int delta;
                Http2Stream parent = stream.parent();
                if (parent != null && (delta = -DefaultHttp2RemoteFlowController.this.state(stream).streamableBytesForTree()) != 0) {
                    DefaultHttp2RemoteFlowController.this.state(parent).incrementStreamableBytesForTree(delta);
                }
            }
        });
    }

    @Override
    public void channelHandlerContext(ChannelHandlerContext ctx) throws Http2Exception {
        this.ctx = ctx;
        if (ctx != null && ctx.channel().isWritable()) {
            this.writePendingBytes();
        }
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.ctx;
    }

    @Override
    public void initialWindowSize(int newWindowSize) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        if (newWindowSize < 0) {
            throw new IllegalArgumentException("Invalid initial window size: " + newWindowSize);
        }
        final int delta = newWindowSize - this.initialWindowSize;
        this.initialWindowSize = newWindowSize;
        this.connection.forEachActiveStream(new Http2StreamVisitor(){

            @Override
            public boolean visit(Http2Stream stream) throws Http2Exception {
                DefaultHttp2RemoteFlowController.this.state(stream).incrementStreamWindow(delta);
                return true;
            }
        });
        if (delta > 0) {
            this.writePendingBytes();
        }
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream stream) {
        return this.state(stream).windowSize();
    }

    @Override
    public int initialWindowSize(Http2Stream stream) {
        return this.state(stream).initialWindowSize();
    }

    @Override
    public void incrementWindowSize(Http2Stream stream, int delta) throws Http2Exception {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        if (stream.id() == 0) {
            this.connectionState().incrementStreamWindow(delta);
        } else {
            AbstractState state = this.state(stream);
            state.incrementStreamWindow(delta);
        }
    }

    @Override
    public void listener(Http2RemoteFlowController.Listener listener) {
        this.listener = listener;
    }

    @Override
    public Http2RemoteFlowController.Listener listener() {
        return this.listener;
    }

    @Override
    public void addFlowControlled(Http2Stream stream, Http2RemoteFlowController.FlowControlled frame) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull((Object)frame, (String)"frame");
        try {
            AbstractState state = this.state(stream);
            state.enqueueFrame(frame);
        }
        catch (Throwable t) {
            frame.error(this.ctx, t);
            return;
        }
    }

    int streamableBytesForTree(Http2Stream stream) {
        return this.state(stream).streamableBytesForTree();
    }

    private AbstractState state(Http2Stream stream) {
        return (AbstractState)((Http2Stream)ObjectUtil.checkNotNull((Object)stream, (String)"stream")).getProperty(this.stateKey);
    }

    private AbstractState connectionState() {
        return (AbstractState)this.connection.connectionStream().getProperty(this.stateKey);
    }

    private int connectionWindowSize() {
        return this.connectionState().windowSize();
    }

    private int minUsableChannelBytes() {
        return Math.max(this.ctx.channel().config().getWriteBufferLowWaterMark(), 32768);
    }

    private int maxUsableChannelBytes() {
        if (this.ctx == null) {
            return 0;
        }
        int channelWritableBytes = (int)Math.min(Integer.MAX_VALUE, this.ctx.channel().bytesBeforeUnwritable());
        int useableBytes = channelWritableBytes > 0 ? Math.max(channelWritableBytes, this.minUsableChannelBytes()) : 0;
        return Math.min(this.connectionState().windowSize(), useableBytes);
    }

    private int writableBytes(int requestedBytes) {
        return Math.min(requestedBytes, this.maxUsableChannelBytes());
    }

    @Override
    public void writePendingBytes() throws Http2Exception {
        Http2Stream connectionStream = this.connection.connectionStream();
        int connectionWindowSize = this.writableBytes(this.state(connectionStream).windowSize());
        if (connectionWindowSize > 0) {
            this.allocateBytesForTree(connectionStream, connectionWindowSize);
        }
        this.connection.forEachActiveStream(this.WRITE_ALLOCATED_BYTES);
    }

    int allocateBytesForTree(Http2Stream parent, int connectionWindowSize) throws Http2Exception {
        AbstractState state = this.state(parent);
        if (state.streamableBytesForTree() <= 0) {
            return 0;
        }
        if (state.streamableBytesForTree() <= connectionWindowSize) {
            SimpleChildFeeder childFeeder = new SimpleChildFeeder(connectionWindowSize);
            parent.forEachChild(childFeeder);
            return childFeeder.bytesAllocated;
        }
        ChildFeeder childFeeder = new ChildFeeder(parent, connectionWindowSize);
        parent.forEachChild(childFeeder);
        childFeeder.feedHungryChildren();
        return childFeeder.bytesAllocated;
    }

    private abstract class AbstractState {
        protected final Http2Stream stream;
        protected int streamableBytesForTree;

        AbstractState(Http2Stream stream) {
            this.stream = stream;
        }

        AbstractState(AbstractState existingState) {
            this.stream = existingState.stream();
            this.streamableBytesForTree = existingState.streamableBytesForTree();
        }

        final Http2Stream stream() {
            return this.stream;
        }

        final void incrementStreamableBytesForTree(int numBytes) {
            this.streamableBytesForTree += numBytes;
            if (!this.stream.isRoot()) {
                DefaultHttp2RemoteFlowController.this.state(this.stream.parent()).incrementStreamableBytesForTree(numBytes);
            }
        }

        abstract int windowSize();

        abstract int initialWindowSize();

        abstract int writeAllocatedBytes();

        abstract int streamableBytes();

        abstract int streamableBytesForTree();

        abstract void cancel();

        abstract void window(int var1);

        abstract int incrementStreamWindow(int var1) throws Http2Exception;

        abstract int writableWindow();

        abstract int writeBytes(int var1);

        abstract void enqueueFrame(Http2RemoteFlowController.FlowControlled var1);

        abstract void allocate(int var1);

        abstract boolean hasFrame();
    }

    private final class ReducedState
    extends AbstractState {
        ReducedState(Http2Stream stream) {
            super(stream);
        }

        ReducedState(AbstractState existingState) {
            super(existingState);
        }

        @Override
        int windowSize() {
            return 0;
        }

        @Override
        int initialWindowSize() {
            return 0;
        }

        @Override
        int writableWindow() {
            return 0;
        }

        @Override
        int streamableBytes() {
            return 0;
        }

        @Override
        int streamableBytesForTree() {
            return this.streamableBytesForTree;
        }

        @Override
        int writeAllocatedBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        void cancel() {
        }

        @Override
        void window(int initialWindowSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        int incrementStreamWindow(int delta) throws Http2Exception {
            return 0;
        }

        @Override
        int writeBytes(int bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        void enqueueFrame(Http2RemoteFlowController.FlowControlled frame) {
            throw new UnsupportedOperationException();
        }

        @Override
        void allocate(int bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean hasFrame() {
            return false;
        }
    }

    private final class DefaultState
    extends AbstractState {
        private final Deque<Http2RemoteFlowController.FlowControlled> pendingWriteQueue;
        private int window;
        private int pendingBytes;
        private int allocated;
        private boolean writing;
        private boolean cancelled;

        DefaultState(Http2Stream stream, int initialWindowSize) {
            super(stream);
            this.window(initialWindowSize);
            this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController.FlowControlled>(2);
        }

        DefaultState(AbstractState existingState, int initialWindowSize) {
            super(existingState);
            this.window(initialWindowSize);
            this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController.FlowControlled>(2);
        }

        @Override
        int windowSize() {
            return this.window;
        }

        @Override
        int initialWindowSize() {
            return DefaultHttp2RemoteFlowController.this.initialWindowSize;
        }

        @Override
        void window(int initialWindowSize) {
            this.window = initialWindowSize;
        }

        @Override
        void allocate(int bytes) {
            this.allocated += bytes;
            this.incrementStreamableBytesForTree(-bytes);
        }

        @Override
        int writeAllocatedBytes() {
            int numBytes = this.allocated;
            this.incrementStreamableBytesForTree(this.allocated);
            this.resetAllocated();
            return this.writeBytes(numBytes);
        }

        private void resetAllocated() {
            this.allocated = 0;
        }

        @Override
        int incrementStreamWindow(int delta) throws Http2Exception {
            if (delta > 0 && Integer.MAX_VALUE - delta < this.window) {
                throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
            }
            int previouslyStreamable = this.streamableBytes();
            this.window += delta;
            int streamableDelta = this.streamableBytes() - previouslyStreamable;
            if (streamableDelta != 0) {
                this.incrementStreamableBytesForTree(streamableDelta);
            }
            return this.window;
        }

        @Override
        int writableWindow() {
            return Math.min(this.window, DefaultHttp2RemoteFlowController.this.connectionWindowSize());
        }

        @Override
        int streamableBytes() {
            return Math.max(0, Math.min(this.pendingBytes - this.allocated, this.window));
        }

        @Override
        int streamableBytesForTree() {
            return this.streamableBytesForTree;
        }

        @Override
        void enqueueFrame(Http2RemoteFlowController.FlowControlled frame) {
            this.incrementPendingBytes(frame.size());
            Http2RemoteFlowController.FlowControlled last = this.pendingWriteQueue.peekLast();
            if (last == null || !last.merge(DefaultHttp2RemoteFlowController.this.ctx, frame)) {
                this.pendingWriteQueue.offer(frame);
            }
        }

        @Override
        boolean hasFrame() {
            return !this.pendingWriteQueue.isEmpty();
        }

        private Http2RemoteFlowController.FlowControlled peek() {
            return this.pendingWriteQueue.peek();
        }

        @Override
        void cancel() {
            this.cancel(null);
        }

        private void cancel(Throwable cause) {
            Http2RemoteFlowController.FlowControlled frame;
            this.cancelled = true;
            if (this.writing) {
                return;
            }
            while ((frame = this.pendingWriteQueue.poll()) != null) {
                this.writeError(frame, Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, cause, "Stream closed before write could take place", new Object[0]));
            }
        }

        @Override
        int writeBytes(int bytes) {
            if (!this.hasFrame()) {
                return -1;
            }
            Http2RemoteFlowController.FlowControlled frame = this.peek();
            int maxBytes = Math.min(bytes, this.writableWindow());
            if (maxBytes <= 0 && frame.size() != 0) {
                return -1;
            }
            int originalBytes = bytes;
            bytes -= this.write(frame, maxBytes);
            while (this.hasFrame()) {
                frame = this.peek();
                maxBytes = Math.min(bytes, this.writableWindow());
                if (maxBytes <= 0 && frame.size() != 0) break;
                bytes -= this.write(frame, maxBytes);
            }
            return originalBytes - bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int write(Http2RemoteFlowController.FlowControlled frame, int allowedBytes) {
            int writtenBytes;
            int before = frame.size();
            Throwable cause = null;
            try {
                assert (!this.writing);
                this.writing = true;
                frame.write(DefaultHttp2RemoteFlowController.this.ctx, Math.max(0, allowedBytes));
                if (!this.cancelled && frame.size() == 0) {
                    this.pendingWriteQueue.remove();
                    frame.writeComplete();
                }
            }
            catch (Throwable t) {
                this.cancelled = true;
                cause = t;
            }
            finally {
                this.writing = false;
                writtenBytes = before - frame.size();
                this.decrementFlowControlWindow(writtenBytes);
                this.decrementPendingBytes(writtenBytes);
                if (this.cancelled) {
                    this.cancel(cause);
                }
            }
            return writtenBytes;
        }

        private void incrementPendingBytes(int numBytes) {
            int previouslyStreamable = this.streamableBytes();
            this.pendingBytes += numBytes;
            int delta = this.streamableBytes() - previouslyStreamable;
            if (delta != 0) {
                this.incrementStreamableBytesForTree(delta);
            }
        }

        private void decrementPendingBytes(int bytes) {
            this.incrementPendingBytes(-bytes);
        }

        private void decrementFlowControlWindow(int bytes) {
            try {
                int negativeBytes = -bytes;
                DefaultHttp2RemoteFlowController.this.connectionState().incrementStreamWindow(negativeBytes);
                this.incrementStreamWindow(negativeBytes);
            }
            catch (Http2Exception e) {
                throw new IllegalStateException("Invalid window state when writing frame: " + e.getMessage(), e);
            }
        }

        private void writeError(Http2RemoteFlowController.FlowControlled frame, Http2Exception cause) {
            assert (DefaultHttp2RemoteFlowController.this.ctx != null);
            this.decrementPendingBytes(frame.size());
            frame.error(DefaultHttp2RemoteFlowController.this.ctx, cause);
        }
    }

    private final class SimpleChildFeeder
    implements Http2StreamVisitor {
        int bytesAllocated;
        int connectionWindow;

        SimpleChildFeeder(int connectionWindow) {
            this.connectionWindow = connectionWindow;
        }

        @Override
        public boolean visit(Http2Stream child) throws Http2Exception {
            AbstractState childState = DefaultHttp2RemoteFlowController.this.state(child);
            int bytesForChild = childState.streamableBytes();
            if (bytesForChild > 0 || childState.hasFrame()) {
                childState.allocate(bytesForChild);
                this.bytesAllocated += bytesForChild;
                this.connectionWindow -= bytesForChild;
            }
            int childBytesAllocated = DefaultHttp2RemoteFlowController.this.allocateBytesForTree(child, this.connectionWindow);
            this.bytesAllocated += childBytesAllocated;
            this.connectionWindow -= childBytesAllocated;
            return true;
        }
    }

    private final class ChildFeeder
    implements Http2StreamVisitor {
        final int maxSize;
        int totalWeight;
        int connectionWindow;
        int nextTotalWeight;
        int nextConnectionWindow;
        int bytesAllocated;
        Http2Stream[] stillHungry;
        int nextTail;

        ChildFeeder(Http2Stream parent, int connectionWindow) {
            this.maxSize = parent.numChildren();
            this.totalWeight = parent.totalChildWeights();
            this.connectionWindow = connectionWindow;
            this.nextConnectionWindow = connectionWindow;
        }

        @Override
        public boolean visit(Http2Stream child) throws Http2Exception {
            int connectionWindowChunk = Math.max(1, (int)((double)this.connectionWindow * ((double)child.weight() / (double)this.totalWeight)));
            int bytesForTree = Math.min(this.nextConnectionWindow, connectionWindowChunk);
            AbstractState state = DefaultHttp2RemoteFlowController.this.state(child);
            int bytesForChild = Math.min(state.streamableBytes(), bytesForTree);
            if (bytesForChild > 0) {
                state.allocate(bytesForChild);
                this.bytesAllocated += bytesForChild;
                this.nextConnectionWindow -= bytesForChild;
                bytesForTree -= bytesForChild;
                if (this.nextConnectionWindow > 0 && state.streamableBytesForTree() > 0) {
                    this.stillHungry(child);
                    this.nextTotalWeight += child.weight();
                }
            }
            if (bytesForTree > 0) {
                int childBytesAllocated = DefaultHttp2RemoteFlowController.this.allocateBytesForTree(child, bytesForTree);
                this.bytesAllocated += childBytesAllocated;
                this.nextConnectionWindow -= childBytesAllocated;
            }
            return this.nextConnectionWindow > 0;
        }

        void feedHungryChildren() throws Http2Exception {
            if (this.stillHungry == null) {
                return;
            }
            this.totalWeight = this.nextTotalWeight;
            this.connectionWindow = this.nextConnectionWindow;
            int tail = this.nextTail;
            while (tail > 0 && this.connectionWindow > 0) {
                this.nextTotalWeight = 0;
                this.nextTail = 0;
                for (int head = 0; head < tail && this.nextConnectionWindow > 0 && this.visit(this.stillHungry[head]); ++head) {
                }
                this.connectionWindow = this.nextConnectionWindow;
                this.totalWeight = this.nextTotalWeight;
                tail = this.nextTail;
            }
        }

        void stillHungry(Http2Stream child) {
            this.ensureSpaceIsAllocated(this.nextTail);
            this.stillHungry[this.nextTail++] = child;
        }

        void ensureSpaceIsAllocated(int index) {
            if (this.stillHungry == null) {
                this.stillHungry = new Http2Stream[Math.max(2, this.maxSize >>> 2)];
            } else if (index == this.stillHungry.length) {
                this.stillHungry = Arrays.copyOf(this.stillHungry, Math.min(this.maxSize, this.stillHungry.length << 1));
            }
        }
    }
}

