/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import io.grpc.inprocess.InProcessTransport;
import io.grpc.internal.Server;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerTransportListener;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class InProcessServer
implements Server {
    private static final ConcurrentMap<String, InProcessServer> registry = new ConcurrentHashMap<String, InProcessServer>();
    private final String name;
    private ServerListener listener;
    private boolean shutdown;

    static InProcessServer findServer(String name) {
        return (InProcessServer)registry.get(name);
    }

    InProcessServer(String name) {
        this.name = name;
    }

    @Override
    public void start(ServerListener serverListener) throws IOException {
        this.listener = serverListener;
        if (registry.putIfAbsent(this.name, this) != null) {
            throw new IOException("name already registered: " + this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!registry.remove(this.name, this)) {
            throw new AssertionError();
        }
        InProcessServer inProcessServer = this;
        synchronized (inProcessServer) {
            this.shutdown = true;
            this.listener.serverShutdown();
        }
    }

    synchronized ServerTransportListener register(InProcessTransport transport) {
        if (this.shutdown) {
            return null;
        }
        return this.listener.transportCreated(transport);
    }
}

