/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Metadata;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TransportFrameUtil;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.ByteString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class Utils {
    public static final ByteString STATUS_OK = new ByteString("200".getBytes(CharsetUtil.UTF_8));
    public static final ByteString HTTP_METHOD = new ByteString("POST".getBytes(CharsetUtil.UTF_8));
    public static final ByteString HTTPS = new ByteString("https".getBytes(CharsetUtil.UTF_8));
    public static final ByteString HTTP = new ByteString("http".getBytes(CharsetUtil.UTF_8));
    public static final ByteString CONTENT_TYPE_HEADER = new ByteString(GrpcUtil.CONTENT_TYPE_KEY.name().getBytes(CharsetUtil.UTF_8));
    public static final ByteString CONTENT_TYPE_GRPC = new ByteString("application/grpc".getBytes(CharsetUtil.UTF_8));
    public static final ByteString TE_HEADER = new ByteString("te".getBytes(CharsetUtil.UTF_8));
    public static final ByteString TE_TRAILERS = new ByteString("trailers".getBytes(CharsetUtil.UTF_8));
    public static final ByteString USER_AGENT = new ByteString(GrpcUtil.USER_AGENT_KEY.name().getBytes(CharsetUtil.UTF_8));
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(1, "grpc-default-boss-ELG");
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(0, "grpc-default-worker-ELG");

    public static Metadata convertHeaders(Http2Headers http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(Http2Headers http2Headers) {
        byte[][] headerValues = new byte[http2Headers.size() * 2][];
        int i = 0;
        for (Map.Entry entry : http2Headers) {
            headerValues[i++] = ((ByteString)entry.getKey()).array();
            headerValues[i++] = ((ByteString)entry.getValue()).array();
        }
        return TransportFrameUtil.toRawSerializedHeaders((byte[][])headerValues);
    }

    public static Http2Headers convertClientHeaders(Metadata headers, ByteString scheme, ByteString defaultPath, ByteString defaultAuthority) {
        Preconditions.checkNotNull((Object)defaultPath, (Object)"defaultPath");
        Preconditions.checkNotNull((Object)defaultAuthority, (Object)"defaultAuthority");
        Http2Headers http2Headers = Utils.convertMetadata(headers);
        http2Headers.authority(defaultAuthority).path(defaultPath).method(HTTP_METHOD).scheme(scheme).set(CONTENT_TYPE_HEADER, CONTENT_TYPE_GRPC).set(TE_HEADER, TE_TRAILERS);
        if (headers.containsKey(GrpcUtil.AUTHORITY_KEY)) {
            http2Headers.authority(new ByteString(((String)headers.get(GrpcUtil.AUTHORITY_KEY)).getBytes(CharsetUtil.UTF_8)));
        }
        String userAgent = GrpcUtil.getGrpcUserAgent((String)"netty", (String)((String)headers.get(GrpcUtil.USER_AGENT_KEY)));
        http2Headers.set(USER_AGENT, new ByteString(userAgent.getBytes(CharsetUtil.UTF_8)));
        return http2Headers;
    }

    public static Http2Headers convertServerHeaders(Metadata headers) {
        Http2Headers http2Headers = Utils.convertMetadata(headers);
        http2Headers.set(CONTENT_TYPE_HEADER, CONTENT_TYPE_GRPC);
        http2Headers.status(STATUS_OK);
        return http2Headers;
    }

    public static Metadata convertTrailers(Http2Headers http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    public static Http2Headers convertTrailers(Metadata trailers, boolean headersSent) {
        Http2Headers http2Trailers = Utils.convertMetadata(trailers);
        if (!headersSent) {
            http2Trailers.set(CONTENT_TYPE_HEADER, CONTENT_TYPE_GRPC);
            http2Trailers.status(STATUS_OK);
        }
        return http2Trailers;
    }

    private static Http2Headers convertMetadata(Metadata headers) {
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
        byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers((Metadata)headers);
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            ByteString name = new ByteString(serializedHeaders[i], false);
            ByteString value = new ByteString(serializedHeaders[i + 1], false);
            http2Headers.add(name, value);
        }
        return http2Headers;
    }

    private Utils() {
    }

    private static class DefaultEventLoopGroupResource
    implements SharedResourceHolder.Resource<EventLoopGroup> {
        private final String name;
        private final int numEventLoops;

        DefaultEventLoopGroupResource(int numEventLoops, String name) {
            this.name = name;
            this.numEventLoops = numEventLoops;
        }

        public EventLoopGroup create() {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.name + "-%d").build();
            int parallelism = this.numEventLoops == 0 ? Runtime.getRuntime().availableProcessors() * 2 : this.numEventLoops;
            final ExecutorService executor = Executors.newFixedThreadPool(parallelism, threadFactory);
            NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(parallelism, (Executor)executor);
            nioEventLoopGroup.terminationFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(){

                public void operationComplete(Future<Object> future) throws Exception {
                    executor.shutdown();
                }
            });
            return nioEventLoopGroup;
        }

        public void close(EventLoopGroup instance) {
            instance.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }

        public String toString() {
            return this.name;
        }
    }
}

