/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.BufferingHttp2ConnectionEncoder;
import io.grpc.netty.CreateStreamCommand;
import io.grpc.netty.NettyClientHandler;
import io.grpc.netty.NettyClientStream;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.SendPingCommand;
import io.grpc.netty.Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.logging.LogLevel;
import io.netty.util.AsciiString;
import io.netty.util.ByteString;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class NettyClientTransport
implements ClientTransport {
    private final SocketAddress address;
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup group;
    private final ProtocolNegotiator.Handler negotiationHandler;
    private final NettyClientHandler handler;
    private final AsciiString authority;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private Channel channel;
    private ClientTransport.Listener listener;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;

    NettyClientTransport(SocketAddress address, Class<? extends Channel> channelType, EventLoopGroup group, ProtocolNegotiator negotiator, int flowControlWindow, int maxMessageSize, String authority) {
        Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        this.address = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.group = (EventLoopGroup)Preconditions.checkNotNull((Object)group, (Object)"group");
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.authority = new AsciiString((CharSequence)authority);
        this.handler = this.newHandler();
        this.negotiationHandler = negotiator.newHandler(this.handler);
    }

    public void ping(ClientTransport.PingCallback callback, Executor executor) {
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true);
    }

    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, ClientStreamListener listener) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        final NettyClientStream stream = new NettyClientStream(listener, this.channel, this.handler, this.maxMessageSize);
        AsciiString defaultPath = new AsciiString((CharSequence)("/" + method.getFullMethodName()));
        AsciiString defaultAuthority = new AsciiString((CharSequence)((Object)(headers.containsKey(GrpcUtil.AUTHORITY_KEY) ? (Comparable)headers.get(GrpcUtil.AUTHORITY_KEY) : this.authority)));
        headers.removeAll(GrpcUtil.AUTHORITY_KEY);
        Http2Headers http2Headers = Utils.convertClientHeaders(headers, this.negotiationHandler.scheme(), (ByteString)defaultPath, (ByteString)defaultAuthority);
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    stream.transportReportStatus(Status.fromThrowable((Throwable)future.cause()), true, new Metadata());
                }
            }
        };
        this.handler.getWriteQueue().enqueue(new CreateStreamCommand(http2Headers, stream), !method.getType().clientSendsOneMessage()).addListener((GenericFutureListener)failureListener);
        return stream;
    }

    public void start(ClientTransport.Listener transportListener) {
        this.listener = (ClientTransport.Listener)Preconditions.checkNotNull((Object)transportListener, (Object)"listener");
        Bootstrap b = new Bootstrap();
        b.group(this.group);
        b.channel(this.channelType);
        if (NioSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        b.handler((ChannelHandler)this.negotiationHandler);
        this.channel = b.connect(this.address).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ChannelHandlerContext ctx = NettyClientTransport.this.channel.pipeline().context((ChannelHandler)NettyClientTransport.this.handler);
                    if (ctx != null) {
                        ctx.fireExceptionCaught(future.cause());
                    }
                    NettyClientTransport.this.channel.pipeline().fireExceptionCaught(future.cause());
                }
            }
        }).channel();
        this.handler.startWriteQueue(this.channel);
        this.channel.write(NettyClientHandler.NOOP_MESSAGE).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.notifyTerminated(Status.fromThrowable((Throwable)future.cause()));
                }
            }
        });
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Status status = NettyClientTransport.this.handler.errorStatus();
                if (status == null) {
                    status = Status.INTERNAL.withDescription("Connection closed with unknown cause");
                }
                NettyClientTransport.this.notifyTerminated(status);
            }
        });
    }

    public void shutdown() {
        this.notifyShutdown(Status.OK.withDescription("Channel requested transport to shut down"));
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShutdown(Status status) {
        boolean notifyShutdown;
        Preconditions.checkNotNull((Object)status, (Object)"status");
        NettyClientTransport nettyClientTransport = this;
        synchronized (nettyClientTransport) {
            notifyShutdown = !this.shutdown;
            this.shutdown = true;
        }
        if (notifyShutdown) {
            this.listener.transportShutdown(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTerminated(Status status) {
        boolean notifyTerminated;
        this.notifyShutdown(status);
        NettyClientTransport nettyClientTransport = this;
        synchronized (nettyClientTransport) {
            notifyTerminated = !this.terminated;
            this.terminated = true;
        }
        if (notifyTerminated) {
            this.listener.transportTerminated();
        }
    }

    private NettyClientHandler newHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        DefaultHttp2FrameReader frameReader = new DefaultHttp2FrameReader();
        DefaultHttp2FrameWriter frameWriter = new DefaultHttp2FrameWriter();
        Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.DEBUG, this.getClass());
        frameReader = new Http2InboundFrameLogger((Http2FrameReader)frameReader, frameLogger);
        frameWriter = new Http2OutboundFrameLogger((Http2FrameWriter)frameWriter, frameLogger);
        BufferingHttp2ConnectionEncoder encoder = new BufferingHttp2ConnectionEncoder((Http2ConnectionEncoder)new DefaultHttp2ConnectionEncoder((Http2Connection)connection, (Http2FrameWriter)frameWriter)){
            private boolean firstSettings;
            {
                this.firstSettings = true;
            }

            @Override
            public ChannelFuture writeSettingsAck(ChannelHandlerContext ctx, ChannelPromise promise) {
                if (this.firstSettings) {
                    NettyClientTransport.this.listener.transportReady();
                    this.firstSettings = false;
                }
                return super.writeSettingsAck(ctx, promise);
            }
        };
        return new NettyClientHandler(encoder, (Http2Connection)connection, (Http2FrameReader)frameReader, this.flowControlWindow);
    }
}

