/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.jbpm.embedded.service.impl;

import io.graphenee.jbpm.embedded.service.GxKieRuntimeEngineService;
import javax.persistence.EntityManagerFactory;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.manager.context.CorrelationKeyContext;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Service;

@Service
public class GxKieRuntimeEngineServiceImpl
implements GxKieRuntimeEngineService {
    @Autowired
    @Qualifier(value="jbpmEntityManagerFactory")
    EntityManagerFactory jbpmEntityManagerFactory;
    @Autowired
    @Qualifier(value="jbpmTransactionManager")
    JpaTransactionManager jbpmTransactionManager;
    @Autowired
    UserGroupCallback userGroupCallback;
    RuntimeManager singletonRuntimeManager;
    RuntimeManager perProcessRuntimeManager;
    RuntimeManager perRequestRuntimeManager;

    @Override
    public RuntimeEngine newSingletonRuntimeEngine() {
        if (this.singletonRuntimeManager == null) {
            RuntimeEnvironment renv = RuntimeEnvironmentBuilder.Factory.get().newClasspathKmoduleDefaultBuilder().userGroupCallback(this.userGroupCallback).addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)this.jbpmTransactionManager).entityManagerFactory((Object)this.jbpmEntityManagerFactory).persistence(true).get();
            this.singletonRuntimeManager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(renv);
        }
        RuntimeEngine re = this.singletonRuntimeManager.getRuntimeEngine(EmptyContext.get());
        return re;
    }

    @Override
    public RuntimeEngine newPerRequestRuntimeEngine() {
        if (this.perRequestRuntimeManager == null) {
            RuntimeEnvironment renv = RuntimeEnvironmentBuilder.Factory.get().newClasspathKmoduleDefaultBuilder().userGroupCallback(this.userGroupCallback).addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)this.jbpmTransactionManager).entityManagerFactory((Object)this.jbpmEntityManagerFactory).persistence(true).get();
            this.perRequestRuntimeManager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(renv);
        }
        RuntimeEngine re = this.perRequestRuntimeManager.getRuntimeEngine(EmptyContext.get());
        return re;
    }

    @Override
    public RuntimeEngine newPerProcessRuntimeEngine() {
        this.initializePerProcessRuntimeManager();
        RuntimeEngine re = this.perProcessRuntimeManager.getRuntimeEngine(EmptyContext.get());
        return re;
    }

    @Override
    public RuntimeEngine newPerProcessRuntimeEngine(CorrelationKey key) {
        this.initializePerProcessRuntimeManager();
        RuntimeEngine re = this.perProcessRuntimeManager.getRuntimeEngine((Context)CorrelationKeyContext.get((CorrelationKey)key));
        return re;
    }

    @Override
    public RuntimeEngine newPerProcessRuntimeEngine(Long processInstanceId) {
        this.initializePerProcessRuntimeManager();
        RuntimeEngine re = this.perProcessRuntimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        return re;
    }

    private void initializePerProcessRuntimeManager() {
        if (this.perProcessRuntimeManager == null) {
            RuntimeEnvironment renv = RuntimeEnvironmentBuilder.Factory.get().newClasspathKmoduleDefaultBuilder().userGroupCallback(this.userGroupCallback).addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)this.jbpmTransactionManager).entityManagerFactory((Object)this.jbpmEntityManagerFactory).persistence(true).get();
            this.perProcessRuntimeManager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(renv);
        }
    }
}

