/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.jbpm.embedded;

import io.graphenee.core.model.Fault;
import io.graphenee.jbpm.embedded.exception.GxAssignTaskException;
import io.graphenee.jbpm.embedded.exception.GxCompleteTaskException;
import io.graphenee.jbpm.embedded.exception.GxSkipTaskException;
import io.graphenee.util.KeyValueWrapper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Comment;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;

public class GxUserTask
implements TaskSummary {
    private TaskSummary task;
    WeakReference<TaskService> taskService;
    private volatile Task internalTask;
    private String taskOwner;
    private Fault<Long, Object> taskObjectFault;
    private KeyValueWrapper o;

    public GxUserTask(TaskService taskService, TaskSummary task) {
        this.taskService = new WeakReference<TaskService>(taskService);
        this.task = task;
    }

    public Long getId() {
        return this.task.getId();
    }

    public String getName() {
        return this.task.getName();
    }

    public String getStatusId() {
        return this.task.getStatusId();
    }

    public Integer getPriority() {
        return this.task.getPriority();
    }

    public String getActualOwnerId() {
        return this.task.getActualOwnerId();
    }

    public String getCreatedById() {
        return this.task.getCreatedById();
    }

    public Date getCreatedOn() {
        return this.task.getCreatedOn();
    }

    public Date getActivationTime() {
        return this.task.getActivationTime();
    }

    public Date getExpirationTime() {
        return this.task.getExpirationTime();
    }

    public String getProcessId() {
        return this.task.getProcessId();
    }

    public Long getProcessInstanceId() {
        return this.task.getProcessInstanceId();
    }

    public String getDeploymentId() {
        return this.task.getDeploymentId();
    }

    public Long getParentId() {
        return this.task.getParentId();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.task.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.task.readExternal(in);
    }

    public String getSubject() {
        return this.getTask().getSubject();
    }

    public String getDescription() {
        return this.task.getDescription();
    }

    public Status getStatus() {
        return this.task.getStatus();
    }

    public Boolean isSkipable() {
        return this.task.isSkipable();
    }

    public User getActualOwner() {
        return this.task.getActualOwner();
    }

    public User getTaskInitiator() {
        return this.getTask().getPeopleAssignments().getTaskInitiator();
    }

    public User getCreatedBy() {
        return this.task.getCreatedBy();
    }

    public Long getProcessSessionId() {
        return this.task.getProcessSessionId();
    }

    @Deprecated
    public List<String> getPotentialOwners() {
        return this.task.getPotentialOwners();
    }

    public Boolean isQuickTaskSummary() {
        return this.task.isQuickTaskSummary();
    }

    public List<Comment> getComments() {
        List<Comment> comments = this.getTaskService().getAllCommentsByTaskId(this.getId().longValue());
        comments = comments.stream().sorted((o1, o2) -> {
            if (o1.getAddedAt().after(o2.getAddedAt())) {
                return -1;
            }
            return 1;
        }).collect(Collectors.toList());
        return comments;
    }

    public Comment getLatestComment() {
        List<Comment> comments = this.getComments();
        if (comments != null && !comments.isEmpty()) {
            return comments.get(0);
        }
        return null;
    }

    public String getComment() {
        Comment latestComment = this.getLatestComment();
        if (latestComment != null) {
            return latestComment.getText();
        }
        return null;
    }

    public String getCommentedBy() {
        Comment latestComment = this.getLatestComment();
        if (latestComment != null) {
            return latestComment.getAddedBy().getId();
        }
        return null;
    }

    protected TaskService getTaskService() {
        assert (this.taskService.get() != null);
        return (TaskService)this.taskService.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTask() {
        if (this.internalTask == null) {
            GxUserTask gxUserTask = this;
            synchronized (gxUserTask) {
                if (this.internalTask == null) {
                    this.internalTask = this.getTaskService().getTaskById(this.getId().longValue());
                }
            }
        }
        return this.internalTask;
    }

    public void complete(Map<String, Object> taskData) throws GxCompleteTaskException {
        try {
            this.getTaskService().complete(this.getId().longValue(), this.getTaskOwner(), taskData);
        }
        catch (Exception ex) {
            throw new GxCompleteTaskException("Faild to complete task", ex);
        }
    }

    public void skip() throws GxSkipTaskException {
        try {
            this.getTaskService().skip(this.getId().longValue(), this.getTaskOwner());
        }
        catch (Exception ex) {
            throw new GxSkipTaskException("Failed to skip task", ex);
        }
    }

    public void assign(String assignToUserId) throws GxAssignTaskException {
        try {
            this.getTaskService().delegate(this.getId().longValue(), this.getTaskOwner(), assignToUserId);
        }
        catch (Exception ex) {
            throw new GxAssignTaskException("Failed to assign task", ex);
        }
    }

    public String getTaskOwner() {
        User user = this.getActualOwner();
        if (user == null) {
            user = this.getTaskInitiator();
        }
        if (user != null) {
            return user.getId();
        }
        return this.taskOwner;
    }

    public void setTaskOwner(String taskOwner) {
        this.taskOwner = taskOwner;
    }

    public Fault<Long, Object> getTaskObjectFault() {
        return this.taskObjectFault;
    }

    public void setTaskObjectFault(Fault<Long, Object> taskObjectFault) {
        this.taskObjectFault = taskObjectFault;
    }

    public KeyValueWrapper getO() {
        if (this.o == null && this.getTaskObjectFault() != null) {
            this.o = new KeyValueWrapper(this.getTaskObjectFault().getValue());
        }
        return this.o;
    }
}

