/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.jbpm.embedded.vaadin;

import com.vaadin.server.Page;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import io.graphenee.jbpm.embedded.GxAssignee;
import io.graphenee.jbpm.embedded.GxUserTask;
import io.graphenee.jbpm.embedded.exception.GxAssignTaskException;
import io.graphenee.jbpm.embedded.exception.GxCompleteTaskException;
import io.graphenee.jbpm.embedded.exception.GxSkipTaskException;
import io.graphenee.jbpm.embedded.vaadin.GxSelectAssigneeForm;
import io.graphenee.vaadin.TRAbstractBaseForm;
import io.graphenee.vaadin.TRAbstractForm;
import io.graphenee.vaadin.ui.GxNotification;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.api.task.model.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.vaadin.dialogs.ConfirmDialog;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MHorizontalLayout;

public abstract class GxUserTaskForm<T>
extends TRAbstractForm<T> {
    protected static final Logger L = LoggerFactory.getLogger(GxUserTaskForm.class);
    private static final long serialVersionUID = 1L;
    private GxUserTask userTask;
    private MButton approveButton;
    private MButton rejectButton;
    private MButton completeButton;
    private MButton skipButton;
    private MButton assignButton;
    public Set<GxTaskActionListener<T>> listeners = new HashSet<GxTaskActionListener<T>>();

    protected boolean eagerValidationEnabled() {
        return true;
    }

    protected String formTitle() {
        if (this.getUserTask() != null) {
            return this.getUserTask().getName();
        }
        return "User Task";
    }

    public void initializeWithTask(GxUserTask userTask) {
        this.userTask = userTask;
    }

    protected String completeButtonCaption() {
        return "Complete";
    }

    protected String rejectButtonCaption() {
        return "Reject";
    }

    protected String approveButtonCaption() {
        return "Approve";
    }

    protected void addButtonsToFooter(MHorizontalLayout footer) {
        this.approveButton = new MButton(this.approveButtonCaption()).withStyleName(new String[]{"friendly"}).withListener((Button.ClickListener & Serializable)event -> this.approveTask());
        this.rejectButton = new MButton(this.rejectButtonCaption()).withStyleName(new String[]{"danger"}).withListener((Button.ClickListener & Serializable)event -> this.rejectTask());
        this.completeButton = new MButton(this.completeButtonCaption()).withStyleName(new String[]{"friendly"}).withListener((Button.ClickListener & Serializable)event -> this.completeTask());
        this.skipButton = new MButton("Skip").withListener((Button.ClickListener & Serializable)event -> this.skipTask());
        this.assignButton = new MButton("Assign").withListener((Button.ClickListener & Serializable)event -> this.assignTask());
        MHorizontalLayout taskButtonsLayout = new MHorizontalLayout();
        if (this.isApprovalForm()) {
            taskButtonsLayout.addComponents(new Component[]{this.approveButton, this.rejectButton, this.skipButton, this.assignButton});
        } else {
            taskButtonsLayout.addComponents(new Component[]{this.completeButton, this.skipButton, this.assignButton});
        }
        footer.setWidth("100%");
        footer.addComponentAsFirst((Component)taskButtonsLayout);
    }

    @Transactional
    private void rejectTask() {
        final HashMap<String, Object> taskData = new HashMap<String, Object>();
        this.onReject(taskData, this.getEntity(), new GxUserTaskHandler(){

            @Override
            public void proceed() {
                try {
                    GxUserTaskForm.this.getUserTask().complete(taskData);
                    GxUserTaskForm.this.onPostReject(GxUserTaskForm.this.getEntity());
                    GxUserTaskForm.this.notifyGxTaskActionListeners(GxTaskAction.REJECTED, GxUserTaskForm.this.getUserTask(), GxUserTaskForm.this.getEntity());
                    GxUserTaskForm.this.closePopup();
                }
                catch (Exception ex) {
                    String message = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
                    GxNotification.closable((String)"Task Error", (String)message, (Notification.Type)Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    L.error(ex.getMessage(), (Throwable)ex);
                }
            }

            @Override
            public void cancel() {
                GxUserTaskForm.this.closePopup();
            }

            @Override
            public void error(Throwable t) {
                String message = t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
                GxNotification.closable(null, (String)message, (Notification.Type)Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
            }
        });
    }

    protected void onReject(Map<String, Object> taskData, T entity, GxUserTaskHandler handler) {
    }

    @Transactional
    private void approveTask() {
        final HashMap<String, Object> taskData = new HashMap<String, Object>();
        this.onApprove(taskData, this.getEntity(), new GxUserTaskHandler(){

            @Override
            public void proceed() {
                try {
                    GxUserTaskForm.this.getUserTask().complete(taskData);
                    GxUserTaskForm.this.onPostApprove(GxUserTaskForm.this.getEntity());
                    GxUserTaskForm.this.notifyGxTaskActionListeners(GxTaskAction.APPROVED, GxUserTaskForm.this.getUserTask(), GxUserTaskForm.this.getEntity());
                    GxUserTaskForm.this.closePopup();
                }
                catch (Exception ex) {
                    String message = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
                    GxNotification.closable((String)"Task Error", (String)message, (Notification.Type)Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    L.error(ex.getMessage(), (Throwable)ex);
                }
            }

            @Override
            public void cancel() {
                GxUserTaskForm.this.closePopup();
            }

            @Override
            public void error(Throwable t) {
                String message = t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
                GxNotification.closable(null, (String)message, (Notification.Type)Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
            }
        });
    }

    protected void onApprove(Map<String, Object> taskData, T entity, GxUserTaskHandler handler) {
    }

    @Transactional
    private void assignTask() {
        this.onAssign(this.getEntity(), new GxUserTaskAssigner(){

            @Override
            public void assign(Collection<GxAssignee> assignees) {
                if (assignees != null && !assignees.isEmpty()) {
                    GxSelectAssigneeForm assigneeForm = new GxSelectAssigneeForm();
                    assigneeForm.setEntity(GxSelectAssigneeForm.GxAssigneeHolder.class, new GxSelectAssigneeForm.GxAssigneeHolder());
                    assigneeForm.initializeWithAssignees(assignees);
                    assigneeForm.setSavedHandler((TRAbstractBaseForm.SavedHandler & Serializable)holder -> ConfirmDialog.show((UI)UI.getCurrent(), (String)"Confirmation", (String)("Are you sure to assign the task to " + holder.getAssignee() + "?"), (String)"Yes", (String)"No", (ConfirmDialog.Listener & Serializable)dlg -> {
                        if (dlg.isConfirmed()) {
                            GxAssignee assignee = holder.getAssignee();
                            try {
                                GxUserTaskForm.this.getUserTask().assign(assignee.getUsername());
                                GxUserTaskForm.this.onPostAssign(assignee, GxUserTaskForm.this.getEntity());
                                GxUserTaskForm.this.notifyGxTaskActionListeners(GxTaskAction.ASSIGNED, GxUserTaskForm.this.getUserTask(), GxUserTaskForm.this.getEntity());
                                assigneeForm.closePopup();
                                GxUserTaskForm.this.closePopup();
                            }
                            catch (GxAssignTaskException ex) {
                                GxNotification.closable((String)"Task Error", (String)ex.getMessage(), (Notification.Type)Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
                                L.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                    }));
                    assigneeForm.openInModalPopup();
                } else {
                    GxNotification.closable(null, (String)"No potential assignees are available to handle this task.", (Notification.Type)Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
                }
            }

            @Override
            public void cancel() {
                GxUserTaskForm.this.closePopup();
            }

            @Override
            public void error(Throwable t) {
                String message = t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
                GxNotification.closable(null, (String)message, (Notification.Type)Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
            }
        });
    }

    protected void onAssign(T entity, GxUserTaskAssigner assigner) {
    }

    @Transactional
    private void skipTask() {
        this.onSkip(this.getEntity(), new GxUserTaskSkipper(){

            @Override
            public void skip() {
                try {
                    GxUserTaskForm.this.getUserTask().skip();
                    GxUserTaskForm.this.onPostSkip(GxUserTaskForm.this.getEntity());
                    GxUserTaskForm.this.notifyGxTaskActionListeners(GxTaskAction.SKIPPED, GxUserTaskForm.this.getUserTask(), GxUserTaskForm.this.getEntity());
                    GxUserTaskForm.this.closePopup();
                }
                catch (Exception ex) {
                    String message = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
                    GxNotification.closable((String)"Task Error", (String)message, (Notification.Type)Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    L.error(ex.getMessage(), (Throwable)ex);
                }
            }

            @Override
            public void cancel() {
                GxUserTaskForm.this.closePopup();
            }

            @Override
            public void error(Throwable t) {
                String message = t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
                GxNotification.closable(null, (String)message, (Notification.Type)Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
            }
        });
    }

    protected void onSkip(T entity, GxUserTaskSkipper skipper) {
    }

    @Transactional
    private void completeTask() {
        final HashMap<String, Object> taskData = new HashMap<String, Object>();
        this.onComplete(taskData, this.getEntity(), new GxUserTaskHandler(){

            @Override
            public void proceed() {
                try {
                    GxUserTaskForm.this.getUserTask().complete(taskData);
                    GxUserTaskForm.this.onPostComplete(GxUserTaskForm.this.getEntity());
                    GxUserTaskForm.this.notifyGxTaskActionListeners(GxTaskAction.COMPLETED, GxUserTaskForm.this.getUserTask(), GxUserTaskForm.this.getEntity());
                    GxUserTaskForm.this.closePopup();
                }
                catch (Exception ex) {
                    String message = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
                    GxNotification.closable((String)"Task Error", (String)message, (Notification.Type)Notification.Type.ERROR_MESSAGE).show(Page.getCurrent());
                    L.error(ex.getMessage(), (Throwable)ex);
                }
            }

            @Override
            public void cancel() {
                GxUserTaskForm.this.closePopup();
            }

            @Override
            public void error(Throwable t) {
                String message = t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
                GxNotification.closable(null, (String)message, (Notification.Type)Notification.Type.WARNING_MESSAGE).show(Page.getCurrent());
            }
        });
    }

    protected void onComplete(Map<String, Object> taskData, T entity, GxUserTaskHandler handler) {
    }

    private void notifyGxTaskActionListeners(GxTaskAction taskAction, GxUserTask userTask, T entity) {
        this.listeners.forEach(listener -> listener.onAction(taskAction, userTask, entity));
    }

    public Window openInModalPopup() {
        GxUserTask task = this.getUserTask();
        boolean valid = task != null && (task.getStatus() == Status.Ready || task.getStatus() == Status.Reserved || task.getStatus() == Status.InProgress || task.getStatus() == Status.Created);
        Window popup = super.openInModalPopup();
        this.approveButton.setCaption(this.approveButtonCaption());
        this.approveButton.setVisible(valid);
        this.rejectButton.setCaption(this.rejectButtonCaption());
        this.rejectButton.setVisible(valid);
        this.completeButton.setCaption(this.completeButtonCaption());
        this.completeButton.setVisible(valid);
        this.skipButton.setVisible(valid && this.getUserTask().isSkipable() != false);
        this.assignButton.setVisible(valid && this.isAssignable());
        return popup;
    }

    protected void onPostApprove(T entity) throws GxCompleteTaskException {
    }

    protected void onPostReject(T entity) throws GxCompleteTaskException {
    }

    protected void onPostComplete(T entity) throws GxCompleteTaskException {
    }

    protected void onPostAssign(GxAssignee assignee, T entity) throws GxAssignTaskException {
    }

    protected void onPostSkip(T entity) throws GxSkipTaskException {
    }

    public void addTaskActionListener(GxTaskActionListener<T> listener) {
        this.listeners.add(listener);
    }

    protected abstract boolean isApprovalForm();

    protected abstract boolean isAssignable();

    public GxUserTask getUserTask() {
        assert (this.userTask != null);
        return this.userTask;
    }

    protected void adjustSaveButtonState() {
        super.adjustSaveButtonState();
        boolean valid = this.isValid();
        this.approveButton.setEnabled(valid);
        this.rejectButton.setEnabled(valid);
        this.completeButton.setEnabled(valid);
    }

    public static interface GxUserTaskSkipper {
        public void skip();

        public void cancel();

        public void error(Throwable var1);
    }

    public static interface GxUserTaskAssigner {
        public void assign(Collection<GxAssignee> var1);

        public void cancel();

        public void error(Throwable var1);
    }

    public static interface GxUserTaskHandler {
        public void proceed();

        public void cancel();

        public void error(Throwable var1);
    }

    public static enum GxTaskAction {
        APPROVED,
        REJECTED,
        COMPLETED,
        ASSIGNED,
        SKIPPED;

    }

    public static interface GxTaskActionListener<T> {
        public void onAction(GxTaskAction var1, GxUserTask var2, T var3);
    }
}

