/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.jbpm.embedded.service.impl;

import io.graphenee.jbpm.embedded.service.GxKieService;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.strategy.PersistenceStrategyType;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="jbpmTransactionManager")
public class GxKieServiceImpl
implements GxKieService {
    @Autowired
    @Qualifier(value="jbpmEntityManagerFactory")
    EntityManagerFactory emf;
    JPAAuditLogService auditLogService;

    public JPAAuditLogService getAuditLogService() {
        if (this.auditLogService == null) {
            this.auditLogService = new JPAAuditLogService(this.emf, PersistenceStrategyType.STANDALONE_LOCAL_SPRING_SHARED_EM);
        }
        return this.auditLogService;
    }

    @Override
    public Object getVariableValue(Long processInstanceId, String variableName) {
        List variables = this.getAuditLogService().findVariableInstances(processInstanceId.longValue());
        VariableInstanceLog found = null;
        for (VariableInstanceLog variable : variables) {
            System.err.println(variable.getVariableId() + "=" + variable.getValue() + ",old=" + variable.getOldValue() + ",time=" + variable.getDate());
            if (!variable.getVariableId().equals(variableName)) continue;
            found = variable;
        }
        if (found != null) {
            return found.getValue();
        }
        return null;
    }

    @Override
    public Object getVariableValue(Long processInstanceId, String variableName, Object defaultValue) {
        Object value = this.getVariableValue(processInstanceId, variableName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public <T> T getVariableValue(Long processInstanceId, String variableName, Class<? extends T> variableType) {
        Object variableValue = this.getVariableValue(processInstanceId, variableName);
        if (variableValue != null) {
            return variableType.cast(variableValue);
        }
        return null;
    }

    @Override
    public Long getVariableValueAsLong(Long processInstanceId, String variableName, Long defaultValue) {
        Object variableValue = this.getVariableValue(processInstanceId, variableName);
        if (variableValue != null) {
            return Long.parseLong(variableValue.toString());
        }
        return defaultValue;
    }

    @Override
    public <T> T getVariableValue(Long processInstanceId, String variableName, Class<? extends T> variableType, T defaultValue) {
        Object variableValue = this.getVariableValue(processInstanceId, variableName);
        if (variableValue != null) {
            return variableType.cast(variableValue);
        }
        return defaultValue;
    }
}

