/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.jbpm.embedded;

import io.graphenee.core.GrapheneeCoreConfiguration;
import io.graphenee.core.util.DataSourceUtil;
import io.graphenee.jbpm.embedded.GrapheneeJbpmProperties;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.hibernate.dialect.Dialect;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;

@Configuration
@ConditionalOnClass(value={GrapheneeCoreConfiguration.class})
@ComponentScan(value={"io.graphenee.jbpm.embedded"})
public class GrapheneeJbpmConfiguration {
    @Autowired(required=false)
    GrapheneeJbpmProperties grapheneeJbpmProperties;
    @Value(value="${flyway.enabled:false}")
    boolean flywayEnabled;

    @PostConstruct
    public void init() {
        if (this.flywayEnabled) {
            DataSource dsFlyway = this.grapheneeJbpmProperties().getDataSource();
            String dbVendor = DataSourceUtil.determineDbVendor((DataSource)dsFlyway);
            FluentConfiguration config = Flyway.configure().dataSource(dsFlyway).locations(new String[]{"classpath:db/jbpm/migration/" + dbVendor}).table("jbpm_schema_version").baselineOnMigrate(true).baselineVersion("0");
            Flyway flyway = new Flyway((org.flywaydb.core.api.configuration.Configuration)config);
            flyway.migrate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GrapheneeJbpmProperties grapheneeJbpmProperties() {
        if (this.grapheneeJbpmProperties != null) return this.grapheneeJbpmProperties;
        Class<GrapheneeJbpmConfiguration> clazz = GrapheneeJbpmConfiguration.class;
        synchronized (GrapheneeJbpmConfiguration.class) {
            if (this.grapheneeJbpmProperties != null) return this.grapheneeJbpmProperties;
            this.grapheneeJbpmProperties = new GrapheneeJbpmProperties();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.grapheneeJbpmProperties;
        }
    }

    @Bean(value={"jbpmTransactionManager"})
    public JpaTransactionManager jbpmTransactionManager(@Qualifier(value="jbpmEntityManagerFactory") EntityManagerFactory jbpmEntityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(jbpmEntityManagerFactory);
        return tm;
    }

    @Bean(value={"jbpmEntityManagerFactory"})
    public EntityManagerFactory jbpmEntityManagerFactory() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        DataSource ds = this.grapheneeJbpmProperties().getDataSource();
        em.setDataSource(ds);
        em.setPackagesToScan(new String[]{"org.jbpm", "org.drools"});
        em.setPersistenceUnitName("org.jbpm.persistence.jpa");
        em.setPersistenceProviderClass(HibernatePersistenceProvider.class);
        em.setJpaDialect((JpaDialect)new HibernateJpaDialect());
        em.setMappingResources(new String[]{"META-INF/JBPMorm.xml", "META-INF/Taskorm.xml", "META-INF/TaskAuditorm.xml"});
        em.getJpaPropertyMap().put("hibernate.max_fetch_depth", "3");
        em.getJpaPropertyMap().put("hibernate.show_sql", "false");
        Dialect dialect = DataSourceUtil.determineDialect((DataSource)ds);
        em.getJpaPropertyMap().put("hibernate.dialect", dialect);
        em.getJpaPropertyMap().put("hibernate.id.new_generator_mappings", "false");
        em.getJpaPropertyMap().put("hibernate.transaction.jta.platform", "org.hibernate.service.jta.platform.internal.BitronixJtaPlatform");
        em.afterPropertiesSet();
        return em.getObject();
    }
}

