/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.blockchain.sawtooth;

import com.google.gson.JsonObject;
import com.google.protobuf.ByteString;
import io.graphenee.blockchain.sawtooth.SawtoothRestService;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.bitcoinj.core.ECKey;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.protobuf.ProtoConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;
import sawtooth.sdk.processor.Utils;
import sawtooth.sdk.protobuf.Batch;
import sawtooth.sdk.protobuf.BatchHeader;
import sawtooth.sdk.protobuf.BatchList;
import sawtooth.sdk.protobuf.Transaction;
import sawtooth.sdk.protobuf.TransactionHeader;
import sawtooth.sdk.signing.Context;
import sawtooth.sdk.signing.CryptoFactory;
import sawtooth.sdk.signing.PrivateKey;
import sawtooth.sdk.signing.Secp256k1PrivateKey;

public class SawtoothClient {
    private SawtoothRestService service;
    private ECKey transactionSignerECKey;
    private ECKey batchSignerECKey;

    public SawtoothClient(String endpoint) {
        Retrofit.Builder rb = new Retrofit.Builder().addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addConverterFactory((Converter.Factory)ProtoConverterFactory.create());
        this.service = (SawtoothRestService)rb.baseUrl(endpoint).build().create(SawtoothRestService.class);
    }

    public void setSignerPrivateKey(byte[] keyAsBytes) {
        this.setTransactionSignerPrivateKey(keyAsBytes);
        this.setBatchSignerPrivateKey(keyAsBytes);
    }

    public void setTransactionSignerPrivateKey(byte[] keyAsBytes) {
        this.transactionSignerECKey = ECKey.fromPrivate((byte[])keyAsBytes);
    }

    public void setBatchSignerPrivateKey(byte[] keyAsBytes) {
        this.batchSignerECKey = ECKey.fromPrivate((byte[])keyAsBytes);
    }

    public void submitTransaction(String familyName, String version, Collection<String> inputAddress, Collection<String> outputAddress, byte[] payload) {
        try {
            Secp256k1PrivateKey transactionSignerPrivateKey = Secp256k1PrivateKey.fromHex((String)this.transactionSignerECKey.getPrivateKeyAsHex());
            Secp256k1PrivateKey batchSignerPrivateKey = Secp256k1PrivateKey.fromHex((String)this.batchSignerECKey.getPrivateKeyAsHex());
            Context ctx = CryptoFactory.createContext((String)"secp256k1");
            String encodedPayload = Utils.hash512((byte[])payload);
            TransactionHeader transactionHeader = TransactionHeader.newBuilder().setFamilyName(familyName).setFamilyVersion(version).setSignerPublicKey(this.transactionSignerECKey.getPublicKeyAsHex()).setBatcherPublicKey(this.batchSignerECKey.getPublicKeyAsHex()).setPayloadSha512(encodedPayload).setNonce(UUID.randomUUID().toString()).addAllInputs(inputAddress).addAllOutputs(outputAddress).build();
            String transactionHeaderSignature = ctx.sign(transactionHeader.toByteArray(), (PrivateKey)transactionSignerPrivateKey);
            Transaction transaction = Transaction.newBuilder().setHeader(transactionHeader.toByteString()).setHeaderSignature(transactionHeaderSignature).setPayload(ByteString.copyFrom((byte[])payload)).build();
            BatchHeader batchHeader = BatchHeader.newBuilder().setSignerPublicKey(this.batchSignerECKey.getPublicKeyAsHex()).addTransactionIds(transactionHeaderSignature).build();
            String batchHeaderSignature = ctx.sign(batchHeader.toByteArray(), (PrivateKey)batchSignerPrivateKey);
            Batch batch = Batch.newBuilder().setHeader(batchHeader.toByteString()).setHeaderSignature(batchHeaderSignature).addTransactions(transaction).build();
            BatchList batchList = BatchList.newBuilder().addBatches(batch).build();
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])batchList.toByteArray());
            Call<JsonObject> call = this.service.sendBatches(body);
            Response response = call.execute();
            System.err.println(response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SawtoothClient cli = new SawtoothClient("http://localhost:8008");
        PrivateKey privateKey = CryptoFactory.createContext((String)"secp256k1").newRandomPrivateKey();
        cli.setSignerPrivateKey(privateKey.getBytes());
        String address = Utils.hash512((byte[])"adp".getBytes()).substring(0, 6) + Utils.hash512((byte[])"farrukh".getBytes()).substring(0, 64);
        System.err.println(address);
        cli.submitTransaction("adp", "1.0", Arrays.asList(address), Arrays.asList(address), "Hello Universe!".getBytes());
    }
}

