/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.exception.CattleException;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.cattleframework.utils.auxiliary.DataConvertUtils;
import org.cattleframework.utils.reflect.constant.ClassType;

public final class ReflectUtils {
    private ReflectUtils() {
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        return ReflectUtils.getField(clazz, fieldName, true);
    }

    public static Field getField(Class<?> clazz, String fieldName, boolean throwNotFound) {
        Field field;
        block6: {
            if (clazz == null) {
                throw new CattleException("\u7c7b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                throw new CattleException("\u5b57\u6bb5\u540d\u4e3a\u7a7a");
            }
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (SecurityException e) {
                throw ExceptionWrapUtils.wrap((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                if (clazz.getSuperclass() == Object.class) break block6;
                field = ReflectUtils.getField(clazz.getSuperclass(), fieldName, false);
            }
        }
        if (field == null && throwNotFound) {
            throw new CattleException("\u5728\u7c7b'" + clazz.getName() + "'\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5'" + fieldName + "'");
        }
        return field;
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        if (obj == null) {
            throw new CattleException("\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (field == null) {
            throw new CattleException("\u5b57\u6bb5\u4e3a\u7a7a");
        }
        if (!field.trySetAccessible()) {
            throw new CattleException("\u4e0d\u80fd\u8bbe\u7f6e\u5b57\u6bb5'" + field.getName() + "'\u7684\u503c");
        }
        try {
            Object convertValue = null;
            if (value != null) {
                ClassType type;
                convertValue = DataConvertUtils.convertValue(type, (type = ReflectUtils.getClassType(field.getType())) == ClassType.Array ? field.getType().getComponentType() : (type == ClassType.Enum || type == ClassType.ClassObject ? field.getType() : null), value);
            }
            field.set(obj, convertValue);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectUtils.getField(obj.getClass(), fieldName);
        ReflectUtils.setFieldValue(obj, field, value);
    }

    public static ClassType getClassType(Class<?> typeCls) {
        ClassType type = null;
        type = typeCls.isArray() ? ClassType.Array : (typeCls.isEnum() ? ClassType.Enum : (typeCls == Long.class || typeCls == Long.TYPE ? ClassType.Long : (typeCls == Integer.class || typeCls == Integer.TYPE ? ClassType.Int : (typeCls == Double.class || typeCls == Double.TYPE ? ClassType.Double : (typeCls == String.class ? ClassType.String : (typeCls == Boolean.class || typeCls == Boolean.TYPE ? ClassType.Boolean : (typeCls == Date.class ? ClassType.SqlDate : (typeCls == Time.class ? ClassType.Time : (typeCls == Timestamp.class ? ClassType.Timestamp : (typeCls == java.util.Date.class ? ClassType.Date : (List.class.isAssignableFrom(typeCls) ? ClassType.List : (Map.class.isAssignableFrom(typeCls) ? ClassType.Map : (typeCls == Byte.class || typeCls == Byte.TYPE ? ClassType.Byte : (typeCls == Character.class || typeCls == Character.TYPE ? ClassType.Char : (typeCls == Short.class || typeCls == Short.TYPE ? ClassType.Short : (typeCls == BigDecimal.class ? ClassType.BigDecimal : (typeCls == BigInteger.class ? ClassType.BigInteger : (typeCls == Class.class ? ClassType.Class : (typeCls == Object.class ? ClassType.Object : ClassType.ClassObject)))))))))))))))))));
        return type;
    }

    public static Object setEnumValue(Class<?> clazz, String value) {
        if (clazz == null) {
            throw new CattleException("\u7c7b\u4e3a\u7a7a");
        }
        if (!clazz.isEnum()) {
            throw new CattleException("\u7c7b'" + clazz.getCanonicalName() + "'\u4e0d\u662f\u679a\u4e3e");
        }
        Method valuesMethod = ReflectUtils.getMethod(clazz, "values", new Class[0]);
        Object values = ReflectUtils.invokeMethod(valuesMethod, new Object[0]);
        int valuesSize = Array.getLength(values);
        boolean isFound = false;
        for (int i = 0; i < valuesSize; ++i) {
            String enumValue = Array.get(values, i).toString();
            if (!enumValue.equals(value)) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            throw new CattleException("\u503c'" + value + "'\u4e0d\u5c5e\u4e8e\u679a\u4e3e'" + clazz.getCanonicalName() + "'\u4e2d\u7684\u5185\u5bb9");
        }
        Method valueOfMethod = ReflectUtils.getMethod(clazz, "valueOf", String.class);
        return ReflectUtils.invokeMethod(valueOfMethod, value);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectUtils.getMethod(clazz, methodName, true, parameterTypes);
    }

    private static Method getMethod(Class<?> clazz, String methodName, boolean throwNotFound, Class<?> ... parameterTypes) {
        Method method;
        block6: {
            if (clazz == null) {
                throw new CattleException("\u7c7b\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)methodName)) {
                throw new CattleException("\u65b9\u6cd5\u4e3a\u7a7a");
            }
            method = null;
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (SecurityException e) {
                throw ExceptionWrapUtils.wrap((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                if (clazz.getSuperclass() == Object.class) break block6;
                method = ReflectUtils.getMethod(clazz.getSuperclass(), methodName, false, parameterTypes);
            }
        }
        if (method == null && throwNotFound) {
            throw new CattleException("\u5728\u7c7b'" + clazz.getCanonicalName() + "'\u4e2d\u6ca1\u6709\u627e\u5230\u65b9\u6cd5'" + methodName + "'");
        }
        return method;
    }

    public static Method findSetMethod(Class<?> clazz, String name) {
        if (clazz == null) {
            throw new CattleException("\u7c7b\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new CattleException("\u540d\u79f0\u4e3a\u7a7a");
        }
        Method[] methods = clazz.getDeclaredMethods();
        String methodName = "set" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        Method targetMethod = Arrays.stream(methods).filter(method -> method.getName().equals(methodName) && method.getParameterCount() == 1).findFirst().orElse(null);
        if (targetMethod == null) {
            String methodName2 = "set" + name.toUpperCase(Locale.ENGLISH);
            targetMethod = Arrays.stream(methods).filter(m -> m.getName().equals(methodName2) && m.getParameterCount() == 1).findFirst().orElse(null);
        }
        if (targetMethod == null && clazz.getSuperclass() != Object.class) {
            targetMethod = ReflectUtils.findSetMethod(clazz.getSuperclass(), name);
        }
        return targetMethod;
    }

    public static Object invokeMethod(Method method, Object ... args) {
        return ReflectUtils.invokeObjectMethod(method, null, args);
    }

    public static Object invokeObjectMethod(Method method, Object target, Object ... args) {
        if (method == null) {
            throw new CattleException("\u65b9\u6cd5\u4e3a\u7a7a");
        }
        if (!method.trySetAccessible()) {
            throw new CattleException("\u4e0d\u80fd\u6267\u884c\u65b9\u6cd5'" + method.getName() + "'");
        }
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw ExceptionWrapUtils.wrap((Throwable)e.getCause());
            }
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = ReflectUtils.getField(obj.getClass(), fieldName);
        return ReflectUtils.getFieldValue(obj, field);
    }

    public static Object getFieldValue(Object obj, Field field) {
        if (field == null) {
            throw new CattleException("\u5b57\u6bb5\u4e3a\u7a7a");
        }
        if (!field.trySetAccessible()) {
            throw new CattleException("\u4e0d\u80fd\u83b7\u53d6\u5b57\u6bb5'" + field.getName() + "'\u7684\u503c");
        }
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static Set<Field> getFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        Field[] clsFields = clazz.getDeclaredFields();
        Arrays.stream(clsFields).forEach(clsField -> {
            int mod = clsField.getModifiers();
            if (!Modifier.isStatic(mod) && !Modifier.isFinal(mod)) {
                fields.add((Field)clsField);
            }
        });
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class) {
            fields.addAll(ReflectUtils.getFields(clazz.getSuperclass()));
        }
        return fields;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotationClass) {
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null && Object.class != clazz.getSuperclass()) {
            annotation = ReflectUtils.getAnnotation(clazz.getSuperclass(), annotationClass);
        }
        return annotation;
    }
}

