/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.cattleframework.exception.CattleException;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public final class ClassUtils {
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static Objenesis objenesis = new ObjenesisStd(true);

    private ClassUtils() {
    }

    public static <T> T instanceEmpty(Class<T> type) {
        return (T)objenesis.newInstance(type);
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            return superclass;
        }
        return clazz;
    }

    public static <T> Class<T> getTypeClass(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            return ClassUtils.getTypeClass(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return ClassUtils.getTypeClass(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new CattleException("\u4e0d\u80fd\u83b7\u5f97java\u7c7b\u578b\u7684\u7c7b,\u4ece\u7c7b: " + type);
    }

    public static Class<?> getClass(String className, boolean ignoreException) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            if (ignoreException) {
                return null;
            }
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static Class<?> getClass(String className) {
        return ClassUtils.getClass(className, false);
    }
}

