/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.redis;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.StringUtils;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;

public class RedisTemplateUtils {
    private RedisTemplate<String, Object> redisTemplate;

    public RedisTemplateUtils(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void hmset(String key, Map<String, Object> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    public void hset(String key, Object hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, value);
    }

    public boolean hexists(String key, Object hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, hashKey);
    }

    public Map<Object, Object> hgetall(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public List<Object> hvals(String key) {
        return this.redisTemplate.opsForHash().values((Object)key);
    }

    public Set<Object> hkeys(String key) {
        return this.redisTemplate.opsForHash().keys((Object)key);
    }

    public List<Object> hmget(String key, Collection<Object> hashKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hashKeys);
    }

    public boolean hsetnx(String key, Object hashKey, Object value) {
        return this.redisTemplate.opsForHash().putIfAbsent((Object)key, hashKey, value);
    }

    public Long hdel(String key, Object ... hashKeys) {
        return this.redisTemplate.opsForHash().delete((Object)key, hashKeys);
    }

    public Object hget(String key, Object hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, hashKey);
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void set(String key, Object value, long seconds) {
        this.redisTemplate.opsForValue().set((Object)key, value, seconds, TimeUnit.SECONDS);
    }

    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public Boolean del(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    public Long del(Collection<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    public Long strlen(String key) {
        return this.redisTemplate.opsForValue().size((Object)key);
    }

    public Object getset(String key, Object value) {
        return this.redisTemplate.opsForValue().getAndSet((Object)key, value);
    }

    public String getrange(String key, long start, long end) {
        return this.redisTemplate.opsForValue().get((Object)key, start, end);
    }

    public Integer append(String key, String value) {
        return this.redisTemplate.opsForValue().append((Object)key, value);
    }

    public Long lpush(String key, Object ... values) {
        return this.redisTemplate.opsForList().leftPushAll((Object)key, values);
    }

    public Long rpush(String key, Object ... values) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, values);
    }

    public Object lindex(String key, long index) {
        return this.redisTemplate.opsForList().index((Object)key, index);
    }

    public Long llen(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public Object lpop(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public Object rpop(String key) {
        return this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public Long lpushx(String key, Object value) {
        return this.redisTemplate.opsForList().leftPushIfPresent((Object)key, value);
    }

    public Long rpushx(String key, Object value) {
        return this.redisTemplate.opsForList().rightPushIfPresent((Object)key, value);
    }

    public List<Object> lrange(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public Long lrem(String key, long count, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, count, value);
    }

    public void lset(String key, long index, Object value) {
        this.redisTemplate.opsForList().set((Object)key, index, value);
    }

    public Long sadd(String key, Object ... values) {
        return this.redisTemplate.opsForSet().add((Object)key, values);
    }

    public Long scard(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    public Set<Object> sidff(Collection<String> keys) {
        return this.redisTemplate.opsForSet().difference(keys);
    }

    public Set<Object> sinter(Collection<String> keys) {
        return this.redisTemplate.opsForSet().intersect(keys);
    }

    public Set<Object> sunion(Collection<String> keys) {
        return this.redisTemplate.opsForSet().union(keys);
    }

    public Long sdiffstore(String key, String otherKey, String destKey) {
        return this.redisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long sinterstore(String key, String otherKey, String destKey) {
        return this.redisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long sunionstore(String key, String otherKey, String destKey) {
        return this.redisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Boolean sismember(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public Set<Object> smembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public Object spop(String key) {
        return this.redisTemplate.opsForSet().pop((Object)key);
    }

    public Object srandmember(String key) {
        return this.redisTemplate.opsForSet().randomMember((Object)key);
    }

    public List<Object> srandmember(String key, long count) {
        return this.redisTemplate.opsForSet().randomMembers((Object)key, count);
    }

    public Long srem(String key, Object ... values) {
        return this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Set<String> keys(String pattern) {
        return (Set)this.redisTemplate.execute(connection -> {
            HashSet<String> keys = new HashSet<String>();
            try (Cursor cursor = connection.keyCommands().scan(ScanOptions.scanOptions().match(pattern).count(Long.MAX_VALUE).build());){
                while (cursor.hasNext()) {
                    keys.add(StringUtils.newStringUtf8((byte[])((byte[])cursor.next())));
                }
            }
            return keys;
        });
    }
}

