/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.redis;

import java.nio.charset.StandardCharsets;
import org.cattleframework.aop.annotation.GuiceBindBean;
import org.cattleframework.utils.redis.CustomRedisSerializer;
import org.cattleframework.utils.redis.RedisTemplateUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@ConditionalOnClass(value={RedisOperations.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedisAutoConfiguration {
    @Bean
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        CustomRedisSerializer customRedisSerializer = new CustomRedisSerializer();
        redisTemplate.setValueSerializer((RedisSerializer)customRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)customRedisSerializer);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer(StandardCharsets.UTF_8);
        redisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        return redisTemplate;
    }

    @Bean
    @GuiceBindBean
    public RedisTemplateUtils redisTemplateUtils(RedisTemplate<String, Object> redisTemplate) {
        return new RedisTemplateUtils(redisTemplate);
    }
}

