/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.redis;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.cattleframework.exception.CattleException;
import org.cattleframework.utils.auxiliary.CompressUtils;
import org.cattleframework.utils.auxiliary.ObjectUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class CustomRedisSerializer
implements RedisSerializer<Object> {
    public byte[] serialize(Object object) throws SerializationException {
        byte[] bytes = ObjectUtils.serialize(object);
        return StringUtils.getBytesUtf8((String)Hex.encodeHexString((byte[])CompressUtils.compress("gz", bytes)));
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return ObjectUtils.deserialize(CompressUtils.decompress("gz", Hex.decodeHex((String)StringUtils.newStringUtf8((byte[])bytes))));
        }
        catch (DecoderException e) {
            throw new CattleException("\u4e0d\u80fd\u591f\u88ab\u89e3\u7801:" + e.getMessage(), (Throwable)e);
        }
    }
}

