/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.http;

import java.net.ConnectException;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.cattleframework.exception.CattleException;
import org.cattleframework.exception.CattleResponseException;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtils {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateUtils.class);
    private static final String MESSAGE = "message";
    private static final String EXCEPTION_CODE = "error-code";
    private static final String EXCEPTION_RESPONSE = "response";
    private static final String MESSAGE_SOURCE = "source";
    private static final String SOURCE_OWNER = "cattle";
    private final RestTemplate restTemplate;

    public RestTemplateUtils(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public <T, R> T post(String url, MediaType type, Map<String, String> headers, R request, ParameterizedTypeReference<T> responseType) {
        HttpHeaders httpHeaders = this.getHeaders(type, headers);
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
            return (T)responseEntity.getBody();
        }
        catch (Throwable e) {
            throw this.throwException(e);
        }
    }

    public <T, R> T post(String url, MediaType type, Map<String, String> headers, R request, Class<T> responseType) {
        HttpHeaders httpHeaders = this.getHeaders(type, headers);
        HttpEntity requestEntity = new HttpEntity(request, (MultiValueMap)httpHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
            return (T)responseEntity.getBody();
        }
        catch (Throwable e) {
            throw this.throwException(e);
        }
    }

    private HttpHeaders getHeaders(MediaType type, Map<String, String> headers) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (type != null) {
            httpHeaders.setContentType(type);
        }
        if (MapUtils.isNotEmpty(headers)) {
            for (String header : headers.keySet()) {
                httpHeaders.add(header, headers.get(header));
            }
        }
        return httpHeaders;
    }

    public <T> T get(String url, MediaType type, Map<String, String> headers, ParameterizedTypeReference<T> responseType) {
        return this.get(url, type, headers, responseType, null);
    }

    public <T> T get(String url, MediaType type, Map<String, String> headers, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = this.getHeaders(type, headers);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)httpHeaders);
        try {
            ResponseEntity responseEntity = MapUtils.isNotEmpty(uriVariables) ? this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables) : this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, new Object[0]);
            return (T)responseEntity.getBody();
        }
        catch (Throwable e) {
            throw this.throwException(e);
        }
    }

    public <T> T get(String url, MediaType type, Map<String, String> headers, Class<T> responseType) {
        return this.get(url, type, headers, responseType, null);
    }

    public <T> T get(String url, MediaType type, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = this.getHeaders(type, headers);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)httpHeaders);
        try {
            ResponseEntity responseEntity = MapUtils.isNotEmpty(uriVariables) ? this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables) : this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, responseType, new Object[0]);
            return (T)responseEntity.getBody();
        }
        catch (Throwable e) {
            throw this.throwException(e);
        }
    }

    private CattleException throwException(Throwable e) {
        ResourceAccessException ex;
        if (e instanceof RestClientResponseException) {
            RestClientResponseException ex2 = (RestClientResponseException)e;
            return this.throwRestClientResponseException(ex2);
        }
        if (e instanceof IllegalStateException) {
            return new CattleException(Integer.valueOf(1), e.getMessage(), e);
        }
        if (e instanceof ResourceAccessException && (ex = (ResourceAccessException)e).getCause() != null && ex.getCause() instanceof ConnectException) {
            return new CattleException(Integer.valueOf(1), e.getMessage(), e);
        }
        return ExceptionWrapUtils.wrap((Throwable)e);
    }

    private CattleException throwRestClientResponseException(RestClientResponseException e) {
        CattleResponseException exception = null;
        int exceptionCode = 0;
        if (e.getStatusCode().isSameCodeAs((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE)) {
            exceptionCode = 1;
        } else {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (e.getResponseHeaders().containsKey((Object)MESSAGE_SOURCE) && SOURCE_OWNER.equals(e.getResponseHeaders().getFirst(MESSAGE_SOURCE))) {
            Map errorResponse = (Map)e.getResponseBodyAs((ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){});
            String message = (String)errorResponse.get(MESSAGE);
            Integer code = null;
            if (errorResponse.containsKey(EXCEPTION_CODE)) {
                code = (Integer)errorResponse.get(EXCEPTION_CODE);
            }
            if (errorResponse.containsKey(EXCEPTION_RESPONSE)) {
                String response = (String)errorResponse.get(EXCEPTION_RESPONSE);
                exception = code != null ? new CattleResponseException(code, message, response) : new CattleResponseException(message, response);
            } else {
                CattleException cattleException = exception = code != null ? new CattleException(code, message) : new CattleException(message);
            }
        }
        if (exception == null) {
            String responseBody = e.getResponseBodyAsString();
            exception = new CattleResponseException(Integer.valueOf(exceptionCode), e.getMessage(), responseBody);
        }
        return exception;
    }
}

