/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.concurrent;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.exception.CattleException;

public final class NamedThreadFactoryBuilder {
    private String component = null;
    private Boolean daemon = null;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory backingThreadFactory = null;

    public NamedThreadFactoryBuilder setComponent(String component) {
        this.component = component;
        return this;
    }

    public NamedThreadFactoryBuilder setDaemon(Boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public NamedThreadFactoryBuilder setPriority(Integer priority) {
        if (priority < 1) {
            throw new CattleException(String.format("\u7ebf\u7a0b\u4f18\u5148\u7ea7(%s)\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e%s", priority, 1));
        }
        if (priority > 10) {
            throw new CattleException(String.format("\u7ebf\u7a0b\u4f18\u5148\u7ea7(%s)\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e%s", priority, 10));
        }
        this.priority = priority;
        return this;
    }

    public NamedThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public NamedThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        this.backingThreadFactory = backingThreadFactory;
        return this;
    }

    public ThreadFactory build() {
        return NamedThreadFactoryBuilder.doBuild(this);
    }

    private static ThreadFactory doBuild(NamedThreadFactoryBuilder builder) {
        String component = builder.component;
        Boolean daemon = builder.daemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = builder.uncaughtExceptionHandler;
        ThreadFactory backingThreadFactory = builder.backingThreadFactory != null ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        AtomicLong count = new AtomicLong(0L);
        return r -> {
            Thread thread = backingThreadFactory.newThread(r);
            if (thread == null) {
                throw new CattleException("\u7ebf\u7a0b\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)component)) {
                thread.setName(String.format("cattle-%s-%d", component, Objects.requireNonNull(count).getAndIncrement()));
            }
            if (daemon != null) {
                thread.setDaemon(daemon);
            }
            if (priority != null) {
                thread.setPriority(priority);
            }
            if (uncaughtExceptionHandler != null) {
                thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            }
            return thread;
        };
    }
}

