/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.exception.CattleException;
import org.cattleframework.utils.cache.Cache;
import org.cattleframework.utils.cache.CacheManager;

public abstract class AbstractCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();

    protected abstract Cache createCache(String var1, Map<String, String> var2);

    @Override
    public Cache getCache(String name, Map<String, String> props) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new CattleException("\u7f13\u5b58\u5206\u7c7b\u952e\u503c\u4e3a\u7a7a");
        }
        if (!this.caches.containsKey(name)) {
            this.putCache(name, props);
        }
        return (Cache)this.caches.get(name);
    }

    private synchronized void putCache(String name, Map<String, String> props) {
        if (props == null) {
            throw new CattleException("\u7f13\u5b58\u5c5e\u6027\u4e3a\u7a7a");
        }
        Cache cache = this.createCache(name, props);
        if (cache == null) {
            throw new CattleException("\u7f13\u5b58\u5206\u7c7b\u952e\u503c'" + name + "'\u521b\u5efa\u5931\u8d25");
        }
        this.caches.put(name, cache);
    }

    @Override
    public void removeCache(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new CattleException("\u7f13\u5b58\u5206\u7c7b\u952e\u503c\u4e3a\u7a7a");
        }
        if (this.caches.containsKey(name)) {
            Cache cache = (Cache)this.caches.get(name);
            cache.clear();
        }
    }
}

