/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import com.google.common.base.CaseFormat;
import java.math.BigInteger;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.text.RandomStringGenerator;

public final class StringUtils {
    private static final char WILDCARD_MARK = '*';

    private StringUtils() {
    }

    public static String replaceOnce(String template, String placeholder, String replacement) {
        if (template == null) {
            return null;
        }
        int loc = template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        return template.substring(0, loc) + replacement + template.substring(loc + placeholder.length());
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cs1) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cs2)) {
            return true;
        }
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)cs1, (CharSequence)cs2);
    }

    public static String replace(String template, String placeholder, String replacement) {
        return StringUtils.replace(template, placeholder, replacement, false);
    }

    public static String replace(String template, String placeholder, String replacement, boolean wholeWords) {
        int loc = template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        boolean actuallyReplace = !wholeWords || loc + placeholder.length() == template.length() || !Character.isJavaIdentifierPart(template.charAt(loc + placeholder.length()));
        String actualReplacement = actuallyReplace ? replacement : placeholder;
        return new StringBuffer(template.substring(0, loc)).append(actualReplacement).append(StringUtils.replace(template.substring(loc + placeholder.length()), placeholder, replacement, wholeWords)).toString();
    }

    public static String getRandomString(int length) {
        return StringUtils.getRandomString(false, length);
    }

    public static String getRandomString(boolean onlyNumber, int length) {
        char[][] pairs = new char[][]{{'a', 'z'}, {'A', 'Z'}, {'0', '9'}};
        RandomStringGenerator generator = onlyNumber ? new RandomStringGenerator.Builder().withinRange(48, 57).get() : new RandomStringGenerator.Builder().withinRange((char[][])pairs).get();
        return generator.generate(length);
    }

    public static boolean isMatch(String s, String p) {
        int idxs = 0;
        int idxp = 0;
        int idxstar = -1;
        int idxmatch = 0;
        while (idxs < s.length()) {
            if (idxp < p.length()) {
                if (s.charAt(idxs) == p.charAt(idxp) || p.charAt(idxp) == '?') {
                    ++idxp;
                    ++idxs;
                    continue;
                }
                if (p.charAt(idxp) == '*') {
                    idxstar = idxp++;
                    idxmatch = idxs;
                    continue;
                }
            }
            if (idxstar != -1) {
                idxp = idxstar + 1;
                idxs = ++idxmatch;
                continue;
            }
            return false;
        }
        while (idxp < p.length() && p.charAt(idxp) == '*') {
            ++idxp;
        }
        return idxp == p.length();
    }

    public static String getHashName(String str) {
        byte[] bytes = DigestUtils.md5((String)str);
        BigInteger bigInteger = new BigInteger(1, bytes);
        return bigInteger.toString(35).toUpperCase();
    }

    public static String hyphen2Camel(String str) {
        return str.indexOf("-") >= 0 ? CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, str) : str;
    }

    public static String camel2Hyphen(String str) {
        return str.indexOf("-") >= 0 ? str : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, str);
    }
}

