/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cattleframework.exception.CattleException;
import org.cattleframework.utils.auxiliary.StringUtils;

public class StringTemplate {
    public static final String REGEX_PATTERN_JAVA_STYLE = "\\$\\{([^\\}]*)\\}";
    public static final String REGEX_PATTERN_UNIX_SHELL_STYLE = "\\$([a-zA-Z_]+)";
    private Map<String, String> varExpMap = new HashMap<String, String>();
    private Map<String, String> varValueMap = new HashMap<String, String>();
    private String templateString;

    public StringTemplate(String templateString, String templateRegex) {
        Pattern p = Pattern.compile(templateRegex);
        Matcher m = p.matcher(templateString);
        while (m.find()) {
            if (m.groupCount() != 1) {
                throw new CattleException("\u6a21\u5f0f'" + templateRegex + "'\u662f\u65e0\u6548\u7684,\u5b83\u5fc5\u987b\u5305\u542b\u4e14\u53ea\u5305\u542b\u4e00\u4e2a\u6b63\u5219\u8868\u8fbe\u5f0f");
            }
            this.varExpMap.put(m.group(1), m.group(0));
        }
        this.templateString = templateString;
    }

    public String[] getVariables() {
        return this.varExpMap.keySet().toArray(new String[0]);
    }

    public void setVariable(String varName, String varValue) {
        this.varValueMap.put(varName, varValue);
    }

    public String getParseResult() {
        Iterator<Map.Entry<String, String>> itr = this.varExpMap.entrySet().iterator();
        String tmp = this.templateString;
        while (itr.hasNext()) {
            Map.Entry<String, String> en = itr.next();
            String varName = en.getKey();
            String varExp = en.getValue();
            String val = this.varValueMap.get(varName);
            if (val == null) continue;
            tmp = StringUtils.replace(tmp, varExp, val);
        }
        return tmp;
    }

    public void reset() {
        this.varValueMap.clear();
    }
}

