/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.cattleframework.exception.ExceptionWrapUtils;

public final class StreamUtils {
    private static final int READ_BUFFER_LENGTH = 1024;

    private StreamUtils() {
    }

    public static String inputStream2String(InputStream is) {
        return StreamUtils.inputStream2String(is, "UTF-8");
    }

    public static String inputStream2String(InputStream is, String charset) {
        byte[] bytes = StreamUtils.inputStream2Bytes(is);
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static byte[] inputStream2Bytes(InputStream is) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int c;
            byte[] buffer = new byte[1024];
            while ((c = is.read(buffer, 0, 1024)) > 0) {
                baos.write(buffer, 0, c);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ExceptionWrapUtils.wrap((Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }
}

