/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.ArrayUtils;
import org.cattleframework.exception.CattleException;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(Object object) {
        if (object == null) {
            return new byte[0];
        }
        if (!(object instanceof Serializable)) {
            throw new CattleException("\u7c7b'" + object.getClass().getName() + "'\u6ca1\u6709\u7ee7\u627fSerializable");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(object);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new CattleException("\u4e0d\u80fd\u591f\u88ab\u5e8f\u5217\u5316:" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] bytes) {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CattleException("\u4e0d\u80fd\u591f\u88ab\u53cd\u5e8f\u5217\u5316:" + e.getMessage(), (Throwable)e);
        }
    }
}

