/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public final class NetUtils {
    private static final String DEFAULT_INET4_ADDRESS = "127.0.0.1";

    private NetUtils() {
    }

    public static Set<InetAddress> getInet4Addresses() {
        HashSet<InetAddress> inetAddresses = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    inetAddresses.add(address);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return inetAddresses;
    }

    public static Set<InetAddress> getInet6Addresses() {
        HashSet<InetAddress> inetAddresses = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp() && ifc.isVirtual() && ifc.isLoopback()) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet6Address) || address.isLoopbackAddress() || address.isLinkLocalAddress() || address.isAnyLocalAddress() || address.isSiteLocalAddress() || NetUtils.isUniqueLocalAddress(address)) continue;
                    inetAddresses.add(address);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inetAddresses;
    }

    public static InetAddress findFirstInet4Address() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp() || ifc.getIndex() >= lowest && result != null) continue;
                lowest = ifc.getIndex();
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    result = address;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static InetAddress findFirstInet6Address() {
        InetAddress result = null;
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            block4: while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp() && ifc.isVirtual() && ifc.isLoopback()) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress inetAddress = addrs.nextElement();
                    if (!(inetAddress instanceof Inet6Address) || inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isAnyLocalAddress() || inetAddress.isSiteLocalAddress() || NetUtils.isUniqueLocalAddress(inetAddress)) continue;
                    result = inetAddress;
                    continue block4;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static boolean isUniqueLocalAddress(InetAddress inetAddress) {
        byte[] ip = inetAddress.getAddress();
        return (ip[0] & 0xFF) == 253;
    }

    public static InetAddress getLocalHost() {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localHost;
    }

    public static String getHostAddress(InetAddress inetAddress) {
        int index;
        if (inetAddress == null) {
            return DEFAULT_INET4_ADDRESS;
        }
        String hostAddress = inetAddress.getHostAddress();
        if (inetAddress instanceof Inet6Address && (index = hostAddress.indexOf("%")) != -1) {
            hostAddress = hostAddress.substring(0, index);
        }
        return hostAddress;
    }
}

