/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.cattleframework.exception.ExceptionWrapUtils;

public final class JacksonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JacksonUtils() {
    }

    public static <T> String toJson(T object) {
        return JacksonUtils.toJson(object, false);
    }

    public static <T> String toJson(T object, boolean pretty) {
        try {
            if (pretty) {
                ObjectWriter objectWriter = MAPPER.writerWithDefaultPrettyPrinter();
                return objectWriter.writeValueAsString(object);
            }
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> byte[] toJsonBytes(T object) {
        return JacksonUtils.toJsonBytes(object, false);
    }

    public static <T> byte[] toJsonBytes(T object, boolean pretty) {
        try {
            if (pretty) {
                ObjectWriter objectWriter = MAPPER.writerWithDefaultPrettyPrinter();
                return objectWriter.writeValueAsBytes(object);
            }
            return MAPPER.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> void toJsonOutputStream(T object, OutputStream outputStream) {
        JacksonUtils.toJsonOutputStream(object, outputStream, false);
    }

    public static <T> void toJsonOutputStream(T object, OutputStream outputStream, boolean pretty) {
        try {
            if (pretty) {
                ObjectWriter objectWriter = MAPPER.writerWithDefaultPrettyPrinter();
                objectWriter.writeValue(outputStream, object);
            } else {
                MAPPER.writeValue(outputStream, object);
            }
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(String json, Class<T> type) {
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(String json, Type type) {
        try {
            return (T)MAPPER.readValue(json, MAPPER.constructType(type));
        }
        catch (JsonProcessingException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> typeReference) {
        try {
            return (T)MAPPER.readValue(json, typeReference);
        }
        catch (JsonProcessingException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(byte[] jsonBytes, Class<T> type) {
        try {
            return (T)MAPPER.readValue(jsonBytes, type);
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(byte[] jsonBytes, Type type) {
        try {
            return (T)MAPPER.readValue(jsonBytes, MAPPER.constructType(type));
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(byte[] jsonBytes, TypeReference<T> typeReference) {
        try {
            return (T)MAPPER.readValue(jsonBytes, typeReference);
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(InputStream inputStream, Class<T> type) {
        try {
            return (T)MAPPER.readValue(inputStream, type);
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(InputStream inputStream, Type type) {
        try {
            return (T)MAPPER.readValue(inputStream, MAPPER.constructType(type));
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static <T> T toObject(InputStream inputStream, TypeReference<T> typeReference) {
        try {
            return (T)MAPPER.readValue(inputStream, typeReference);
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    static {
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

