/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.exception.CattleException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServerHttpRequest;

public final class HttpUtils {
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String UNKNOWN = "unknown";
    private static final String LOCAL_HOST_IP_V6 = "0:0:0:0:0:0:0:1";
    private static final String COMMA = ",";

    private HttpUtils() {
    }

    public static boolean isSsl(String url) {
        String lUrl = url.toLowerCase();
        if (lUrl.startsWith(HTTPS_PREFIX) || lUrl.startsWith(HTTP_PREFIX)) {
            return lUrl.startsWith(HTTPS_PREFIX);
        }
        throw new CattleException("\u65e0\u6548\u7684URL\u5730\u5740:" + url);
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        String str = null;
        if (request.getCookies() != null) {
            for (int i = 0; i < request.getCookies().length; ++i) {
                if (!request.getCookies()[i].getName().equalsIgnoreCase(name)) continue;
                str = request.getCookies()[i].getValue();
                break;
            }
        }
        return str;
    }

    public static String getParameterValue(HttpServletRequest request, String name) {
        String result = null;
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.equalsIgnoreCase(name)) continue;
            result = request.getParameter(parameterName);
            break;
        }
        return result;
    }

    public static String getHeaderValue(HttpServletRequest request, String name) {
        String result = null;
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!headerName.equalsIgnoreCase(name)) continue;
            result = request.getHeader(headerName);
            break;
        }
        return result;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = HttpUtils.getHeaderValue(request, "x-forwarded-for");
        if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip) && ip.indexOf(COMMA) != -1) {
            ip = ip.split(COMMA)[0];
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "X-Real-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (LOCAL_HOST_IP_V6.equals(ip)) {
            ip = "localhost";
        }
        return ip;
    }

    public static String getHeaderValue(ServerHttpRequest request, String name) {
        String result = null;
        HttpHeaders headers = request.getHeaders();
        for (String headerName : headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            result = headers.getFirst(headerName);
            break;
        }
        return result;
    }

    public static String getIpAddress(ServerHttpRequest request) {
        String ip = HttpUtils.getHeaderValue(request, "x-forwarded-for");
        if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip) && ip.indexOf(COMMA) != -1) {
            ip = ip.split(COMMA)[0];
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = HttpUtils.getHeaderValue(request, "X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddress().getAddress().getHostAddress();
        }
        if (LOCAL_HOST_IP_V6.equals(ip)) {
            ip = "localhost";
        }
        return ip;
    }

    public static void saveCookie(HttpServletRequest request, HttpServletResponse response, boolean httpOnly, String name, String value) {
        HttpUtils.saveCookie(request, response, httpOnly, -1, name, value);
    }

    public static void saveCookie(HttpServletRequest request, HttpServletResponse response, boolean httpOnly, int expiry, String name, String value) {
        if (expiry != -1 && expiry <= 0) {
            throw new CattleException("Cookie\u6709\u6548\u671f\u95f4\u79d2\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        Cookie savedRequestCookie = new Cookie(name, value);
        savedRequestCookie.setSecure(request.isSecure());
        savedRequestCookie.setHttpOnly(httpOnly);
        savedRequestCookie.setPath(HttpUtils.getCookiePath(request));
        savedRequestCookie.setMaxAge(expiry);
        response.addCookie(savedRequestCookie);
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, boolean httpOnly, String name) {
        Cookie removeSavedRequestCookie = new Cookie(name, "");
        removeSavedRequestCookie.setSecure(request.isSecure());
        removeSavedRequestCookie.setHttpOnly(httpOnly);
        removeSavedRequestCookie.setPath(HttpUtils.getCookiePath(request));
        removeSavedRequestCookie.setMaxAge(0);
        response.addCookie(removeSavedRequestCookie);
    }

    private static String getCookiePath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath : "/";
    }
}

