/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import org.apache.commons.lang3.StringUtils;
import org.cattleframework.utils.auxiliary.StringTemplate;

public final class EnvUtils {
    private EnvUtils() {
    }

    public static String getEnvValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        StringTemplate st = new StringTemplate(value, "\\$\\{([^\\}]*)\\}");
        String[] envVars = st.getVariables();
        for (int i = 0; i < envVars.length; ++i) {
            String val = System.getProperty(envVars[i]);
            if (StringUtils.isEmpty((CharSequence)val)) {
                val = System.getenv(envVars[i]);
            }
            if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
            st.setVariable(envVars[i], val);
        }
        return st.getParseResult();
    }
}

