/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.StringTokenizer;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Dom4jUtils {
    private static final String XML_MARK = "<?xml";

    private Dom4jUtils() {
    }

    private static SAXReader getReader() {
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return reader;
        }
        catch (SAXException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static Document getDocument(InputStream is) {
        try {
            SAXReader reader = Dom4jUtils.getReader();
            return reader.read(is);
        }
        catch (DocumentException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    public static Document getDocument(URL url) {
        Document document;
        block8: {
            SAXReader reader = Dom4jUtils.getReader();
            InputStream is = url.openStream();
            try {
                document = reader.read(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | DocumentException e) {
                    throw ExceptionWrapUtils.wrap((Throwable)e);
                }
            }
            is.close();
        }
        return document;
    }

    public static Document getDocument(String xml) {
        SAXReader reader = Dom4jUtils.getReader();
        String encoding = Dom4jUtils.getEncoding(xml);
        InputSource source = new InputSource(new StringReader(xml));
        source.setEncoding(encoding);
        try {
            Document result = reader.read(source);
            if (result.getXMLEncoding() == null) {
                result.setXMLEncoding(encoding);
            }
            return result;
        }
        catch (DocumentException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    private static String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith(XML_MARK)) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens.hasMoreTokens()) break;
                result = tokens.nextToken();
                break;
            }
        }
        return result;
    }

    public static String asXmlWithoutPretty(Document document, String enc) {
        return Dom4jUtils.asXml(document, enc, false);
    }

    public static String asXmlWithPretty(Document document, String enc) {
        return Dom4jUtils.asXml(document, enc, true);
    }

    private static String asXml(Document document, String enc, boolean isPretty) {
        XMLWriter writer = null;
        ByteArrayOutputStream bout = null;
        try {
            String xml = "";
            OutputFormat format = null;
            format = isPretty ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
            format.setEncoding(enc);
            format.setTrimText(false);
            format.setExpandEmptyElements(false);
            format.setNewLineAfterDeclaration(false);
            bout = new ByteArrayOutputStream();
            writer = new XMLWriter((OutputStream)bout, format);
            if (document != null) {
                writer.write(document);
                xml = bout.toString(enc);
            }
            String string = xml;
            return string;
        }
        catch (IOException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (bout != null) {
                    bout.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String asXmlWithoutPretty(Element element, String enc) {
        return Dom4jUtils.asXml(element, enc, false);
    }

    public static String asXmlWithPretty(Element element, String enc) {
        return Dom4jUtils.asXml(element, enc, true);
    }

    private static String asXml(Element element, String enc, boolean isPretty) {
        XMLWriter writer = null;
        try {
            String string;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                String xml = "";
                OutputFormat format = null;
                format = isPretty ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
                format.setEncoding(enc);
                format.setTrimText(false);
                format.setExpandEmptyElements(false);
                format.setNewLineAfterDeclaration(false);
                writer = new XMLWriter((OutputStream)baos, format);
                if (element != null) {
                    writer.write(element);
                    xml = baos.toString(enc);
                }
                string = xml;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionWrapUtils.wrap((Throwable)e);
                }
            }
            baos.close();
            return string;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

