/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import java.util.Calendar;
import java.util.Date;
import org.cattleframework.exception.CattleException;

public final class DateUtils {
    private DateUtils() {
    }

    public static int getYear(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Date getDate(int year, int month, int day) {
        return DateUtils.getDate(year, month, day, 0, 0, 0, 0);
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int second) {
        return DateUtils.getDate(year, month, day, hour, minute, second, 0);
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        int calendarMonth = switch (month) {
            case 1 -> 0;
            case 2 -> 1;
            case 3 -> 2;
            case 4 -> 3;
            case 5 -> 4;
            case 6 -> 5;
            case 7 -> 6;
            case 8 -> 7;
            case 9 -> 8;
            case 10 -> 9;
            case 11 -> 10;
            case 12 -> 11;
            default -> throw new CattleException("\u65e0\u6548\u7684\u6708\u4efd:" + month);
        };
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, calendarMonth);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static Date getNextDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date getNextWeekDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 7);
        return calendar.getTime();
    }

    public static Date getNextMonthDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static Date getNextYearDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        return calendar.getTime();
    }

    public static int getMonthDays(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.getDate(year, month, 1));
        return calendar.getActualMaximum(5);
    }
}

