/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.exception.CattleException;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.cattleframework.utils.reflect.ReflectUtils;
import org.cattleframework.utils.reflect.constant.ClassType;

public final class DataConvertUtils {
    private DataConvertUtils() {
    }

    public static <T> T convertValue(Object value, Class<T> type) {
        return (T)DataConvertUtils.convertValue(ReflectUtils.getClassType(type), value);
    }

    public static Object convertValue(ClassType type, Object value) {
        return DataConvertUtils.convertValue(type, null, value);
    }

    public static Object convertValue(ClassType type, Class<?> typeClass, Object value) {
        Object obj = null;
        if (value != null) {
            ClassType valueType = ReflectUtils.getClassType(value.getClass());
            if (type == ClassType.String || valueType != ClassType.String || !StringUtils.isBlank((CharSequence)value.toString())) {
                if (type != valueType) {
                    if (type == ClassType.Long) {
                        obj = DataConvertUtils.convertLong(valueType, value);
                    } else if (type == ClassType.BigDecimal) {
                        obj = DataConvertUtils.convertBigDecimal(valueType, value);
                    } else if (type == ClassType.Int) {
                        obj = DataConvertUtils.convertInt(valueType, value);
                    } else if (type == ClassType.Double) {
                        obj = DataConvertUtils.convertDouble(valueType, value);
                    } else if (type == ClassType.String) {
                        obj = DataConvertUtils.convertString(valueType, value);
                    } else if (type == ClassType.Array) {
                        obj = DataConvertUtils.convertArray(typeClass, valueType, value);
                    } else if (type == ClassType.Boolean) {
                        obj = DataConvertUtils.convertBoolean(valueType, value);
                    } else if (type == ClassType.Date) {
                        obj = DataConvertUtils.convertDate(valueType, value);
                    } else if (type == ClassType.Timestamp) {
                        obj = DataConvertUtils.convertTimestamp(valueType, value);
                    } else if (type == ClassType.Time) {
                        obj = DataConvertUtils.convertTime(valueType, value);
                    } else if (type == ClassType.SqlDate) {
                        obj = DataConvertUtils.convertSqlDate(valueType, value);
                    } else if (type == ClassType.Object) {
                        obj = value;
                    } else if (type == ClassType.Enum) {
                        obj = DataConvertUtils.convertEnum(typeClass, valueType, value);
                    } else if (type == ClassType.ClassObject) {
                        obj = DataConvertUtils.convertClassObject(typeClass, valueType, value);
                    }
                    if (obj == null) {
                        throw new CattleException("\u6ca1\u6709\u76f8\u5e94\u8f6c\u6362\u673a\u5236(\u6570\u636e\u7c7b\u578b:" + valueType.toString() + ",\u5b57\u6bb5\u7c7b\u578b:" + type.toString() + (String)(type == ClassType.ClassObject ? "[\u7c7b:" + typeClass.getCanonicalName() + "]" : "") + ")");
                    }
                } else {
                    if (type == ClassType.ClassObject && typeClass != value.getClass() && !typeClass.isAssignableFrom(value.getClass())) {
                        throw new CattleException("\u7c7b\u6ca1\u6709\u76f8\u5e94\u8f6c\u6362\u673a\u5236(\u6570\u636e\u7c7b:" + value.getClass().getCanonicalName() + ",\u5b57\u6bb5\u7c7b:" + typeClass.getCanonicalName() + ")");
                    }
                    if (type == ClassType.Array && ReflectUtils.getClassType(typeClass) != ReflectUtils.getClassType(value.getClass().getComponentType())) {
                        throw new CattleException("\u6570\u7ec4\u6ca1\u6709\u76f8\u5e94\u8f6c\u6362\u673a\u5236(\u6570\u636e\u7c7b:" + value.getClass().getCanonicalName() + ",\u5b57\u6bb5\u7c7b:" + typeClass.getCanonicalName() + "[])");
                    }
                    if (type == ClassType.Enum && !typeClass.getCanonicalName().equals(value.getClass().getCanonicalName())) {
                        throw new CattleException("\u679a\u4e3e\u6ca1\u6709\u76f8\u5e94\u8f6c\u6362\u673a\u5236(\u6570\u636e\u7c7b:" + value.getClass().getCanonicalName() + ",\u5b57\u6bb5\u7c7b:" + typeClass.getCanonicalName() + ")");
                    }
                    obj = value;
                }
            }
        }
        return obj;
    }

    private static Object convertString(ClassType valueType, Object value) {
        String result = null;
        if (valueType == ClassType.Array) {
            ClassType itemType = ReflectUtils.getClassType(value.getClass().getComponentType());
            if (itemType == ClassType.Byte) {
                result = Base64.encodeBase64String((byte[])((byte[])value));
            }
        } else {
            result = value.toString();
        }
        return result;
    }

    private static Object convertArray(Class<?> typeClass, ClassType valueType, Object value) {
        ClassType itemType;
        byte[] result = null;
        if (valueType == ClassType.String && (itemType = ReflectUtils.getClassType(typeClass)) == ClassType.Byte) {
            result = Base64.decodeBase64((String)((String)value));
        }
        return result;
    }

    private static Object convertBoolean(ClassType valueType, Object value) {
        Boolean result = null;
        if (valueType == ClassType.BigDecimal) {
            result = ((BigDecimal)value).intValue() == 1;
        } else if (valueType == ClassType.String) {
            result = Boolean.parseBoolean((String)value);
        }
        return result;
    }

    private static Object convertDate(ClassType valueType, Object value) {
        java.util.Date result = null;
        if (valueType == ClassType.Time) {
            result = new java.util.Date(((Time)value).getTime());
        } else if (valueType == ClassType.Timestamp) {
            result = new java.util.Date(((Timestamp)value).getTime());
        } else if (valueType == ClassType.SqlDate) {
            result = new java.util.Date(((Date)value).getTime());
        } else if (valueType == ClassType.Long) {
            result = new java.util.Date((Long)value);
        }
        return result;
    }

    private static Object convertTimestamp(ClassType valueType, Object value) {
        Timestamp result = null;
        if (valueType == ClassType.Date) {
            result = new Timestamp(((java.util.Date)value).getTime());
        } else if (valueType == ClassType.Time) {
            result = new Timestamp(((Time)value).getTime());
        } else if (valueType == ClassType.SqlDate) {
            result = new Timestamp(((Date)value).getTime());
        }
        return result;
    }

    private static Object convertTime(ClassType valueType, Object value) {
        Time result = null;
        if (valueType == ClassType.Date) {
            result = new Time(((java.util.Date)value).getTime());
        } else if (valueType == ClassType.SqlDate) {
            result = new Time(((Date)value).getTime());
        } else if (valueType == ClassType.Timestamp) {
            result = new Time(((Timestamp)value).getTime());
        }
        return result;
    }

    private static Object convertSqlDate(ClassType valueType, Object value) {
        Date result = null;
        if (valueType == ClassType.Date) {
            result = new Date(((java.util.Date)value).getTime());
        } else if (valueType == ClassType.Timestamp) {
            result = new Date(((Timestamp)value).getTime());
        } else if (valueType == ClassType.Time) {
            result = new Date(((Time)value).getTime());
        }
        return result;
    }

    private static Object convertEnum(Class<?> typeClass, ClassType valueType, Object value) {
        Object result = null;
        if (valueType == ClassType.String && typeClass != null) {
            result = ReflectUtils.setEnumValue(typeClass, (String)value);
        }
        return result;
    }

    private static Object convertClassObject(Class<?> typeClass, ClassType valueType, Object value) {
        URI result = null;
        if (valueType == ClassType.String && typeClass == URI.class) {
            try {
                result = new URI((String)value);
            }
            catch (URISyntaxException e) {
                throw ExceptionWrapUtils.wrap((Throwable)e);
            }
        }
        return result;
    }

    private static Object convertDouble(ClassType valueType, Object value) {
        Double result = null;
        if (valueType == ClassType.BigDecimal) {
            result = ((BigDecimal)value).doubleValue();
        } else if (valueType == ClassType.String) {
            result = Double.valueOf(value.toString());
        }
        return result;
    }

    private static Object convertInt(ClassType valueType, Object value) {
        Integer result = null;
        if (valueType == ClassType.BigDecimal) {
            result = ((BigDecimal)value).intValue();
        } else if (valueType == ClassType.String) {
            result = Integer.valueOf(value.toString());
        } else if (valueType == ClassType.Boolean) {
            result = (Boolean)value != false ? 1 : 0;
        } else if (valueType == ClassType.BigInteger) {
            result = ((BigInteger)value).intValue();
        } else if (valueType == ClassType.Long) {
            result = ((Long)value).intValue();
        }
        return result;
    }

    private static Object convertBigDecimal(ClassType valueType, Object value) {
        BigDecimal result = null;
        if (valueType == ClassType.Int) {
            result = new BigDecimal((Integer)value);
        } else if (valueType == ClassType.String) {
            result = new BigDecimal(value.toString());
        } else if (valueType == ClassType.Long) {
            result = new BigDecimal((Long)value);
        } else if (valueType == ClassType.Double) {
            result = new BigDecimal((Double)value);
        } else if (valueType == ClassType.Boolean) {
            result = (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return result;
    }

    private static Object convertLong(ClassType valueType, Object value) {
        Long result = null;
        if (valueType == ClassType.BigDecimal) {
            result = ((BigDecimal)value).longValue();
        } else if (valueType == ClassType.String) {
            result = Long.valueOf(value.toString());
        } else if (valueType == ClassType.Int) {
            result = ((Integer)value).longValue();
        } else if (valueType == ClassType.BigInteger) {
            result = ((BigInteger)value).longValue();
        } else if (valueType == ClassType.Short) {
            result = ((Short)value).longValue();
        }
        return result;
    }
}

