/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.utils.auxiliary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.cattleframework.exception.ExceptionWrapUtils;

public final class CompressUtils {
    private CompressUtils() {
    }

    public static byte[] compress(String name, byte[] datas) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try (CompressorOutputStream cos = CompressorStreamFactory.getSingleton().createCompressorOutputStream(name, (OutputStream)baos);){
                cos.write(datas);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CompressorException e) {
                throw ExceptionWrapUtils.wrap((Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }

    public static byte[] decompress(String name, byte[] datas) {
        byte[] byArray;
        ByteArrayInputStream bais = new ByteArrayInputStream(datas);
        try {
            byArray = CompressUtils.decompress(name, bais);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ExceptionWrapUtils.wrap((Throwable)e);
            }
        }
        bais.close();
        return byArray;
    }

    public static byte[] decompress(String name, InputStream is) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try (CompressorInputStream cis = CompressorStreamFactory.getSingleton().createCompressorInputStream(name, is);){
                byte[] bytes = new byte[1024];
                int count = 0;
                while ((count = cis.read(bytes)) >= 0) {
                    baos.write(bytes, 0, count);
                }
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CompressorException e) {
                throw ExceptionWrapUtils.wrap((Throwable)e);
            }
        }
        baos.close();
        return byArray;
    }
}

